/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.PointerEvent;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRect;

public class SVGSlider
extends SVGComponent {
    private static final String TRANSFORM = "transform";
    private static final int DEFAULT_MAX = 10;
    private static final String KNOB = "knob";
    private static final String RULE = "rule";
    private static final String KNOB_SUFFIX = "_knob";
    private static final String RULE_SUFFIX = "_rule";
    private int myMin;
    private int myMax = 10;
    private int myStep = 1;
    private int myValue;
    private final InputHandler myInputHandler;
    private SVGLocatableElement myKnobElement;
    private SVGLocatableElement myRuleElement;
    private boolean isHorizontal = true;

    public SVGSlider(SVGForm form, String elemId) {
        super(form, elemId);
        this.initNestedElements();
        this.verify();
        this.myInputHandler = new SliderInputHandler();
        this.myValue = this.myMin;
    }

    public SVGSlider(int min, int max, SVGForm form, String elemId) {
        this(form, elemId);
        this.myMin = min;
        this.myMax = max;
    }

    public int getValue() {
        return this.myValue;
    }

    public InputHandler getInputHandler() {
        return this.myInputHandler;
    }

    public void setValue(int value) {
        int val = value;
        if (val > this.myMax) {
            val = this.myMax;
        }
        if (val < this.myMin) {
            val = this.myMin;
        }
        final int step = val - this.myValue;
        if (this.myMax == this.myMin) {
            return;
        }
        final int max = this.myMax;
        final int min = this.myMin;
        this.getForm().invokeLaterSafely(new Runnable(){

            public void run() {
                SVGRect rect = SVGSlider.this.myRuleElement.getBBox();
                float width = rect.getWidth();
                SVGMatrix matrix = SVGSlider.this.myKnobElement.getMatrixTrait(SVGSlider.TRANSFORM);
                matrix.mTranslate((float)step * width / (float)(max - min), 0.0f);
                SVGSlider.this.myKnobElement.setMatrixTrait(SVGSlider.TRANSFORM, matrix);
            }
        });
        this.myValue = val;
        this.fireActionPerformed();
    }

    public void setMin(int min) {
        int curValue = this.myValue;
        this.setValue(this.myMin);
        this.myMin = min > this.myMax ? this.myMax : min;
        this.myValue = this.myMin;
        this.setValue(curValue);
    }

    public void setMax(int max) {
        int curValue = this.myValue;
        this.setValue(this.myMin);
        this.myMax = max < this.myMin ? this.myMin : max;
        this.myValue = this.myMin;
        this.setValue(curValue);
    }

    public int getMin() {
        return this.myMin;
    }

    public int getMax() {
        return this.myMax;
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myKnobElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + KNOB_SUFFIX);
            this.myRuleElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + RULE_SUFFIX);
        }
        if (this.myKnobElement == null) {
            this.myKnobElement = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", KNOB);
        }
        if (this.myRuleElement == null) {
            this.myRuleElement = (SVGLocatableElement)this.getElementByMeta((SVGElement)this.getElement(), "type", RULE);
        }
        if (this.myRuleElement != null && this.myRuleElement.getBBox() != null) {
            SVGRect rect = this.myRuleElement.getScreenBBox();
            this.isHorizontal = rect.getHeight() < rect.getWidth();
        }
    }

    private void verify() {
        if (this.myRuleElement == null || this.myKnobElement == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be used for Slider." + " It doesn't have nested 'rule' or 'knob' elements." + "See javadoc for SVG snippet format");
        }
    }

    private class SliderInputHandler
    extends InputHandler {
        private boolean isKnobPressed;
        private float myStartKnobX;
        private float myStartKnobY;

        private SliderInputHandler() {
        }

        public boolean handleKeyPress(SVGComponent comp, int keyCode) {
            if (comp instanceof SVGSlider) {
                return keyCode == -3 || keyCode == -4;
            }
            return false;
        }

        public boolean handleKeyRelease(SVGComponent comp, int keyCode) {
            boolean ret = false;
            if (comp instanceof SVGSlider) {
                if (keyCode == -3) {
                    SVGSlider.this.setValue(Math.max(SVGSlider.this.myMin, SVGSlider.this.myValue - SVGSlider.this.myStep));
                    ret = true;
                } else if (keyCode == -4) {
                    SVGSlider.this.setValue(Math.min(SVGSlider.this.myMax, SVGSlider.this.myValue + SVGSlider.this.myStep));
                    ret = true;
                }
            }
            return ret;
        }

        public void handlePointerPress(PointerEvent event) {
            SVGRect rect = SVGSlider.this.myKnobElement.getScreenBBox();
            if (rect == null) {
                super.handlePointerPress(event);
                return;
            }
            this.myStartKnobX = rect.getX();
            this.myStartKnobY = rect.getY();
            if (SVGSlider.this.isHorizontal && this.myStartKnobX <= (float)event.getX() && this.myStartKnobX + rect.getWidth() >= (float)event.getX()) {
                this.isKnobPressed = true;
            } else if (!SVGSlider.this.isHorizontal && this.myStartKnobY <= (float)event.getY() && this.myStartKnobY + rect.getHeight() >= (float)event.getY()) {
                this.isKnobPressed = true;
            }
            super.handlePointerPress(event);
        }

        public void handlePointerRelease(PointerEvent event) {
            float coord;
            SVGRect rect = SVGSlider.this.myKnobElement.getScreenBBox();
            if (rect == null) {
                super.handlePointerRelease(event);
                return;
            }
            float knob = SVGSlider.this.isHorizontal ? rect.getX() : rect.getY();
            float f = coord = SVGSlider.this.isHorizontal ? (float)event.getX() : (float)event.getY();
            if (this.isKnobPressed) {
                this.isKnobPressed = false;
                SVGRect ruleRect = SVGSlider.this.myRuleElement.getScreenBBox();
                if (ruleRect == null) {
                    super.handlePointerRelease(event);
                    return;
                }
                float factor = SVGSlider.this.isHorizontal ? ((float)event.getX() - ruleRect.getX()) / ruleRect.getWidth() : ((float)event.getY() - ruleRect.getY()) / ruleRect.getHeight();
                SVGSlider.this.setValue(SVGSlider.this.myMin + (int)(factor * (float)(SVGSlider.this.myMax - SVGSlider.this.myMin)));
            } else if (knob > coord) {
                SVGSlider.this.setValue(Math.max(SVGSlider.this.myMin, SVGSlider.this.myValue - SVGSlider.this.myStep));
            } else {
                SVGSlider.this.setValue(Math.min(SVGSlider.this.myMax, SVGSlider.this.myValue + SVGSlider.this.myStep));
            }
            super.handlePointerRelease(event);
        }
    }
}

