/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.blame;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.DateFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.blame.AnnotateLine;
import org.netbeans.modules.subversion.ui.blame.AnnotationBar;
import org.netbeans.modules.versioning.util.HyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.openide.text.NbDocument;

class TooltipWindow
implements AWTEventListener,
MouseMotionListener,
MouseListener,
WindowFocusListener {
    private static final int SCREEN_BORDER = 20;
    private final AnnotationBar master;
    private JTextPane textPane;
    private final AnnotateLine annotateLine;
    private int messageOffset;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();
    private JWindow contentWindow;
    private TooltipContentPanel cp;

    public TooltipWindow(AnnotationBar annotationBar, AnnotateLine annotateLine) {
        this.annotateLine = annotateLine;
        this.master = annotationBar;
    }

    public void show(Point point) {
        GraphicsDevice graphicsDevice;
        GraphicsConfiguration graphicsConfiguration;
        Rectangle rectangle = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Object object = graphicsDeviceArray;
        int n = ((GraphicsDevice[])object).length;
        for (int i = 0; i < n && !(rectangle = (graphicsConfiguration = (graphicsDevice = object[i]).getDefaultConfiguration()).getBounds()).contains(point); ++i) {
        }
        this.cp = new TooltipContentPanel(this.master.getTextComponent());
        object = SwingUtilities.windowForComponent(this.master.getTextComponent());
        this.contentWindow = new JWindow((Window)object);
        this.contentWindow.add(this.cp);
        this.contentWindow.pack();
        Dimension dimension = this.contentWindow.getSize();
        if (point.y + dimension.height + 20 > rectangle.y + rectangle.height) {
            dimension.height = rectangle.y + rectangle.height - (point.y + 20);
        }
        if (point.x + dimension.width + 20 > rectangle.x + rectangle.width) {
            dimension.width = rectangle.x + rectangle.width - (point.x + 20);
        }
        this.contentWindow.setSize(dimension);
        this.contentWindow.setLocation(point.x, point.y - 1);
        this.contentWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        ((Window)object).addWindowFocusListener(this);
        this.contentWindow.addWindowFocusListener(this);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501 || aWTEvent.getID() == 401) {
            this.onClick(aWTEvent);
        }
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        if (this.outsideOfTooltipWindow(component)) {
            this.shutdown();
        }
    }

    private boolean outsideOfTooltipWindow(Component component) {
        boolean bl = true;
        while (component != null) {
            if (component instanceof TooltipContentPanel) {
                bl = false;
                break;
            }
            component = component.getParent();
        }
        return bl;
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.contentWindow != null) {
            this.contentWindow.getOwner().removeWindowFocusListener(this);
            this.contentWindow.removeWindowFocusListener(this);
            this.contentWindow.dispose();
        }
        this.contentWindow = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.textPane)) {
            this.textPane.setCursor(Cursor.getPredefinedCursor(0));
            this.linkerSupport.computeBounds(this.textPane, 0);
            this.linkerSupport.mouseMoved(mouseEvent.getPoint(), (JComponent)this.textPane, this.messageOffset);
        }
        this.textPane.setToolTipText("");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.textPane)) {
            this.linkerSupport.computeBounds(this.textPane, 0);
            if (this.linkerSupport.mouseClicked(mouseEvent.getPoint(), 0)) {
                this.shutdown();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.contentWindow != null && windowEvent.getOppositeWindow() != this.contentWindow && windowEvent.getOppositeWindow() != this.contentWindow.getOwner()) {
            this.shutdown();
        }
    }

    private class TooltipContentPanel
    extends JComponent {
        public TooltipContentPanel(JTextComponent jTextComponent) {
            try {
                Object object2;
                TooltipWindow.this.textPane = new JTextPane();
                StyledDocument styledDocument = (StyledDocument)TooltipWindow.this.textPane.getDocument();
                Style style = TooltipWindow.this.textPane.getStyle("normal");
                Style style2 = TooltipWindow.this.textPane.addStyle("hyperlink", style);
                StyleConstants.setForeground(style2, Color.BLUE);
                StyleConstants.setUnderline(style2, true);
                Style style3 = TooltipWindow.this.textPane.addStyle("author", style);
                StyleConstants.setForeground(style3, Color.BLUE);
                styledDocument.insertString(styledDocument.getLength(), TooltipWindow.this.annotateLine.getRevision() + " - ", style);
                String string = TooltipWindow.this.annotateLine.getAuthor();
                VCSHyperlinkSupport.Linker linker = TooltipWindow.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, 0);
                if (TooltipWindow.this.master.isKenai() && (object2 = TooltipWindow.this.master.getKenaiUser(string)) != null) {
                    linker = new VCSHyperlinkSupport.AuthorLinker(object2, style3, styledDocument, string, VCSKenaiSupport.KenaiUser.getChatLink((Document)TooltipWindow.this.master.getdDocument(), (int)TooltipWindow.this.annotateLine.getLineNum()));
                    TooltipWindow.this.linkerSupport.add(linker, 0);
                }
                if (linker != null) {
                    linker.insertString(styledDocument, style3);
                } else {
                    styledDocument.insertString(styledDocument.getLength(), string, style);
                }
                styledDocument.insertString(styledDocument.getLength(), " ", style);
                styledDocument.insertString(styledDocument.getLength(), DateFormat.getDateInstance().format(TooltipWindow.this.annotateLine.getDate()), style);
                styledDocument.insertString(styledDocument.getLength(), "\n", style);
                object2 = TooltipWindow.this.annotateLine.getCommitMessage();
                List<HyperlinkProvider> list = Subversion.getInstance().getHyperlinkProviders();
                for (HyperlinkProvider object3 : list) {
                    linker = VCSHyperlinkSupport.IssueLinker.create((HyperlinkProvider)object3, (Style)style2, (File)TooltipWindow.this.master.getFile(), (StyledDocument)styledDocument, (String)object2);
                    if (linker == null) continue;
                    TooltipWindow.this.linkerSupport.add(linker, 0);
                    break;
                }
                if (linker != null) {
                    linker.insertString(styledDocument, style);
                } else {
                    styledDocument.insertString(styledDocument.getLength(), (String)object2, style);
                }
                TooltipWindow.this.textPane.setDocument(styledDocument);
                TooltipWindow.this.textPane.setEditable(false);
                Color color = new Color(233, 241, 255);
                TooltipWindow.this.textPane.setBackground(color);
                Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
                int n = element.getElementCount();
                int n2 = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).getHeight() * (n + 1);
                int n3 = 0;
                for (int jScrollPane = 0; jScrollPane < n; ++jScrollPane) {
                    Element element2 = element.getElement(jScrollPane);
                    String string2 = null;
                    try {
                        string2 = styledDocument.getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    int badLocationException = TooltipWindow.this.textPane.getFontMetrics(TooltipWindow.this.textPane.getFont()).stringWidth(string2);
                    if (badLocationException <= n3) continue;
                    n3 = badLocationException;
                }
                if (n3 < 50) {
                    n3 = 50;
                }
                TooltipWindow.this.textPane.setPreferredSize(new Dimension(n3 * 7 / 6, n2));
                if (!TooltipWindow.this.textPane.isEditable()) {
                    TooltipWindow.this.textPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                }
                TooltipWindow.this.textPane.addMouseListener(TooltipWindow.this);
                TooltipWindow.this.textPane.addMouseMotionListener(TooltipWindow.this);
                JScrollPane jScrollPane = new JScrollPane(TooltipWindow.this.textPane);
                jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
                this.setLayout(new BorderLayout());
                this.add(jScrollPane);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

