/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.hooks.spi.SvnHook;
import org.netbeans.modules.subversion.hooks.spi.SvnHookContext;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitPanel
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener {
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private static final boolean DEFAULT_DISPLAY_FILES = true;
    private static final boolean DEFAULT_DISPLAY_HOOKS = false;
    final JLabel filesLabel = new JLabel();
    private final JPanel filesPanel = new JPanel(new GridLayout(1, 1));
    private final JLabel filesSectionButton = new JLabel();
    private final JPanel filesSectionPanel = new JPanel();
    private final JLabel hooksSectionButton = new JLabel();
    private final PlaceholderPanel hooksSectionPanel = new PlaceholderPanel();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTextArea messageTextArea = new JTextArea();
    private final JLabel recentLink = new JLabel();
    private Icon expandedIcon;
    private Icon collapsedIcon;
    final PlaceholderPanel progressPanel = new PlaceholderPanel();
    private CommitTable commitTable;
    private List<SvnHook> hooks = Collections.emptyList();
    private SvnHookContext hookContext;
    private boolean hooksPanelInitialized;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitPanel() {
        this.initComponents();
        this.initInteraction();
    }

    void setHooks(List<SvnHook> list, SvnHookContext svnHookContext) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.hooks = list;
        this.hookContext = svnHookContext;
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String string) {
        this.jLabel2.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        final List list = Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (list.size() > 0) {
                    CommitPanel.this.messageTextArea.setText((String)list.get(0));
                }
                CommitPanel.this.messageTextArea.selectAll();
            }
        });
        this.initCollapsibleSections();
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    private void initCollapsibleSections() {
        JTree jTree = new JTree();
        BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
        this.expandedIcon = basicTreeUI.getExpandedIcon();
        this.collapsedIcon = basicTreeUI.getCollapsedIcon();
        this.initSectionButton(this.filesSectionButton, this.filesSectionPanel, "initFilesPanel", true);
        if (!this.hooks.isEmpty()) {
            this.hooksSectionButton.setText(this.hooks.size() == 1 ? this.hooks.get(0).getDisplayName() : CommitPanel.getMessage("LBL_Advanced"));
            this.initSectionButton(this.hooksSectionButton, (JPanel)this.hooksSectionPanel, "initHooksPanel", false);
        } else {
            this.hooksSectionButton.setVisible(false);
        }
    }

    private void initSectionButton(final JLabel jLabel, final JPanel jPanel, final String string, boolean bl) {
        if (bl) {
            this.displaySection(jLabel, jPanel, string);
        } else {
            this.hideSection(jLabel, jPanel);
        }
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (jPanel.isVisible()) {
                    CommitPanel.this.hideSection(jLabel, jPanel);
                } else {
                    CommitPanel.this.displaySection(jLabel, jPanel, string);
                }
            }
        });
    }

    private void displaySection(JLabel jLabel, Container container, String string) {
        if (container.getComponentCount() == 0) {
            this.invokeInitPanelMethod(string);
        }
        container.setVisible(true);
        jLabel.setIcon(this.expandedIcon);
        this.enlargeVerticallyAsNecessary();
    }

    private void hideSection(JLabel jLabel, JPanel jPanel) {
        jPanel.setVisible(false);
        jLabel.setIcon(this.collapsedIcon);
    }

    private void invokeInitPanelMethod(String string) {
        try {
            this.getClass().getDeclaredMethod(string, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void initFilesPanel() {
        this.filesPanel.add(this.commitTable.getComponent());
        this.filesPanel.setPreferredSize(new Dimension(0, 2 * this.messageTextArea.getPreferredSize().height));
        this.filesSectionPanel.setLayout(new BoxLayout(this.filesSectionPanel, 1));
        this.filesSectionPanel.add(this.filesLabel);
        this.filesSectionPanel.add(this.makeVerticalStrut(this.filesLabel, this.filesPanel, 0));
        this.filesSectionPanel.add(this.filesPanel);
        this.filesLabel.setAlignmentX(0.0f);
        this.filesPanel.setAlignmentX(0.0f);
    }

    private void initHooksPanel() {
        assert (!this.hooks.isEmpty());
        if (this.hooks.size() == 1) {
            this.hooksSectionPanel.add((Component)this.hooks.get(0).createComponent(this.hookContext));
        } else {
            JTabbedPane jTabbedPane = new JTabbedPane();
            for (SvnHook svnHook : this.hooks) {
                jTabbedPane.add((Component)svnHook.createComponent(this.hookContext), svnHook.getDisplayName());
            }
            this.hooksSectionPanel.add((Component)jTabbedPane);
        }
        this.hooksPanelInitialized = true;
    }

    String getCommitMessage() {
        return SvnUtils.fixLineEndings(this.messageTextArea.getText());
    }

    private void onBrowseRecentMessages() {
        String string = StringSelector.select((String)CommitPanel.getMessage("CTL_CommitForm_RecentTitle"), (String)CommitPanel.getMessage("CTL_CommitForm_RecentPrompt"), (List)Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage"));
        if (string != null) {
            this.messageTextArea.replaceSelection(string);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            Runnable runnable = new Runnable(){

                public void run() {
                    CommitPanel.this.commitTable.dataChanged();
                    CommitPanel.this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.jLabel1.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)CommitPanel.getMessage("CTL_CommitForm_Message"));
        this.recentLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/recent_messages.png")));
        this.recentLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_RecentMessages"));
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.messageTextArea.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitForm_Message"));
        Mnemonics.setLocalizedText((JLabel)this.filesSectionButton, (String)CommitPanel.getMessage("LBL_CommitDialog_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CommitPanel.getMessage("CTL_CommitForm_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.hooksSectionButton, (String)CommitPanel.getMessage("LBL_Advanced"));
        VerticallyNonResizingPanel verticallyNonResizingPanel = new VerticallyNonResizingPanel();
        verticallyNonResizingPanel.setLayout(new BoxLayout((Container)verticallyNonResizingPanel, 0));
        verticallyNonResizingPanel.add(this.jLabel1);
        verticallyNonResizingPanel.add(Box.createHorizontalGlue());
        verticallyNonResizingPanel.add(this.recentLink);
        this.jLabel1.setAlignmentY(1.0f);
        this.recentLink.setAlignmentY(1.0f);
        VerticallyNonResizingPanel verticallyNonResizingPanel2 = new VerticallyNonResizingPanel();
        verticallyNonResizingPanel2.setLayout(new BoxLayout((Container)verticallyNonResizingPanel2, 0));
        verticallyNonResizingPanel2.add((Component)this.progressPanel);
        this.progressPanel.setAlignmentY(0.5f);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)verticallyNonResizingPanel);
        this.add(this.makeVerticalStrut(this.jLabel1, this.jScrollPane1, 0));
        this.add(this.jScrollPane1);
        this.add(this.makeVerticalStrut(this.jScrollPane1, this.filesSectionButton, 0));
        this.add(this.filesSectionButton);
        this.add(this.makeVerticalStrut(this.filesSectionButton, this.filesSectionPanel, 0));
        this.add(this.filesSectionPanel);
        this.add(this.makeVerticalStrut(this.filesSectionPanel, this.hooksSectionButton, 0));
        this.add(this.hooksSectionButton);
        this.add(this.makeVerticalStrut(this.hooksSectionButton, (JComponent)this.hooksSectionPanel, 0));
        this.add((Component)this.hooksSectionPanel);
        this.add(this.makeVerticalStrut((JComponent)this.hooksSectionPanel, this.jLabel2, 0));
        this.add(this.jLabel2);
        this.add(this.makeVerticalStrut((JComponent)this.hooksSectionPanel, (JComponent)verticallyNonResizingPanel2, 0));
        this.add((Component)verticallyNonResizingPanel2);
        verticallyNonResizingPanel.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.filesSectionButton.setAlignmentX(0.0f);
        this.filesSectionPanel.setAlignmentX(0.0f);
        this.hooksSectionButton.setAlignmentX(0.0f);
        this.hooksSectionPanel.setAlignmentX(0.0f);
        verticallyNonResizingPanel2.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder(26, this.getContainerGap(7), 0, 15));
        this.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitDialog"));
        this.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitDialog"));
    }

    private void initInteraction() {
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
    }

    private Component makeVerticalStrut(JComponent jComponent, JComponent jComponent2, int n) {
        int n2 = LayoutStyle.getSharedInstance().getPreferredGap(jComponent, jComponent2, n, 5, (Container)((Object)this));
        return Box.createVerticalStrut(n2);
    }

    private int getContainerGap(int n) {
        return LayoutStyle.getSharedInstance().getContainerGap((JComponent)((Object)this), n, null);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CommitPanel.class, (String)string);
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    boolean isHooksPanelInitialized() {
        return this.hooksPanelInitialized;
    }
}

