/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.Merge;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Merge";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1 && this.getCachedContext(nodeArray).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        final File[] fileArray = SvnUtils.getActionRoots(context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = fileArray.length == 1 ? fileArray[0] : SvnUtils.getPrimaryFile(fileArray[0]);
        try {
            sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        final RepositoryFile repositoryFile = new RepositoryFile(sVNUrl2, sVNUrl, SVNRevision.HEAD);
        final Merge merge = new Merge(repositoryFile, file);
        if (merge.showDialog()) {
            ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

                public void perform() {
                    for (File file : fileArray) {
                        MergeAction.this.performMerge(merge, repositoryFile, file, this, fileArray.length > 1);
                    }
                }
            };
            progressSupport.start(this.createRequestProcessor(nodeArray));
        }
    }

    private void performMerge(Merge merge, RepositoryFile repositoryFile, File file, SvnProgressSupport svnProgressSupport, boolean bl) {
        File[][] fileArray = Utils.splitFlatOthers((File[])new File[]{file});
        boolean bl2 = fileArray[0].length <= 0;
        try {
            SVNRevision sVNRevision;
            SVNUrl sVNUrl;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            SVNUrl sVNUrl2 = merge.getMergeEndRepositoryFile().getFileUrl();
            SVNRevision sVNRevision2 = merge.getMergeEndRevision();
            RepositoryFile repositoryFile2 = merge.getMergeStartRepositoryFile();
            SVNUrl sVNUrl3 = sVNUrl = repositoryFile2 != null ? repositoryFile2.getFileUrl() : null;
            if (file.isFile() && bl) {
                sVNUrl2 = merge.getMergeEndRepositoryFile().replaceLastSegment(file.getName(), 0).getFileUrl();
                SVNUrl sVNUrl4 = sVNUrl = repositoryFile2 != null ? repositoryFile2.replaceLastSegment(file.getName(), 0).getFileUrl() : null;
            }
            if (sVNUrl != null) {
                sVNRevision = merge.getMergeStartRevision();
            } else {
                sVNUrl = sVNUrl2;
                ISVNLogMessage[] iSVNLogMessageArray = svnClient.getLogMessages(sVNUrl, (SVNRevision)new SVNRevision.Number(0L), (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, false, 0L);
                sVNRevision = iSVNLogMessageArray[0].getRevision();
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            svnClient.merge(sVNUrl, sVNRevision, sVNUrl2, sVNRevision2, file, false, bl2);
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }
}

