/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.DiffResultsView;
import org.netbeans.modules.subversion.ui.history.DiffStreamSource;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DiffResultsViewForLine
extends DiffResultsView {
    private int lineNumber;

    public DiffResultsViewForLine(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list, int n) {
        super(searchHistoryPanel, list);
        this.lineNumber = Math.max(n - 1, 0);
        this.setButtonLabels();
    }

    @Override
    protected void showRevisionDiff(RepositoryRevision.Event event, boolean bl) {
        if (event.getFile() == null) {
            return;
        }
        long l = event.getLogInfoHeader().getLog().getRevision().getNumber();
        this.showDiff(event, null, Long.toString(l), bl);
    }

    @Override
    protected SvnProgressSupport createShowDiffTask(RepositoryRevision.Event event, String string, String string2, boolean bl) {
        if (string == null) {
            return new ShowDiffTask(event, string, string2, bl);
        }
        return super.createShowDiffTask(event, string, string2, bl);
    }

    @Override
    void onNextButton() {
        if (++this.currentIndex >= this.treeView.getRowCount()) {
            this.currentIndex = 0;
        }
        this.setDiffIndex(this.currentIndex, false);
    }

    @Override
    void onPrevButton() {
        if (--this.currentIndex < 0) {
            this.currentIndex = this.treeView.getRowCount() - 1;
        }
        this.setDiffIndex(this.currentIndex, true);
    }

    private void setButtonLabels() {
        this.parent.bNext.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSN_NextRevision"));
        this.parent.bNext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_NextRevision"));
        this.parent.bNext.setToolTipText(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_NextRevision"));
        this.parent.bPrev.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSN_PrevRevision"));
        this.parent.bPrev.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_PrevRevision"));
        this.parent.bPrev.setToolTipText(NbBundle.getMessage(DiffResultsViewForLine.class, (String)"ACSD_PrevRevision"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastLineIndex(StreamSource streamSource) {
        StyledDocument styledDocument;
        block19: {
            Document document;
            String string = streamSource.getMIMEType();
            if (string == null || !string.startsWith("text/")) {
                Subversion.LOG.log(Level.INFO, "Wrong mime type");
                return 0;
            }
            EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
            if (editorKit == null) {
                Subversion.LOG.log(Level.WARNING, "No editor kit available");
                return 0;
            }
            Document document2 = this.getSourceDocument(streamSource);
            Document document3 = document = document2 != null ? document2 : editorKit.createDefaultDocument();
            if (document instanceof StyledDocument) {
                styledDocument = (StyledDocument)document;
            } else {
                styledDocument = new DefaultStyledDocument(new StyleContext());
                editorKit = new StyledEditorKit();
            }
            if (document2 == null) {
                Reader reader = null;
                try {
                    reader = streamSource.createReader();
                    if (reader == null) break block19;
                    try {
                        editorKit.read(reader, (Document)styledDocument, 0);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IOException("Can not locate the beginning of the document.");
                    }
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.INFO, null, iOException);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Subversion.LOG.log(Level.INFO, null, iOException);
                    }
                }
            }
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)styledDocument.getEndPosition().getOffset());
    }

    private Document getSourceDocument(StreamSource streamSource) {
        Document document = null;
        FileObject fileObject = (FileObject)streamSource.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            try {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject.getPrimaryFile() == fileObject && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                    document = editorCookie.openDocument();
                }
            }
            catch (Exception exception) {}
        } else {
            document = (Document)streamSource.getLookup().lookup(Document.class);
        }
        return document;
    }

    private void setLocation(int n, boolean bl) {
        if (this.currentDiff == null) {
            return;
        }
        if (bl) {
            this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.LineNumber, n);
        } else {
            this.currentDiff.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, n);
        }
    }

    private static class LocalFileDiffStreamSource
    extends StreamSource {
        private final FileObject fileObject;
        private final boolean isRight;
        private File file;
        private String mimeType;

        public LocalFileDiffStreamSource(File file, boolean bl) {
            this.file = FileUtil.normalizeFile((File)file);
            this.fileObject = FileUtil.toFileObject((File)this.file);
            this.isRight = bl;
        }

        public boolean isEditable() {
            return this.isRight && this.fileObject != null && this.fileObject.canWrite();
        }

        public Lookup getLookup() {
            if (this.fileObject != null) {
                return Lookups.fixed((Object[])new Object[]{this.fileObject});
            }
            return Lookups.fixed((Object[])new Object[0]);
        }

        public String getName() {
            return this.file.getName();
        }

        public String getTitle() {
            return this.fileObject != null ? FileUtil.getFileDisplayName((FileObject)this.fileObject) : this.file.getAbsolutePath();
        }

        public String getMIMEType() {
            this.mimeType = this.fileObject != null && this.fileObject.isValid() ? SvnUtils.getMimeType(this.file) : null;
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            if (this.mimeType == null || !this.mimeType.startsWith("text/")) {
                return null;
            }
            return Utils.createReader((File)this.file);
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }
    }

    private class ShowDiffTask
    extends SvnProgressSupport {
        private final RepositoryRevision.Event header;
        private final String revision2;

        public ShowDiffTask(RepositoryRevision.Event event, String string, String string2, boolean bl) {
            this.header = event;
            this.revision2 = string2;
        }

        protected void perform() {
            DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            SVNUrl sVNUrl = this.header.getLogInfoHeader().getRepositoryRootUrl();
            SVNUrl sVNUrl2 = sVNUrl.appendPath(this.header.getChangedPath().getPath());
            final DiffStreamSource diffStreamSource = new DiffStreamSource(this.header.getFile(), sVNUrl, sVNUrl2, this.revision2, this.revision2);
            final LocalFileDiffStreamSource localFileDiffStreamSource = new LocalFileDiffStreamSource(this.header.getFile(), true);
            this.setCancellableDelegate(new Cancellable(){

                public boolean cancel() {
                    diffStreamSource.cancel();
                    return true;
                }
            });
            diffStreamSource.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            localFileDiffStreamSource.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            if (DiffResultsViewForLine.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.isCanceled()) {
                            DiffResultsViewForLine.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                            return;
                        }
                        DiffController diffController = DiffController.create((StreamSource)diffStreamSource, (StreamSource)localFileDiffStreamSource);
                        int n = DiffResultsViewForLine.this.getLastLineIndex(diffStreamSource);
                        int n2 = DiffResultsViewForLine.this.getLastLineIndex(localFileDiffStreamSource);
                        if (DiffResultsViewForLine.this.currentTask == ShowDiffTask.this) {
                            DiffResultsViewForLine.this.currentDiff = diffController;
                            DiffResultsViewForLine.this.setBottomComponent(DiffResultsViewForLine.this.currentDiff.getJComponent());
                            if (n != -1) {
                                DiffResultsViewForLine.this.setLocation(Math.min(n, DiffResultsViewForLine.this.lineNumber), false);
                            }
                            if (n2 != -1) {
                                DiffResultsViewForLine.this.setLocation(Math.min(n2, DiffResultsViewForLine.this.lineNumber), true);
                            }
                            DiffResultsViewForLine.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException iOException) {
                        Subversion.LOG.log(Level.INFO, null, iOException);
                    }
                }
            });
        }
    }
}

