/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class J2SEPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
EntityClassScopeProvider,
PropertyChangeListener {
    private final J2SEProject project;
    private final ClassPathProviderImpl cpProvider;
    private final ScopeImpl scopeImpl = new ScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.scopeImpl);
    private final EntityClassScope entityClassScope = EntityClassScopeFactory.createEntityClassScope((EntityClassScopeImplementation)this.scopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private final EntityMappingsMetadataModelHelper modelHelper;
    private ClassPath projectSourcesClassPath;

    public J2SEPersistenceProvider(J2SEProject j2SEProject, ClassPathProviderImpl classPathProviderImpl) {
        this.project = j2SEProject;
        this.cpProvider = classPathProviderImpl;
        this.modelHelper = this.createEntityMappingsHelper();
        j2SEProject.getSourceRoots().addPropertyChangeListener((PropertyChangeListener)this);
        this.sourcesChanged();
    }

    public FileObject getLocation() {
        return this.getMetaInfFolder();
    }

    public FileObject createLocation() throws IOException {
        FileObject fileObject = this.getFirstSourceRoot();
        if (fileObject == null) {
            throw new IOException("There are no source roots in the project or the first source root does not exist.");
        }
        FileObject fileObject2 = fileObject.getFileObject("META-INF");
        if (fileObject2 != null) {
            if (!fileObject2.isFolder()) {
                throw new IOException("The META-INF directory exists, but is not a folder.");
            }
        } else {
            fileObject2 = fileObject.createFolder("META-INF");
        }
        return fileObject2;
    }

    public PersistenceScope findPersistenceScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            J2SEPersistenceProvider j2SEPersistenceProvider = (J2SEPersistenceProvider)project.getLookup().lookup(J2SEPersistenceProvider.class);
            return j2SEPersistenceProvider.getPersistenceScope();
        }
        return null;
    }

    public EntityClassScope findEntityClassScope(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            J2SEPersistenceProvider j2SEPersistenceProvider = (J2SEPersistenceProvider)project.getLookup().lookup(J2SEPersistenceProvider.class);
            return j2SEPersistenceProvider.getEntityClassScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    private FileObject getFirstSourceRoot() {
        for (URL uRL : this.project.getSourceRoots().getRootURLs()) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    private FileObject getMetaInfFolder() {
        for (URL uRL : this.project.getSourceRoots().getRootURLs()) {
            FileObject fileObject;
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            if (fileObject2 == null || (fileObject = fileObject2.getFileObject("META-INF")) == null || !fileObject.isFolder()) continue;
            return fileObject;
        }
        return null;
    }

    private PersistenceScope getPersistenceScope() {
        FileObject fileObject = this.persistenceScope.getPersistenceXml();
        if (fileObject != null && fileObject.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    private EntityClassScope getEntityClassScope() {
        return this.entityClassScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        J2SEPersistenceProvider j2SEPersistenceProvider = this;
        synchronized (j2SEPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cpProvider.getProjectSourcesClassPath("classpath/source"), this.cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.sourcesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourcesChanged() {
        Object object;
        File file = null;
        FileObject fileObject = this.getMetaInfFolder();
        if (fileObject != null) {
            object = FileUtil.toFile((FileObject)fileObject);
            if (object != null) {
                file = new File((File)object, "persistence.xml");
            }
        } else {
            object = this.getFirstSourceRoot();
            if (object != null) {
                File file2 = FileUtil.toFile((FileObject)object);
                file = new File(file2, "META-INF/persistence.xml");
            }
        }
        object = this;
        synchronized (object) {
            if (file != null) {
                this.scopesHelper.changePersistenceScope(this.persistenceScope, file);
                this.modelHelper.changePersistenceXml(file);
            } else {
                this.scopesHelper.changePersistenceScope(null, null);
                this.modelHelper.changePersistenceXml(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ScopeImpl
    implements PersistenceScopeImplementation,
    EntityClassScopeImplementation {
        private ScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject fileObject = J2SEPersistenceProvider.this.getLocation();
            if (fileObject == null) {
                return null;
            }
            return fileObject.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return J2SEPersistenceProvider.this.getProjectSourcesClassPath();
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String string) {
            return J2SEPersistenceProvider.this.modelHelper.getEntityMappingsModel(string);
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(boolean bl) {
            return J2SEPersistenceProvider.this.modelHelper.getDefaultEntityMappingsModel(bl);
        }
    }
}

