/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.formatting;

import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.formatting.api.support.MarkupAbstractIndenter;
import org.netbeans.modules.editor.indent.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspIndenter
extends MarkupAbstractIndenter<JspTokenId> {
    public JspIndenter(Context context) {
        super(JspTokenId.language(), context);
    }

    protected boolean isWhiteSpaceToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.WHITESPACE || token.id() == JspTokenId.TEXT && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected boolean isOpenTagNameToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.TAG;
    }

    protected boolean isCloseTagNameToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.ENDTAG;
    }

    protected boolean isStartTagSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && (((Object)token.text()).toString().equals("<") || ((Object)token.text()).toString().equals("<%@"));
    }

    protected boolean isStartTagClosingSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && ((Object)token.text()).toString().equals("</");
    }

    protected boolean isEndTagSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && ((Object)token.text()).toString().equals(">");
    }

    protected boolean isEndTagClosingSymbol(Token<JspTokenId> token) {
        return token.id() == JspTokenId.SYMBOL && (((Object)token.text()).toString().equals("/>") || ((Object)token.text()).toString().equals("%>"));
    }

    protected boolean isTagArgumentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.ATTRIBUTE;
    }

    protected boolean isBlockCommentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.COMMENT;
    }

    protected boolean isTagContentToken(Token<JspTokenId> token) {
        return token.id() == JspTokenId.TEXT;
    }

    protected boolean isClosingTagOptional(String string) {
        return false;
    }

    protected boolean isOpeningTagOptional(String string) {
        return false;
    }

    protected Boolean isEmptyTag(String string) {
        return null;
    }

    protected boolean isTagContentUnformattable(String string) {
        return false;
    }

    protected Set<String> getTagChildren(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isPreservedLine(Token<JspTokenId> token, IndenterContextData<JspTokenId> indenterContextData) {
        String string = ((Object)token.text()).toString().trim();
        return token.id() == JspTokenId.COMMENT && !string.startsWith("<%--") && !string.startsWith("--%>");
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<JspTokenId> joinedTokenSequence) throws BadLocationException {
        int n = joinedTokenSequence.index();
        boolean bl = false;
        while (joinedTokenSequence.token().id() == JspTokenId.COMMENT) {
            String string = ((Object)joinedTokenSequence.token().text()).toString().trim();
            if (string.startsWith("<%--")) {
                bl = true;
                break;
            }
            if (joinedTokenSequence.movePrevious()) continue;
        }
        int n2 = 0;
        if (bl) {
            int n3 = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)joinedTokenSequence.offset());
            int n4 = joinedTokenSequence.offset();
            n2 = n4 - n3;
        }
        joinedTokenSequence.moveIndex(n);
        joinedTokenSequence.moveNext();
        return n2;
    }

    protected boolean isForeignLanguageStartToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> joinedTokenSequence) {
        return token.id() == JspTokenId.SYMBOL2 && (((Object)token.text()).toString().equals("<%") || ((Object)token.text()).toString().equals("<%=") || ((Object)token.text()).toString().equals("<%!"));
    }

    protected boolean isForeignLanguageEndToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> joinedTokenSequence) {
        return token.id() == JspTokenId.SYMBOL2 && ((Object)token.text()).toString().equals("%>");
    }

    protected boolean isStableFormattingStartToken(Token<JspTokenId> token, JoinedTokenSequence<JspTokenId> joinedTokenSequence) {
        return token.id() == JspTokenId.SYMBOL2 && (((Object)token.text()).toString().equals("<%") || ((Object)token.text()).toString().equals("<%=") || ((Object)token.text()).toString().equals("<%!"));
    }
}

