/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.PaintersModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChartSelectionManager
implements ChartSelectionModel {
    private ChartComponent chart;
    private ChartListener chartListener = new ChartListener();
    private MouseListener mouseListener = new MouseListener();
    private int selectionMode;
    private int moveMode;
    private int dragMode;
    private int hoverMode;
    private int hoverDistanceLimit;
    private int mouseX = -1;
    private int mouseY = -1;
    private boolean inChart = false;
    private Rectangle selectionBounds;
    private List<ItemSelection> highlightedSelection;
    private List<ItemSelection> selectedSelection;
    private boolean mousePanningBackup;
    private List<ChartSelectionListener> selectionListeners;

    public ChartSelectionManager() {
        this.setMoveMode(0);
        this.setDragMode(0);
        this.setSelectionMode(this.moveMode);
        this.setHoverMode(100);
        this.setHoverDistanceLimit(-1);
    }

    void registerChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = chartComponent;
        this.registerListener();
    }

    void unregisterChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = null;
    }

    @Override
    public final void setMoveMode(int n) {
        this.moveMode = n;
        if (this.selectionMode != this.moveMode) {
            this.setSelectionMode(this.moveMode);
        }
    }

    @Override
    public final int getMoveMode() {
        return this.moveMode;
    }

    @Override
    public final void setDragMode(int n) {
        this.dragMode = n;
    }

    @Override
    public final int getDragMode() {
        return this.dragMode;
    }

    @Override
    public final int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public final void setHoverMode(int n) {
        this.hoverMode = n;
        this.updateHighlightedItems();
    }

    @Override
    public final int getHoverMode() {
        return this.hoverMode;
    }

    @Override
    public final void setHoverDistanceLimit(int n) {
        this.hoverDistanceLimit = n;
    }

    @Override
    public final int getHoverDistanceLimit() {
        return this.hoverDistanceLimit;
    }

    public final void setSelectionBounds(int n, int n2, int n3, int n4) {
        this.setSelectionBounds(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public final void setSelectionBounds(Rectangle rectangle) {
        Rectangle rectangle2;
        if (rectangle == null && this.selectionBounds == null) {
            return;
        }
        if (this.selectionBounds != null && this.selectionBounds.equals(rectangle) || rectangle != null && rectangle.equals(this.selectionBounds)) {
            return;
        }
        Rectangle rectangle3 = rectangle2 = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        if (rectangle == null) {
            this.selectionBounds = null;
        } else if (this.selectionBounds == null) {
            this.selectionBounds = new Rectangle(rectangle);
        } else {
            this.selectionBounds.setBounds(rectangle);
        }
        this.fireSelectionBoundsChanged(this.selectionBounds, rectangle2);
    }

    @Override
    public final Rectangle getSelectionBounds() {
        return new Rectangle(this.selectionBounds);
    }

    @Override
    public final void setHighlightedItems(List<ItemSelection> list) {
        if (this.highlightedSelection == null) {
            if (list.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(list);
            this.fireHighlightedItemsChanged(list, list, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> arrayList2 = new ArrayList<ItemSelection>();
            for (ItemSelection itemSelection : list) {
                if (this.highlightedSelection.contains(itemSelection)) continue;
                arrayList.add(itemSelection);
            }
            for (ItemSelection itemSelection : this.highlightedSelection) {
                if (list.contains(itemSelection)) continue;
                arrayList2.add(itemSelection);
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(list);
            this.fireHighlightedItemsChanged(list, arrayList, arrayList2);
        }
    }

    @Override
    public final List<ItemSelection> getHighlightedItems() {
        return this.highlightedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.highlightedSelection);
    }

    @Override
    public final void setSelectedItems(List<ItemSelection> list) {
        if (this.selectedSelection == null) {
            if (list.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(list);
            this.fireSelectedItemsChanged(list, list, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> arrayList2 = new ArrayList<ItemSelection>();
            for (ItemSelection itemSelection : list) {
                if (this.selectedSelection.contains(itemSelection)) continue;
                arrayList.add(itemSelection);
            }
            for (ItemSelection itemSelection : this.selectedSelection) {
                if (list.contains(itemSelection)) continue;
                arrayList2.add(itemSelection);
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(list);
            this.fireSelectedItemsChanged(list, arrayList, arrayList2);
        }
    }

    @Override
    public final List<ItemSelection> getSelectedItems() {
        return this.selectedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.selectedSelection);
    }

    @Override
    public final void addSelectionListener(ChartSelectionListener chartSelectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ChartSelectionListener>();
        }
        this.selectionListeners.add(chartSelectionListener);
    }

    @Override
    public final void removeSelectionListener(ChartSelectionListener chartSelectionListener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(chartSelectionListener);
    }

    private void setSelectionMode(int n) {
        if (this.selectionMode == n) {
            return;
        }
        int n2 = this.selectionMode;
        this.selectionMode = n;
        this.fireSelectionModeChanged(this.selectionMode, n2);
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addMouseListener(this.mouseListener);
        this.chart.addMouseMotionListener(this.mouseListener);
        this.chart.addConfigurationListener(this.chartListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMouseListener(this.mouseListener);
        this.chart.removeMouseMotionListener(this.mouseListener);
        this.chart.removeConfigurationListener(this.chartListener);
    }

    private void updateHighlightedItems() {
        final int n = this.mouseX;
        final int n2 = this.mouseY;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ChartSelectionManager.this.hoverMode == 100 || !ChartSelectionManager.this.inChart) {
                    ChartSelectionManager.this.setHighlightedItems(Collections.EMPTY_LIST);
                    return;
                }
                ItemsModel itemsModel = ChartSelectionManager.this.chart.getItemsModel();
                PaintersModel paintersModel = ChartSelectionManager.this.chart.getPaintersModel();
                int n3 = itemsModel.getItemsCount();
                ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>(n3);
                for (int i = 0; i < n3; ++i) {
                    ChartItem chartItem = itemsModel.getItem(i);
                    ItemPainter itemPainter = paintersModel.getPainter(chartItem);
                    ItemSelection itemSelection = itemPainter.getClosestSelection(chartItem, n, n2, ChartSelectionManager.this.chart.getChartContext());
                    if (itemSelection == null) continue;
                    int n22 = itemSelection.getDistance();
                    if (ChartSelectionManager.this.hoverMode == 102 || arrayList.isEmpty()) {
                        if (ChartSelectionManager.this.hoverDistanceLimit != -1 && n22 > ChartSelectionManager.this.hoverDistanceLimit) continue;
                        arrayList.add(itemSelection);
                        continue;
                    }
                    if (((ItemSelection)arrayList.get(0)).getDistance() <= n22 || ChartSelectionManager.this.hoverDistanceLimit != -1 && n22 > ChartSelectionManager.this.hoverDistanceLimit) continue;
                    arrayList.set(0, itemSelection);
                }
                ChartSelectionManager.this.setHighlightedItems(arrayList);
            }
        });
    }

    private void fireSelectionModeChanged(int n, int n2) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectionModeChanged(n, n2);
        }
    }

    private void fireSelectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectionBoundsChanged(rectangle, rectangle2);
        }
    }

    private void fireHighlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.highlightedItemsChanged(list, list2, list3);
        }
    }

    private void fireSelectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectedItemsChanged(list, list2, list3);
        }
    }

    private class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ChartSelectionManager.this.mousePanningBackup = ChartSelectionManager.this.chart.isMousePanningEnabled();
            ChartSelectionManager.this.setSelectionMode(ChartSelectionManager.this.dragMode);
            if (ChartSelectionManager.this.selectionMode != 0) {
                ChartSelectionManager.this.chart.disableMousePanning();
                ChartSelectionManager.this.setSelectionBounds(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ChartSelectionManager.this.setSelectionBounds(null);
            ChartSelectionManager.this.setSelectionMode(ChartSelectionManager.this.moveMode);
            if (ChartSelectionManager.this.selectionMode == 0) {
                ChartSelectionManager.this.chart.setMousePanningEnabled(ChartSelectionManager.this.mousePanningBackup);
            }
            if (ChartSelectionManager.this.selectionMode != 0) {
                ChartSelectionManager.this.setSelectionBounds(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ChartSelectionManager.this.inChart = true;
            ChartSelectionManager.this.mouseX = mouseEvent.getX();
            ChartSelectionManager.this.mouseY = mouseEvent.getY();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ChartSelectionManager.this.inChart = false;
            if (ChartSelectionManager.this.selectionMode == 1 || ChartSelectionManager.this.selectionMode == 2 || ChartSelectionManager.this.selectionMode == 3) {
                ChartSelectionManager.this.setSelectionBounds(null);
            }
            ChartSelectionManager.this.updateHighlightedItems();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (ChartSelectionManager.this.selectionMode == 4) {
                ChartSelectionManager.this.setSelectionBounds(((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.x, ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.y, mouseEvent.getX() - ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.x, mouseEvent.getY() - ((ChartSelectionManager)ChartSelectionManager.this).selectionBounds.y);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ChartSelectionManager.this.mouseX = mouseEvent.getX();
            ChartSelectionManager.this.mouseY = mouseEvent.getY();
            if (ChartSelectionManager.this.selectionMode == 0) {
                ChartSelectionManager.this.setSelectionBounds(null);
            } else {
                ChartSelectionManager.this.setSelectionBounds(ChartSelectionManager.this.mouseX, ChartSelectionManager.this.mouseY, 0, 0);
            }
            ChartSelectionManager.this.updateHighlightedItems();
        }
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private ChartListener() {
        }

        public void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
            ChartSelectionManager.this.updateHighlightedItems();
        }
    }
}

