/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import org.netbeans.lib.profiler.charts.swing.Utils;

public class RoundBorder
extends AbstractBorder {
    private final Color lineColor;
    private final Color fillColor;
    private final Stroke borderStroke;
    private final int arcRadius;
    private final int borderExtent;
    private final int borderStrokeWidth;
    private final int halfBorderStrokeWidth;
    private final int inset;
    private final boolean forceSpeed;

    public RoundBorder(float f, Color color, Color color2, int n, int n2) {
        this.lineColor = Utils.checkedColor(color);
        this.fillColor = Utils.checkedColor(color2);
        this.arcRadius = n;
        this.borderExtent = n2;
        this.borderStroke = new BasicStroke(f);
        this.borderStrokeWidth = (int)f;
        this.halfBorderStrokeWidth = this.borderStrokeWidth / 2;
        this.inset = this.borderStrokeWidth + n2;
        this.forceSpeed = Utils.forceSpeed();
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        insets.right = insets.bottom = this.inset;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.fillColor);
        int n5 = this.arcRadius * 2;
        int n6 = n5 + 1;
        graphics2D.fillArc(n, n2, n5, n5, 90, 90);
        graphics2D.fillArc(n + n3 - n6, n2, n5, n5, 0, 90);
        graphics2D.fillArc(n, n2 + n4 - n6, n5, n5, 180, 90);
        graphics2D.fillArc(n + n3 - n6, n2 + n4 - n6, n5, n5, 270, 90);
        graphics2D.fillRect(n + this.arcRadius, n2, n3 - n6, n4);
        graphics2D.fillRect(n, n2 + this.arcRadius, this.arcRadius, n4 - n6);
        graphics2D.fillRect(n + n3 - this.arcRadius - 1, n2 + this.arcRadius, this.arcRadius, n4 - n6);
        Object object = null;
        Object object2 = null;
        if (!this.forceSpeed) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            object2 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        graphics2D.setStroke(this.borderStroke);
        graphics2D.setPaint(this.lineColor);
        graphics2D.drawRoundRect(n + this.halfBorderStrokeWidth, n2 + this.halfBorderStrokeWidth, n3 - this.borderStrokeWidth, n4 - this.borderStrokeWidth, this.arcRadius * 2, this.arcRadius * 2);
        if (!this.forceSpeed) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object2);
        }
    }
}

