/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.lang.reflect.Method;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.charts.swing.LongRect;

public final class Utils {
    private static boolean FORCE_SPEED = Boolean.getBoolean("graphs.forceSpeed");
    private static boolean forceSpeed = FORCE_SPEED || !Utils.isLocalDisplay();
    public static final int VALUE_OUT_OF_RANGE_NEG = Integer.MIN_VALUE;
    public static final int VALUE_OUT_OF_RANGE_POS = Integer.MAX_VALUE;

    public static boolean forceSpeed() {
        return forceSpeed;
    }

    public static Color checkedColor(Color color) {
        if (color == null) {
            return null;
        }
        if (!forceSpeed || color.getAlpha() == 255) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static RenderingHints checkedRenderingHints(RenderingHints renderingHints) {
        if (!forceSpeed) {
            return renderingHints;
        }
        RenderingHints renderingHints2 = (RenderingHints)renderingHints.clone();
        renderingHints2.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        renderingHints2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        renderingHints2.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        renderingHints2.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        renderingHints2.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        renderingHints2.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        return renderingHints2;
    }

    public static float getStrokeWidth(Stroke stroke) {
        if (stroke == null) {
            return 0.0f;
        }
        if (!(stroke instanceof BasicStroke)) {
            return 1.0f;
        }
        return ((BasicStroke)stroke).getLineWidth();
    }

    public static Color getSystemSelection() {
        return UIManager.getColor("List.selectionBackground");
    }

    private static boolean isLocalDisplay() {
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                return true;
            }
            Class<?> clazz = Class.forName("sun.awt.X11GraphicsEnvironment");
            Method method = clazz.getMethod("isDisplayLocal", new Class[0]);
            return (Boolean)method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static final int checkedInt(double d) {
        if (d < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (d > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)d;
    }

    public static final Rectangle checkedRectangle(LongRect longRect) {
        return new Rectangle(Utils.checkedInt(longRect.x), Utils.checkedInt(longRect.y), Utils.checkedInt(longRect.width), Utils.checkedInt(longRect.height));
    }
}

