/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.recent;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.quicksearch.CommandEvaluator;
import org.netbeans.modules.quicksearch.ResultsModel;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentSearches {
    private static final int MAX_ITEMS = 5;
    private static final long FIVE_DAYS = 432000000L;
    private LinkedList<ResultsModel.ItemResult> recent = new LinkedList<ResultsModel.ItemResult>(){

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (ResultsModel.ItemResult itemResult : this) {
                stringBuffer.append(itemResult.getDisplayName() + ":" + itemResult.getDate().getTime() + ",");
            }
            return stringBuffer.toString();
        }
    };
    private static RecentSearches instance;
    private static final String RECENT_SEARCHES = "recentSearches";

    private RecentSearches() {
        this.readRecentFromPrefs();
    }

    public static RecentSearches getDefault() {
        if (instance == null) {
            instance = new RecentSearches();
        }
        return instance;
    }

    public void add(ResultsModel.ItemResult itemResult) {
        Date date = new GregorianCalendar().getTime();
        for (ResultsModel.ItemResult itemResult2 : this.recent) {
            if (!this.stripHTMLnames(itemResult2.getDisplayName()).equals(this.stripHTMLnames(itemResult.getDisplayName()))) continue;
            itemResult2.setDate(date);
            return;
        }
        if ("SearchSetup".equals(itemResult.getAction().getClass().getSimpleName())) {
            return;
        }
        if (this.recent.size() >= 5) {
            this.recent.removeLast();
        }
        itemResult.setDate(date);
        this.recent.addFirst(itemResult);
        this.prefs().put(RECENT_SEARCHES, this.stripHTMLnames(this.recent.toString()));
    }

    public List<ResultsModel.ItemResult> getSearches() {
        LinkedList<ResultsModel.ItemResult> linkedList = new LinkedList<ResultsModel.ItemResult>();
        for (ResultsModel.ItemResult itemResult : this.recent) {
            if (new GregorianCalendar().getTime().getTime() - itemResult.getDate().getTime() >= 432000000L) continue;
            linkedList.add(itemResult);
        }
        return linkedList;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(RecentSearches.class);
    }

    private void readRecentFromPrefs() {
        String[] stringArray = this.prefs().get(RECENT_SEARCHES, "").split(",");
        if (stringArray[0].length() != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = stringArray[i].lastIndexOf(":");
                if (n < 0) continue;
                String string = stringArray[i].substring(0, n);
                long l = Long.parseLong(stringArray[i].substring(n + 1));
                ResultsModel.ItemResult itemResult = new ResultsModel.ItemResult(null, new FakeAction(string), string, new Date(l));
                this.recent.add(itemResult);
            }
        }
    }

    private String stripHTMLnames(String string) {
        return string.replaceAll("<.*?>", "").trim();
    }

    public final class FakeAction
    implements Runnable {
        private String name;
        private Runnable action;

        private FakeAction(String string) {
            this.name = string;
        }

        public void run() {
            if (this.action == null || this.action instanceof FakeAction) {
                ResultsModel resultsModel = ResultsModel.getInstance();
                CommandEvaluator.evaluate(this.stripHTMLandPackageNames(this.name), resultsModel);
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                int n = resultsModel.getSize();
                for (int i = 0; i < n; ++i) {
                    ResultsModel.ItemResult itemResult = (ResultsModel.ItemResult)resultsModel.getElementAt(i);
                    if (!RecentSearches.this.stripHTMLnames(itemResult.getDisplayName()).equals(RecentSearches.this.stripHTMLnames(this.name))) continue;
                    this.action = itemResult.getAction();
                    if (this.action instanceof FakeAction) continue;
                    this.action.run();
                    break;
                }
            } else {
                this.action.run();
            }
        }

        private String stripHTMLandPackageNames(String string) {
            string = RecentSearches.this.stripHTMLnames(string);
            return string.replaceAll("\\(.*\\)", "").trim();
        }
    }
}

