/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.database.ConfigurableRailsAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JavaDBAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JdbcMySQlAdapter;
import org.netbeans.modules.ruby.railsprojects.database.JdbcPostgreSQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.MySQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.PostgreSQLAdapter;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.database.SQLiteAdapter;
import org.netbeans.modules.ruby.railsprojects.database.StandardRailsAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsAdapterFactory {
    public static List<RailsDatabaseConfiguration> getAdapters(RubyPlatform rubyPlatform) {
        ArrayList<RailsDatabaseConfiguration> arrayList = new ArrayList<RailsDatabaseConfiguration>();
        arrayList.addAll(RailsAdapterFactory.getMySQLAdapters(rubyPlatform));
        arrayList.addAll(RailsAdapterFactory.getPostgreSQLAdapters(rubyPlatform));
        arrayList.add(new StandardRailsAdapter("oracle"));
        arrayList.add(new SQLiteAdapter("sqlite2"));
        arrayList.add(new SQLiteAdapter("sqlite3"));
        arrayList.add(new JavaDBAdapter());
        return arrayList;
    }

    private static List<RailsDatabaseConfiguration> getMySQLAdapters(RubyPlatform rubyPlatform) {
        if (!rubyPlatform.isJRuby()) {
            return Collections.singletonList(new MySQLAdapter());
        }
        GemManager gemManager = rubyPlatform.getGemManager();
        if (gemManager == null || !gemManager.isGemInstalled("activerecord-jdbcmysql-adapter")) {
            return Collections.singletonList(new MySQLAdapter());
        }
        return Collections.singletonList(new JdbcMySQlAdapter());
    }

    private static List<RailsDatabaseConfiguration> getPostgreSQLAdapters(RubyPlatform rubyPlatform) {
        if (!rubyPlatform.isJRuby()) {
            return Collections.singletonList(new PostgreSQLAdapter());
        }
        GemManager gemManager = rubyPlatform.getGemManager();
        if (gemManager == null || !gemManager.isGemInstalled("activerecord-jdbcpostgresql-adapter")) {
            return Collections.singletonList(new PostgreSQLAdapter());
        }
        return Collections.singletonList(new JdbcPostgreSQLAdapter());
    }

    public static RailsDatabaseConfiguration getDefaultAdapter(RubyPlatform rubyPlatform) {
        RailsDatabaseConfiguration railsDatabaseConfiguration = RailsAdapterFactory.getAdapters(rubyPlatform).get(0);
        return railsDatabaseConfiguration.requiresJdbc() ? new ConfigurableRailsAdapter(railsDatabaseConfiguration, null, null, null, true) : railsDatabaseConfiguration;
    }

    public static RailsDatabaseConfiguration getDefaultAdapter() {
        return new MySQLAdapter();
    }
}

