/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.nodes.RubyServerNode;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GlassFishGem
implements RubyServer,
ServerInstanceImplementation {
    static final String GEM_NAME = "glassfish";
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile(".*INFO: Glassfish v3 started.*", 32), Pattern.compile(".*[0-9] milliseconds.*", 32)};
    private final List<RailsApplication> applications = new ArrayList<RailsApplication>();
    private final RubyPlatform platform;
    private final String version;
    private final String location;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private Node node;

    GlassFishGem(RubyPlatform rubyPlatform, GemInfo gemInfo) {
        Parameters.notNull((CharSequence)"platform", (Object)rubyPlatform);
        this.platform = rubyPlatform;
        this.version = gemInfo.getVersion();
        this.location = this.getGemFolder(gemInfo.getSpecFile());
    }

    private String getGemFolder(File file) {
        String string = file.getName();
        if (string.endsWith(".gemspec")) {
            string = string.substring(0, string.length() - 8);
        }
        return new File(file.getParentFile().getParentFile(), "gems" + File.separatorChar + string).getAbsolutePath();
    }

    private Node getNode() {
        if (this.node == null) {
            this.node = new RubyServerNode(this);
        }
        return this.node;
    }

    @Override
    public String getNodeName() {
        return NbBundle.getMessage(GlassFishGem.class, (String)"LBL_ServerNodeName", (Object)this.getDisplayName(), (Object)this.platform.getLabel());
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getStartupParam() {
        return null;
    }

    @Override
    public String getScriptPrefix() {
        return "-S";
    }

    @Override
    public String getServerPath() {
        return this.compareVersion("0.9.4") >= 0 ? GEM_NAME : "glassfish_rails";
    }

    @Override
    public boolean isStartupMsg(String string) {
        for (Pattern pattern : PATTERNS) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RailsApplication> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    @Override
    public boolean addApplication(RailsApplication railsApplication) {
        boolean bl = this.applications.add(railsApplication);
        this.changeSupport.fireChange();
        return bl;
    }

    @Override
    public boolean removeApplication(int n) {
        boolean bl = false;
        for (RailsApplication railsApplication : this.applications) {
            if (railsApplication.getPort() != n) continue;
            bl = this.applications.remove(railsApplication);
            this.changeSupport.fireChange();
            break;
        }
        return bl;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public int compareVersion(String string) {
        int[] nArray = this.extractVersion(this.version);
        int[] nArray2 = this.extractVersion(string);
        for (int i = 0; i < 3; ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    private int[] extractVersion(String string) {
        int[] nArray = new int[]{0, 0, 0};
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < 3 && i < stringArray.length; ++i) {
            nArray[i] = Integer.valueOf(stringArray[i]);
        }
        return nArray;
    }

    public String getServerDisplayName() {
        return this.getNodeName();
    }

    public Node getFullNode() {
        return this.getNode();
    }

    public Node getBasicNode() {
        return this.getNode();
    }

    public JComponent getCustomizer() {
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isRemovable() {
        return false;
    }

    @Override
    public String getServerUri() {
        return "GLASSFISH";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(GlassFishGem.class, (String)"LBL_GlassFish", (Object)this.version);
    }

    @Override
    public RubyInstance.ServerState getServerState() {
        return null;
    }

    @Override
    public Future<RubyInstance.OperationState> startServer(RubyPlatform rubyPlatform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stopServer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> deploy(String string, File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> stop(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Future<RubyInstance.OperationState> runApplication(RubyPlatform rubyPlatform, String string, File file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPlatformSupported(RubyPlatform rubyPlatform) {
        return this.platform.equals((Object)rubyPlatform);
    }

    @Override
    public String getContextRoot(String string) {
        return "";
    }

    @Override
    public int getRailsPort() {
        return 3000;
    }

    @Override
    public String getServerCommand(RubyPlatform rubyPlatform, String string, File file, int n, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GlassFishGem glassFishGem = (GlassFishGem)object;
        if (!(this.platform == glassFishGem.platform || this.platform != null && this.platform.equals((Object)glassFishGem.platform))) {
            return false;
        }
        if (!(this.version == glassFishGem.version || this.version != null && this.version.equals(glassFishGem.version))) {
            return false;
        }
        return this.location == glassFishGem.location || this.location != null && this.location.equals(glassFishGem.location);
    }

    public int hashCode() {
        int n = 3;
        n = 47 * n + (this.platform != null ? this.platform.hashCode() : 0);
        n = 47 * n + (this.version != null ? this.version.hashCode() : 0);
        return n;
    }
}

