/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class WebParseUtils {
    private static final Logger LOGGER = Logger.getLogger(WebParseUtils.class.getName());

    public static String getVersion(InputStream inputStream) throws IOException, SAXException {
        return ParseUtils.getVersion(inputStream, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(InputSource inputSource) throws IOException, SAXException {
        return ParseUtils.getVersion(inputSource, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        return WebParseUtils.parse(new InputSource(fileObject.getInputStream()));
    }

    public static SAXParseException parse(InputSource inputSource) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource inputSource, EntityResolver entityResolver) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, entityResolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String string, String string2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resolving entity [publicId: '" + string + "', systemId: '" + string2 + "']");
            }
            String string3 = null;
            if (string2 != null && string2.endsWith("web-app_2_4.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_4.xsd";
            } else if (string2 != null && string2.endsWith("web-app_2_5.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_2_5.xsd";
            } else if (string2 != null && string2.endsWith("web-app_3_0.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-app_3_0.xsd";
            } else if (string2 != null && string2.endsWith("web-fragment_3_0.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/dd/impl/resources/web-fragment_3_0.xsd";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Got resource: " + string3);
            }
            if (string3 == null) {
                return null;
            }
            URL uRL = this.getClass().getResource(string3);
            return new InputSource(uRL.toString());
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("web-app".equals(string3)) {
                String string4 = attributes.getValue("version");
                throw new SAXException("version:" + string4);
            }
            if ("web-fragment".equals(string3)) {
                String string5 = attributes.getValue("version");
                throw new SAXException("version:" + string5);
            }
        }
    }
}

