/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.jruby.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.openide.util.NbBundle;

public class JRubyServerCustomizer
extends JPanel {
    public static final String DEFAULT_RUBY_PLATFORM_ID = "ruby.platform.id";
    private GlassfishModule commonSupport;
    private boolean useRootContextChanged = false;
    private AtomicBoolean modelChanging = new AtomicBoolean(false);
    private JComboBox comboJRubyPlatform;
    private JLabel labelJRubyPlatform;
    private JCheckBox useRootContextCheckBox;

    public JRubyServerCustomizer(GlassfishModule glassfishModule) {
        this.commonSupport = glassfishModule;
        this.initComponents();
    }

    private void initFields() {
        this.setFilterModel(this.comboJRubyPlatform.getModel());
        Map map = this.commonSupport.getInstanceProperties();
        RubyPlatform rubyPlatform = this.getDefaultPlatform((String)map.get(DEFAULT_RUBY_PLATFORM_ID));
        this.comboJRubyPlatform.setSelectedItem(rubyPlatform);
        boolean bl = Boolean.parseBoolean((String)map.get("jruby.useRootContext"));
        this.useRootContextCheckBox.setSelected(bl);
    }

    private RubyPlatform getDefaultPlatform(String string) {
        RubyPlatform rubyPlatform = RubyPlatformManager.getPlatformByID((String)string);
        if (!(rubyPlatform != null && rubyPlatform.isJRuby() || (rubyPlatform = RubyPlatformManager.getDefaultPlatform()).isJRuby())) {
            rubyPlatform = null;
            Iterator iterator = RubyPlatformManager.platformIterator();
            while (iterator.hasNext()) {
                RubyPlatform rubyPlatform2 = (RubyPlatform)iterator.next();
                if (!rubyPlatform2.isJRuby()) continue;
                rubyPlatform = rubyPlatform2;
                break;
            }
        }
        return rubyPlatform;
    }

    private void persistFields() {
        Object object;
        Object object2 = this.comboJRubyPlatform.getSelectedItem();
        if (object2 instanceof RubyPlatform) {
            object = (RubyPlatform)object2;
            this.commonSupport.setEnvironmentProperty(DEFAULT_RUBY_PLATFORM_ID, object.getID(), true);
            this.commonSupport.setEnvironmentProperty("jruby.home", object.getHome().getAbsolutePath(), true);
        }
        if (this.useRootContextChanged) {
            object = Boolean.toString(this.useRootContextCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("jruby.useRootContext", (String)object, true);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.labelJRubyPlatform = new JLabel();
        this.comboJRubyPlatform = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.useRootContextCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"JRubyServerCustomizer.name"));
        this.labelJRubyPlatform.setText(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"JRubyServerCustomizer.labelJRubyPlatform.text"));
        this.comboJRubyPlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRubyServerCustomizer.this.comboJRubyPlatformActionPerformed(actionEvent);
            }
        });
        this.comboJRubyPlatform.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JRubyServerCustomizer.this.comboJRubyPlatformPropertyChange(propertyChangeEvent);
            }
        });
        this.useRootContextCheckBox.setText(NbBundle.getMessage(JRubyServerCustomizer.class, (String)"LBL_UseRootContext"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.useRootContextCheckBox, -1, 392, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.labelJRubyPlatform).addPreferredGap(0).add((Component)this.comboJRubyPlatform, 0, 244, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.labelJRubyPlatform).add((Component)this.comboJRubyPlatform, -2, -1, -2)).add(18, 18, 18).add((Component)this.useRootContextCheckBox).addContainerGap(166, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboJRubyPlatformPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) && !this.modelChanging.getAndSet(true)) {
            try {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getNewValue();
                this.setFilterModel(comboBoxModel);
            }
            finally {
                this.modelChanging.set(false);
            }
        }
    }

    private void comboJRubyPlatformActionPerformed(ActionEvent actionEvent) {
        this.useRootContextChanged = true;
    }

    private void setFilterModel(ComboBoxModel comboBoxModel) {
        if (comboBoxModel != null && (comboBoxModel.getSize() == 0 || comboBoxModel.getElementAt(0) instanceof RubyPlatform)) {
            comboBoxModel = new FilterModel(comboBoxModel);
            this.comboJRubyPlatform.setModel(comboBoxModel);
        }
    }

    private static class FilterModel
    implements ComboBoxModel {
        private ComboBoxModel delegate;
        private Map<RubyPlatform, Integer> data;

        FilterModel(ComboBoxModel comboBoxModel) {
            this.delegate = comboBoxModel;
            this.updateModel();
        }

        private synchronized void updateModel() {
            this.data = new HashMap<RubyPlatform, Integer>();
            int n = this.delegate.getSize();
            for (int i = 0; i < n; ++i) {
                RubyPlatform rubyPlatform;
                Object e = this.delegate.getElementAt(i);
                if (!(e instanceof RubyPlatform) || !(rubyPlatform = (RubyPlatform)e).isJRuby()) continue;
                this.data.put(rubyPlatform, i);
            }
        }

        public synchronized void setSelectedItem(Object object) {
            Integer n = this.data.get(object);
            if (n != null) {
                this.delegate.setSelectedItem(object);
            }
        }

        public synchronized Object getSelectedItem() {
            RubyPlatform rubyPlatform;
            Object object = this.delegate.getSelectedItem();
            if (object instanceof RubyPlatform && (rubyPlatform = (RubyPlatform)object).isJRuby()) {
                return rubyPlatform;
            }
            return null;
        }

        public synchronized int getSize() {
            return this.data.size();
        }

        public synchronized Object getElementAt(int n) {
            Iterator<RubyPlatform> iterator = this.data.keySet().iterator();
            while (n-- > 0 && iterator.hasNext()) {
                iterator.next();
            }
            return iterator.hasNext() ? iterator.next() : null;
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.delegate.addListDataListener(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.delegate.removeListDataListener(listDataListener);
        }
    }
}

