/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationStatus {
    private static final ValidationStatus validStatus = new ValidationStatus(true, true, NbBundle.getMessage(ValidationStatus.class, (String)"ValidationStatus.Valid"), null);
    private static final ValidationStatus initialStatus = new ValidationStatus(false, false, NbBundle.getMessage(ValidationStatus.class, (String)"ValidationStatus.Initial"), null);
    private final boolean isDefined;
    private final boolean isValid;
    private final String reason;
    private final Collection<AsynchronousAction> requiredActions = new ArrayList<AsynchronousAction>();

    private ValidationStatus(boolean bl, boolean bl2, String string, Collection<AsynchronousAction> collection) {
        this.isValid = bl2;
        this.isDefined = bl;
        String string2 = this.reason = string == null ? "" : string;
        if (collection != null) {
            this.requiredActions.addAll(collection);
        }
    }

    public static ValidationStatus unknownStatus(String string, AsynchronousAction asynchronousAction) {
        if (asynchronousAction == null) {
            throw new NullPointerException("requiredAction cannot be NULL");
        }
        ArrayList<AsynchronousAction> arrayList = new ArrayList<AsynchronousAction>();
        arrayList.add(asynchronousAction);
        return new ValidationStatus(false, false, string, arrayList);
    }

    public static ValidationStatus invalidStatus(String string) {
        return new ValidationStatus(true, false, string, null);
    }

    public static ValidationStatus validStatus() {
        return validStatus;
    }

    public static ValidationStatus initialStatus() {
        return initialStatus;
    }

    public String getReason() {
        return this.reason;
    }

    public ValidationStatus merge(ValidationStatus validationStatus) {
        if (this.isInvalid()) {
            return this;
        }
        if (validationStatus.isInvalid()) {
            return validationStatus;
        }
        if (this.isValid() && validationStatus.isValid()) {
            return this;
        }
        if (this.isValid()) {
            return validationStatus == initialStatus ? this : validationStatus;
        }
        if (validationStatus.isValid()) {
            return this == initialStatus ? validationStatus : this;
        }
        ArrayList<AsynchronousAction> arrayList = new ArrayList<AsynchronousAction>();
        arrayList.addAll(this.requiredActions);
        arrayList.addAll(validationStatus.requiredActions);
        String string = null;
        string = this == initialStatus ? validationStatus.reason : (validationStatus == initialStatus ? this.reason : this.reason + "; " + validationStatus.reason);
        ValidationStatus validationStatus2 = new ValidationStatus(false, false, string, arrayList);
        return validationStatus2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValidationStatus)) {
            return false;
        }
        ValidationStatus validationStatus = (ValidationStatus)object;
        if (!validationStatus.reason.equals(this.reason)) {
            return false;
        }
        if (validationStatus.isDefined != this.isDefined) {
            return false;
        }
        return !this.isDefined || validationStatus.isValid == this.isValid;
    }

    public int hashCode() {
        int n = 3;
        n = 97 * n + (this.isDefined ? 1 : 0);
        n = 97 * n + (this.isValid ? 1 : 0);
        n = 97 * n + (this.reason != null ? this.reason.hashCode() : 0);
        return n;
    }

    public String toString() {
        if (!this.isDefined) {
            return "UNKNOWN: " + this.reason;
        }
        if (this.isValid) {
            return "OK";
        }
        return "INVALID: " + this.reason;
    }

    public Collection<AsynchronousAction> getRequiredActions() {
        return this.requiredActions;
    }

    public boolean isValid() {
        return this.isDefined && this.isValid;
    }

    public boolean isInvalid() {
        return this.isDefined && !this.isValid;
    }

    public boolean isKnown() {
        return this.isDefined;
    }
}

