/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.types.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTableMetadataFilterSupport {
    private static DataTableMetadataFilterSupport instance;

    private DataTableMetadataFilterSupport() {
    }

    public static final synchronized DataTableMetadataFilterSupport getInstance() {
        if (instance == null) {
            instance = new DataTableMetadataFilterSupport();
        }
        return instance;
    }

    private final Collection<DataTableMetadataFilter> createFilters(List<DataTableMetadata.Column> list, TimeIntervalDataFilter timeIntervalDataFilter) {
        ArrayList<DataTableMetadataFilter> arrayList = new ArrayList<DataTableMetadataFilter>();
        for (DataTableMetadata.Column column : list) {
            try {
                column.getColumnClass().asSubclass(Time.class);
                arrayList.add(new DataTableMetadataFilter(column, timeIntervalDataFilter));
            }
            catch (ClassCastException classCastException) {}
        }
        return arrayList;
    }

    public final Collection<DataTableMetadataFilter> createFilters(DataTableMetadata dataTableMetadata, TimeIntervalDataFilter timeIntervalDataFilter) {
        ArrayList<DataTableMetadataFilter> arrayList = new ArrayList<DataTableMetadataFilter>();
        List<DataTableMetadata> list = dataTableMetadata.getSourceTables();
        if (list == null) {
            List<DataTableMetadata.Column> list2 = dataTableMetadata.getColumns();
            arrayList.addAll(this.createFilters(list2, timeIntervalDataFilter));
            return arrayList;
        }
        for (DataTableMetadata dataTableMetadata2 : list) {
            arrayList.addAll(this.createFilters(dataTableMetadata2.getColumns(), timeIntervalDataFilter));
        }
        return arrayList;
    }
}

