/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.impl.IDPProvider;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorProvider;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightTool
implements Validateable<DLightTarget> {
    private static final Logger log = DLightLogger.getLogger(DLightTool.class);
    private final String id;
    private final String toolName;
    private final String detailedToolName;
    private final String description;
    private boolean enabled;
    private final List<DataCollector<?>> dataCollectors;
    private final List<IndicatorDataProvider<?>> indicatorDataProviders;
    private final List<Indicator<?>> indicators;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private ValidationStatus dataCollectorsValidationStatus = ValidationStatus.initialStatus();
    private ValidationStatus indicatorDataProvidersValidationStatus = ValidationStatus.initialStatus();
    private final List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private boolean collectorsTurnedOn = true;
    private final String iconPath;
    private final DLightToolConfiguration configuration;
    private volatile Boolean idpsInitialized = false;
    private boolean visible;
    private boolean isDetailsEnabled = true;

    private DLightTool(DLightToolConfiguration dLightToolConfiguration) {
        DLightToolConfigurationAccessor dLightToolConfigurationAccessor = DLightToolConfigurationAccessor.getDefault();
        this.id = dLightToolConfiguration.getID();
        this.toolName = dLightToolConfigurationAccessor.getToolName(dLightToolConfiguration);
        this.detailedToolName = dLightToolConfigurationAccessor.getDetailedToolName(dLightToolConfiguration);
        this.iconPath = dLightToolConfigurationAccessor.getIconPath(dLightToolConfiguration);
        this.description = dLightToolConfigurationAccessor.getToolDescription(dLightToolConfiguration);
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = new ArrayList();
        this.configuration = dLightToolConfiguration;
        this.indicatorDataProviders = Collections.synchronizedList(new ArrayList());
        this.visible = dLightToolConfiguration.isVisible();
        this.enabled = true;
    }

    static DLightTool newDLightTool(DLightToolConfiguration dLightToolConfiguration) {
        return new DLightTool(dLightToolConfiguration);
    }

    public final void enable() {
        this.enabled = true;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void disable() {
        this.enabled = false;
    }

    void turnCollectorsState(String string, boolean bl) {
        this.collectorsTurnedOn = bl;
    }

    boolean collectorsTurnedOn() {
        return this.collectorsTurnedOn;
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final String getName() {
        return this.toolName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getID() {
        return this.id;
    }

    public final String getDetailedName() {
        return this.detailedToolName;
    }

    public final boolean hasIcon() {
        return this.iconPath != null;
    }

    public final String getIconPath() {
        return this.iconPath;
    }

    public final List<DataCollector<?>> getCollectors() {
        this.initCollectors();
        return this.dataCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initCollectors() {
        List<DataCollector<?>> list = this.dataCollectors;
        synchronized (list) {
            if (this.dataCollectors.size() == 0) {
                DLightToolConfigurationAccessor dLightToolConfigurationAccessor = DLightToolConfigurationAccessor.getDefault();
                List<DataCollectorConfiguration> list2 = dLightToolConfigurationAccessor.getDataCollectors(this.configuration);
                List<IndicatorDataProviderConfiguration> list3 = dLightToolConfigurationAccessor.getIndicatorDataProviders(this.configuration);
                for (DataCollectorConfiguration dataCollectorConfiguration : list2) {
                    DataCollector<?> dataCollector = DataCollectorProvider.getInstance().createDataCollector(dataCollectorConfiguration);
                    if (dataCollector == null) {
                        log.info("Could not find DataCollector for configuration with id:" + dataCollectorConfiguration.getID() + " check if " + "DataColelctorFactory is registered in Global Lookup with the same ID");
                        continue;
                    }
                    this.registerCollector(dataCollector);
                    if (!list3.contains((IndicatorDataProviderConfiguration)((Object)dataCollectorConfiguration)) || !(dataCollector instanceof IndicatorDataProvider)) continue;
                    this.registerIndicatorDataProvider((IndicatorDataProvider)((Object)dataCollector));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initIndicatorDataProviders() {
        DLightTool dLightTool = this;
        synchronized (dLightTool) {
            if (this.idpsInitialized.booleanValue()) {
                return;
            }
            DLightToolConfigurationAccessor dLightToolConfigurationAccessor = DLightToolConfigurationAccessor.getDefault();
            List<DataCollectorConfiguration> list = dLightToolConfigurationAccessor.getDataCollectors(this.configuration);
            List<IndicatorDataProviderConfiguration> list2 = dLightToolConfigurationAccessor.getIndicatorDataProviders(this.configuration);
            for (IndicatorDataProviderConfiguration indicatorDataProviderConfiguration : list2) {
                if (list.contains(indicatorDataProviderConfiguration)) continue;
                IndicatorDataProvider indicatorDataProvider = IDPProvider.getInstance().create(indicatorDataProviderConfiguration);
                if (indicatorDataProvider == null) {
                    log.info("Could not find IndicatorDataProvider for configuration with id:" + indicatorDataProviderConfiguration.getID() + " check if " + "IndicatorDataProviderFactory is registered in Global Lookup with the same ID");
                    continue;
                }
                this.registerIndicatorDataProvider(indicatorDataProvider);
            }
            this.idpsInitialized = true;
        }
    }

    final List<DataCollector<?>> getCollectorsByName(String string) {
        this.initCollectors();
        return this.dataCollectors;
    }

    private final void registerIndicatorDataProvider(IndicatorDataProvider indicatorDataProvider) {
        if (!this.indicatorDataProviders.contains(indicatorDataProvider)) {
            this.indicatorDataProviders.add(indicatorDataProvider);
        }
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders() {
        this.initIndicatorDataProviders();
        return this.indicatorDataProviders;
    }

    List<IndicatorDataProvider<?>> getIndicatorDataProviders(String string) {
        this.initIndicatorDataProviders();
        return this.indicatorDataProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Indicator<?>> getIndicators() {
        List<Indicator<?>> list = this.indicators;
        synchronized (list) {
            if (this.indicators.size() == 0) {
                List<IndicatorConfiguration> list2 = DLightToolConfigurationAccessor.getDefault().getIndicators(this.configuration);
                for (IndicatorConfiguration indicatorConfiguration : list2) {
                    Indicator<?> indicator = IndicatorProvider.getInstance().createIndicator(this.id, indicatorConfiguration, this.isDetailsEnabled);
                    if (indicator == null) {
                        log.info("Could not find Indicator for configuration with id:" + indicatorConfiguration.getID() + " check if " + "IndicatorFactory is registered in Global Lookup with the same ID");
                        continue;
                    }
                    IndicatorAccessor.getDefault().setToolDescription(indicator, this.description);
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
            }
            return this.indicators;
        }
    }

    void registerCollector(DataCollector dataCollector) {
        if (dataCollector == null) {
            log.info("Cannot register collector");
            return;
        }
        if (!this.dataCollectors.contains(dataCollector)) {
            this.dataCollectors.add(dataCollector);
        }
        dataCollector.addValidationListener(new ValidationListener(){

            public void validationStateChanged(Validateable validateable, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
                DLightTool.this.notifyStatusChanged(validationStatus, validationStatus2);
            }
        });
    }

    @Override
    public final ValidationStatus validate(DLightTarget dLightTarget) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        this.notifyStatusChanged(validationStatus, validationStatus2);
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    public final ValidationStatus validateIndicatorDataProviders(final DLightConfiguration dLightConfiguration, final DLightTarget dLightTarget) {
        if (this.indicatorDataProvidersValidationStatus.isValid()) {
            return this.indicatorDataProvidersValidationStatus;
        }
        this.initIndicatorDataProviders();
        this.initCollectors();
        if (EventQueue.isDispatchThread()) {
            Future future = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus validationStatus = ValidationStatus.initialStatus();
                    for (IndicatorDataProvider<?> validateable : dLightConfiguration.getConfigurationOptions(false).getIndicatorDataProviders(DLightTool.this)) {
                        validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
                    }
                    for (DataCollector dataCollector : dLightConfiguration.getConfigurationOptions(false).getCollectors(DLightTool.this)) {
                        if (!(dataCollector instanceof IndicatorDataProvider)) continue;
                        validationStatus = validationStatus.merge(dataCollector.validate(dLightTarget));
                    }
                    return validationStatus;
                }
            }, (String)("Validate IndicatorDataProviders for tool " + this.getID()));
            try {
                this.indicatorDataProvidersValidationStatus = (ValidationStatus)future.get();
                return this.indicatorDataProvidersValidationStatus;
            }
            catch (InterruptedException interruptedException) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException executionException) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus validationStatus = ValidationStatus.initialStatus();
        for (IndicatorDataProvider<?> validateable : dLightConfiguration.getConfigurationOptions(false).getIndicatorDataProviders(this)) {
            validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
        }
        for (DataCollector dataCollector : dLightConfiguration.getConfigurationOptions(false).getCollectors(this)) {
            if (!(dataCollector instanceof IndicatorDataProvider)) continue;
            validationStatus = validationStatus.merge(dataCollector.validate(dLightTarget));
        }
        this.indicatorDataProvidersValidationStatus = validationStatus;
        return this.indicatorDataProvidersValidationStatus;
    }

    public final ValidationStatus validateDataCollectors(final DLightConfiguration dLightConfiguration, final DLightTarget dLightTarget) {
        if (this.dataCollectorsValidationStatus.isValid()) {
            return this.dataCollectorsValidationStatus;
        }
        this.initCollectors();
        this.initIndicatorDataProviders();
        if (EventQueue.isDispatchThread()) {
            Future future = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus validationStatus = ValidationStatus.initialStatus();
                    for (DataCollector<?> dataCollector : dLightConfiguration.getConfigurationOptions(false).getCollectors(DLightTool.this)) {
                        validationStatus = validationStatus.merge(dataCollector.validate(dLightTarget));
                    }
                    return validationStatus;
                }
            }, (String)("Validate DataCollectors for tool " + this.getID()));
            try {
                this.dataCollectorsValidationStatus = (ValidationStatus)future.get();
                return this.dataCollectorsValidationStatus;
            }
            catch (InterruptedException interruptedException) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException executionException) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus validationStatus = ValidationStatus.initialStatus();
        for (DataCollector<?> dataCollector : dLightConfiguration.getConfigurationOptions(false).getCollectors(this)) {
            validationStatus = validationStatus.merge(dataCollector.validate(dLightTarget));
        }
        validationStatus = this.dataCollectorsValidationStatus;
        return this.dataCollectorsValidationStatus;
    }

    @Override
    public final void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
        this.notifyStatusChanged(null, this.validationStatus);
    }

    final synchronized ValidationStatus doValidation(final DLightTarget dLightTarget) {
        this.initCollectors();
        this.initIndicatorDataProviders();
        if (EventQueue.isDispatchThread()) {
            Future future = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus validationStatus = ValidationStatus.initialStatus();
                    for (Validateable<DLightTarget> validateable : DLightTool.this.dataCollectors) {
                        validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
                    }
                    for (Validateable<DLightTarget> validateable : DLightTool.this.indicatorDataProviders) {
                        validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
                    }
                    return validationStatus;
                }
            }, (String)("Validate DataCollectors and IndicatorDataProviders for tool " + this.getID()));
            try {
                return (ValidationStatus)future.get();
            }
            catch (InterruptedException interruptedException) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException executionException) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus validationStatus = ValidationStatus.initialStatus();
        for (DataCollector<?> validateable : this.dataCollectors) {
            validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
        }
        for (IndicatorDataProvider indicatorDataProvider : this.indicatorDataProviders) {
            validationStatus = validationStatus.merge(indicatorDataProvider.validate(dLightTarget));
        }
        return validationStatus;
    }

    @Override
    public final void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    @Override
    public final void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private final void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus != null && validationStatus.equals(validationStatus2)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged(this, validationStatus, validationStatus2);
        }
    }

    public String toString() {
        return this.getName();
    }

    static {
        DLightToolAccessor.setDefault(new DLightToolAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightToolAccessorImpl
    extends DLightToolAccessor {
        private DLightToolAccessorImpl() {
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
            return dLightTool.getIndicatorDataProviders();
        }

        @Override
        public DLightTool newDLightTool(DLightToolConfiguration dLightToolConfiguration) {
            return new DLightTool(dLightToolConfiguration);
        }

        @Override
        public List<Indicator<?>> getIndicators(DLightTool dLightTool) {
            return dLightTool.getIndicators();
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
            return dLightTool.getCollectors();
        }

        @Override
        public boolean collectorsTurnedOn(DLightTool dLightTool) {
            return dLightTool.collectorsTurnedOn();
        }

        @Override
        public void turnCollectorsState(DLightTool dLightTool, boolean bl) {
            dLightTool.turnCollectorsState(null, bl);
        }

        @Override
        public void setDetailsEnabled(DLightTool dLightTool, boolean bl) {
            dLightTool.isDetailsEnabled = bl;
        }

        @Override
        public boolean isDetailsEnabled(DLightTool dLightTool) {
            return dLightTool.isDetailsEnabled;
        }
    }
}

