/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.support.TimerIDPConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimerTicker
extends IndicatorDataProvider<TimerIDPConfiguration>
implements Runnable {
    private static final DataTableMetadata tableMetadata = new DataTableMetadata("time", Arrays.asList(TimerIDPConfiguration.TIME_INFO), null);
    private final Lock lock = new Lock();
    private final IndicatorDataProviderConfiguration configuration;
    private long startTime = 0L;
    private Future tickerService;

    TimerTicker(TimerIDPConfiguration timerIDPConfiguration) {
        this.configuration = timerIDPConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget dLightTarget) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.resetIndicators();
            this.tickerService = DLightExecutorService.scheduleAtFixedRate((Runnable)this, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"TimerTicker");
            this.startTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.tickerService.cancel(true);
            this.tickerService = null;
        }
    }

    @Override
    public void run() {
        DataRow dataRow = new DataRow(Arrays.asList("time"), Arrays.asList(System.currentTimeMillis() - this.startTime));
        this.notifyIndicators(Arrays.asList(dataRow));
    }

    @Override
    public Collection<DataTableMetadata> getDataTablesMetadata() {
        return Arrays.asList(tableMetadata);
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                return;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    @Override
    public ValidationStatus validate(DLightTarget dLightTarget) {
        return ValidationStatus.validStatus();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return ValidationStatus.validStatus();
    }

    @Override
    public void addValidationListener(ValidationListener validationListener) {
    }

    @Override
    public void removeValidationListener(ValidationListener validationListener) {
    }

    @Override
    public String getName() {
        return "Timer";
    }

    @Override
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

