/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette;

import java.awt.Component;
import java.awt.Container;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class HtmlPaletteUtilities {
    public static SourceGroup[] getSourceGroups(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        SourceGroup[] sourceGroupArray = new SourceGroup[]{};
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sourceGroupArray = sources.getSourceGroups("doc_root");
        }
        return sourceGroupArray;
    }

    public static JTree findTreeComponent(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JTree jTree = HtmlPaletteUtilities.findTreeComponent(componentArray[i]);
                if (jTree == null) continue;
                return jTree;
            }
        }
        return null;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string;
        String string2 = fileObject2.getPath();
        String string3 = fileObject.getPath();
        String string4 = string3.substring(0, string3.indexOf("/"));
        if (!string4.equals(string = string2.substring(0, string2.indexOf("/")))) {
            return "";
        }
        string3 = string3.substring(0, string3.lastIndexOf(fileObject.getNameExt()));
        string2 = string2.substring(0, string2.lastIndexOf(fileObject2.getNameExt()));
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string5 = "";
        String string6 = "";
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens() && string5.equals(string6)) {
            string5 = stringTokenizer.nextToken();
            string6 = stringTokenizer2.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer(!string5.equals(string6) ? "../" : "");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("../");
            stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer2 = new StringBuffer(!string5.equals(string6) ? string6 + "/" : "");
        while (stringTokenizer2.hasMoreTokens()) {
            stringBuffer2.append(stringTokenizer2.nextToken() + "/");
        }
        string2 = stringBuffer.toString() + stringBuffer2.toString() + fileObject2.getNameExt();
        return string2;
    }

    public static void insert(String string, JTextComponent jTextComponent) throws BadLocationException {
        HtmlPaletteUtilities.insert(string, jTextComponent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(final String string, final JTextComponent jTextComponent, final boolean bl) throws BadLocationException {
        final Document document = jTextComponent.getDocument();
        if (document == null || !(document instanceof BaseDocument)) {
            return;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        final Reformat reformat = Reformat.get((Document)baseDocument);
        reformat.lock();
        try {
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        String string2 = string == null ? "" : string;
                        int n = HtmlPaletteUtilities.insert(string2, jTextComponent, document);
                        if (bl && n >= 0 && document instanceof BaseDocument) {
                            int n2 = n + string2.length();
                            reformat.reformat(n, n2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
    }

    private static int insert(String string, JTextComponent jTextComponent, Document document) throws BadLocationException {
        int n = -1;
        try {
            Caret caret = jTextComponent.getCaret();
            int n2 = Math.min(caret.getDot(), caret.getMark());
            int n3 = Math.max(caret.getDot(), caret.getMark());
            document.remove(n2, n3 - n2);
            n = caret.getDot();
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n;
    }
}

