/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class AccessibilityQuery {
    private static final Lookup.Result<? extends AccessibilityQueryImplementation> implementations = Lookup.getDefault().lookupResult(AccessibilityQueryImplementation.class);

    private AccessibilityQuery() {
    }

    public static Boolean isPubliclyAccessible(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        for (AccessibilityQueryImplementation accessibilityQueryImplementation : implementations.allInstances()) {
            Boolean bl = accessibilityQueryImplementation.isPubliclyAccessible(fileObject);
            if (bl == null) continue;
            return bl;
        }
        return null;
    }
}

