/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.lib.editor.util.AbstractCharSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.CompactMap;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.PriorityDocumentListenerList;

public final class DocumentUtilities {
    private static final String VERSION_PROP = "version";
    private static final Object TYPING_MODIFICATION_DOCUMENT_PROPERTY = new Object();
    private static final Object TYPING_MODIFICATION_KEY = new Object();
    private static Field numReadersField;
    private static Field currWriterField;

    private DocumentUtilities() {
    }

    public static void addDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        if (!DocumentUtilities.addPriorityDocumentListener(document, documentListener, documentListenerPriority)) {
            document.addDocumentListener(documentListener);
        }
    }

    public static boolean addPriorityDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.add(documentListener, documentListenerPriority.getPriority());
            return true;
        }
        return false;
    }

    public static void removeDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        if (!DocumentUtilities.removePriorityDocumentListener(document, documentListener, documentListenerPriority)) {
            document.removeDocumentListener(documentListener);
        }
    }

    public static boolean removePriorityDocumentListener(Document document, DocumentListener documentListener, DocumentListenerPriority documentListenerPriority) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        if (priorityDocumentListenerList != null) {
            priorityDocumentListenerList.remove(documentListener, documentListenerPriority.getPriority());
            return true;
        }
        return false;
    }

    public static DocumentListener initPriorityListening(Document document) {
        if (document.getProperty(PriorityDocumentListenerList.class) != null) {
            throw new IllegalStateException("PriorityDocumentListenerList already initialized for doc=" + document);
        }
        PriorityDocumentListenerList priorityDocumentListenerList = new PriorityDocumentListenerList();
        document.putProperty(PriorityDocumentListenerList.class, priorityDocumentListenerList);
        return priorityDocumentListenerList;
    }

    public static int getDocumentListenerCount(Document document) {
        PriorityDocumentListenerList priorityDocumentListenerList = (PriorityDocumentListenerList)document.getProperty(PriorityDocumentListenerList.class);
        return priorityDocumentListenerList != null ? priorityDocumentListenerList.getListenerCount() : (document instanceof AbstractDocument ? ((DocumentListener[])((AbstractDocument)document).getListeners(DocumentListener.class)).length : 0);
    }

    public static void setTypingModification(Document document, boolean bl) {
        document.putProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY, bl);
    }

    public static boolean isTypingModification(Document document) {
        Boolean bl = (Boolean)document.getProperty(TYPING_MODIFICATION_DOCUMENT_PROPERTY);
        return bl != null ? bl : false;
    }

    public static boolean isTypingModification(DocumentEvent documentEvent) {
        return DocumentUtilities.isTypingModification(documentEvent.getDocument());
    }

    public static CharSequence getText(Document document) {
        CharSequence charSequence = (CharSequence)document.getProperty(CharSequence.class);
        if (charSequence == null) {
            charSequence = new DocumentCharSequence(document);
            document.putProperty(CharSequence.class, charSequence);
        }
        return charSequence;
    }

    public static CharSequence getText(Document document, int n, int n2) throws BadLocationException {
        CharSequence charSequence = DocumentUtilities.getText(document);
        try {
            return charSequence.subSequence(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n3 = n;
            if (n >= 0 && n + n2 > charSequence.length()) {
                n3 = n2;
            }
            BadLocationException badLocationException = new BadLocationException(indexOutOfBoundsException.getMessage(), n3);
            badLocationException.initCause(indexOutOfBoundsException);
            throw badLocationException;
        }
    }

    public static void addEventPropertyStorage(DocumentEvent documentEvent) {
        if (!(documentEvent instanceof UndoableEdit)) {
            throw new IllegalStateException("evt not instanceof UndoableEdit: " + documentEvent);
        }
        ((UndoableEdit)((Object)documentEvent)).addEdit(new EventPropertiesElementChange());
    }

    public static Object getEventProperty(DocumentEvent documentEvent, Object object) {
        EventPropertiesElementChange eventPropertiesElementChange = (EventPropertiesElementChange)documentEvent.getChange(EventPropertiesElement.INSTANCE);
        return eventPropertiesElementChange != null ? eventPropertiesElementChange.getProperty(object) : null;
    }

    public static void putEventProperty(DocumentEvent documentEvent, Object object, Object object2) {
        EventPropertiesElementChange eventPropertiesElementChange = (EventPropertiesElementChange)documentEvent.getChange(EventPropertiesElement.INSTANCE);
        if (eventPropertiesElementChange == null) {
            throw new IllegalStateException("addEventPropertyStorage() not called for evt=" + documentEvent);
        }
        eventPropertiesElementChange.putProperty(object, object2);
    }

    public static void putEventProperty(DocumentEvent documentEvent, Map.Entry entry) {
        if (entry instanceof CompactMap.MapEntry) {
            EventPropertiesElementChange eventPropertiesElementChange = (EventPropertiesElementChange)documentEvent.getChange(EventPropertiesElement.INSTANCE);
            if (eventPropertiesElementChange == null) {
                throw new IllegalStateException("addEventPropertyStorage() not called for evt=" + documentEvent);
            }
            eventPropertiesElementChange.putEntry((CompactMap.MapEntry)entry);
        } else {
            DocumentUtilities.putEventProperty(documentEvent, entry.getKey(), entry.getValue());
        }
    }

    public static int fixOffset(int n, DocumentEvent documentEvent) {
        int n2 = documentEvent.getOffset();
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
            if (n >= n2) {
                n += documentEvent.getLength();
            }
        } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && n > n2) {
            n = Math.min(n - documentEvent.getLength(), n2);
        }
        return n;
    }

    public static String getModificationText(DocumentEvent documentEvent) {
        return (String)DocumentUtilities.getEventProperty(documentEvent, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReadLocked(Document document) {
        if (DocumentUtilities.checkAbstractDoc(document)) {
            if (DocumentUtilities.isWriteLocked(document)) {
                return true;
            }
            if (numReadersField == null) {
                try {
                    numReadersField = AbstractDocument.class.getDeclaredField("numReaders");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalStateException(noSuchFieldException);
                }
                numReadersField.setAccessible(true);
            }
            try {
                Document document2 = document;
                synchronized (document2) {
                    return numReadersField.getInt(document) > 0;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWriteLocked(Document document) {
        if (DocumentUtilities.checkAbstractDoc(document)) {
            if (currWriterField == null) {
                try {
                    currWriterField = AbstractDocument.class.getDeclaredField("currWriter");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new IllegalStateException(noSuchFieldException);
                }
                currWriterField.setAccessible(true);
            }
            try {
                Document document2 = document;
                synchronized (document2) {
                    return currWriterField.get(document) == Thread.currentThread();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
        }
        return false;
    }

    private static boolean checkAbstractDoc(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("document is null");
        }
        return document instanceof AbstractDocument;
    }

    public static Element getParagraphElement(Document document, int n) {
        Element element;
        if (document instanceof StyledDocument) {
            element = ((StyledDocument)document).getParagraphElement(n);
        } else {
            int n2;
            Element element2 = document.getDefaultRootElement();
            element = element2.getElement(n2 = element2.getElementIndex(n));
            if (n < element.getStartOffset() || n >= element.getEndOffset()) {
                element = null;
            }
        }
        return element;
    }

    public static Element getParagraphRootElement(Document document) {
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(0).getParentElement();
        }
        return document.getDefaultRootElement().getElement(0).getParentElement();
    }

    public static String debugOffset(Document document, int n) {
        return DocumentUtilities.appendOffset(null, document, n).toString();
    }

    public static StringBuilder appendOffset(StringBuilder stringBuilder, Document document, int n) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(50);
        }
        stringBuilder.append(n).append('[');
        if (n < 0) {
            stringBuilder.append("<0");
        } else if (n > document.getLength() + 1) {
            stringBuilder.append(">").append(document.getLength());
        } else {
            Element element = DocumentUtilities.getParagraphRootElement(document);
            int n2 = element.getElementIndex(n);
            Element element2 = element.getElement(n2);
            stringBuilder.append(n2 + 1).append(':');
            stringBuilder.append(DocumentUtilities.visualColumn(document, element2.getStartOffset(), n) + 1);
        }
        stringBuilder.append(']');
        return stringBuilder;
    }

    public static StringBuilder appendEvent(StringBuilder stringBuilder, DocumentEvent documentEvent) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(100);
        }
        DocumentEvent.EventType eventType = documentEvent.getType();
        stringBuilder.append(eventType).append(", ");
        DocumentUtilities.appendOffset(stringBuilder, documentEvent.getDocument(), documentEvent.getOffset());
        stringBuilder.append(", l=").append(documentEvent.getLength());
        String string = DocumentUtilities.getModificationText(documentEvent);
        if (string != null) {
            stringBuilder.append(", modText=\"");
            CharSequenceUtilities.debugText(stringBuilder, (CharSequence)string);
            stringBuilder.append('\"');
        }
        return stringBuilder;
    }

    private static int visualColumn(Document document, int n, int n2) {
        Integer n3 = (Integer)document.getProperty("tabSize");
        int n4 = n3 != null ? n3 : 8;
        CharSequence charSequence = DocumentUtilities.getText(document);
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\t') {
                n5 = (n5 + n4) / n4 * n4;
                continue;
            }
            ++n5;
        }
        return n5;
    }

    public static String getMimeType(Document document) {
        return (String)document.getProperty("mimeType");
    }

    public static String getMimeType(JTextComponent jTextComponent) {
        EditorKit editorKit;
        Document document = jTextComponent.getDocument();
        String string = DocumentUtilities.getMimeType(document);
        if (string == null && (editorKit = jTextComponent.getUI().getEditorKit(jTextComponent)) != null) {
            string = editorKit.getContentType();
        }
        return string;
    }

    public static long getDocumentVersion(Document document) {
        Object object = document.getProperty(VERSION_PROP);
        return object instanceof AtomicLong ? ((AtomicLong)object).get() : 0L;
    }

    private static final class EventPropertiesElementChange
    implements DocumentEvent.ElementChange,
    UndoableEdit {
        private CompactMap eventProperties = new CompactMap();

        private EventPropertiesElementChange() {
        }

        public synchronized Object getProperty(Object object) {
            return this.eventProperties != null ? this.eventProperties.get(object) : null;
        }

        public synchronized Object putProperty(Object object, Object object2) {
            return this.eventProperties.put(object, object2);
        }

        public synchronized CompactMap.MapEntry putEntry(CompactMap.MapEntry mapEntry) {
            return this.eventProperties.putEntry(mapEntry);
        }

        public int getIndex() {
            return -1;
        }

        public Element getElement() {
            return EventPropertiesElement.INSTANCE;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            return null;
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public void undo() throws CannotUndoException {
        }

        public void redo() throws CannotRedoException {
        }

        public boolean isSignificant() {
            return false;
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public String getPresentationName() {
            return "";
        }

        public void die() {
        }

        public boolean canUndo() {
            return true;
        }

        public boolean canRedo() {
            return true;
        }
    }

    private static final class EventPropertiesElement
    implements Element {
        static final EventPropertiesElement INSTANCE = new EventPropertiesElement();

        private EventPropertiesElement() {
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public Element getElement(int n) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "Helper element for modification text providing";
        }

        public Document getDocument() {
            return null;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class DocumentCharSequence
    extends AbstractCharSequence.StringLike {
        private final Segment segment = new Segment();
        private final Document doc;

        DocumentCharSequence(Document document) {
            this.doc = document;
        }

        public int length() {
            return this.doc.getLength() + 1;
        }

        public synchronized char charAt(int n) {
            try {
                this.doc.getText(n, 1, this.segment);
            }
            catch (BadLocationException badLocationException) {
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(badLocationException.getMessage() + " at offset=" + badLocationException.offsetRequested());
                indexOutOfBoundsException.initCause(badLocationException);
                throw indexOutOfBoundsException;
            }
            char c = this.segment.array[this.segment.offset];
            this.segment.array = null;
            return c;
        }
    }
}

