/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.extras.api.AxisMarksProvider;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.support.DefaultViewportModel;
import org.netbeans.modules.dlight.extras.api.support.TimeMarksProvider;
import org.netbeans.modules.dlight.extras.api.support.ValueMarksProvider;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPainter;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesDataContainer;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesPlot
extends JComponent
implements ViewportAware,
ChangeListener,
DataFilterListener {
    private static final long EXTENT = 20000000000L;
    private final GraphPainter graph;
    private ViewportModel viewportModel;
    private int upperLimit;
    private Axis hAxis;
    private Axis vAxis;
    private AxisMarksProvider timeMarksProvider;
    private AxisMarksProvider valueMarksProvider;
    private final Object timeFilterLock = new Object();
    private volatile TimeIntervalDataFilter timeFilter;

    public TimeSeriesPlot(int n, ValueFormatter valueFormatter, List<TimeSeriesDescriptor> list, TimeSeriesDataContainer timeSeriesDataContainer) {
        this.upperLimit = n;
        TimeSeriesDataContainer timeSeriesDataContainer2 = timeSeriesDataContainer;
        timeSeriesDataContainer2.setTimeSeriesPlot(this);
        this.graph = new GraphPainter(list, timeSeriesDataContainer2);
        this.timeMarksProvider = TimeMarksProvider.newInstance();
        this.valueMarksProvider = ValueMarksProvider.newInstance((ValueFormatter)valueFormatter);
        DefaultViewportModel defaultViewportModel = new DefaultViewportModel(new Range((Number)0L, (Number)0L), new Range((Number)0L, (Number)20000000000L));
        defaultViewportModel.setMinViewportSize(1000000000L);
        this.setViewportModel((ViewportModel)defaultViewportModel);
        this.setOpaque(true);
    }

    public JComponent getVerticalAxis() {
        if (this.vAxis == null) {
            this.vAxis = new Axis(AxisOrientation.VERTICAL);
        }
        return this.vAxis;
    }

    public JComponent getHorizontalAxis() {
        if (this.hAxis == null) {
            this.hAxis = new Axis(AxisOrientation.HORIZONTAL);
        }
        return this.hAxis;
    }

    public void setUpperLimit(int n) {
        if (n != this.upperLimit) {
            this.upperLimit = n;
            this.repaint();
            if (this.vAxis != null) {
                this.vAxis.repaint();
            }
        }
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public int calculateUpperLimit(float ... fArray) {
        return this.graph.calculateUpperLimit(fArray);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        FontMetrics fontMetrics = graphics.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
        FontMetrics fontMetrics2 = graphics.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
        Range range = this.viewportModel.getViewport();
        List list = this.timeMarksProvider.getAxisMarks(((Long)range.getStart()).longValue(), ((Long)range.getEnd()).longValue(), this.getWidth(), fontMetrics);
        List list2 = this.valueMarksProvider.getAxisMarks(0L, (long)this.upperLimit, this.getHeight() - fontMetrics2.getAscent() / 2, fontMetrics2);
        TimeIntervalDataFilter timeIntervalDataFilter = this.timeFilter;
        if (timeIntervalDataFilter != null) {
            Range range2 = timeIntervalDataFilter.getInterval();
            n2 = range2.getStart() == null ? Integer.MIN_VALUE : (int)TimeUnit.NANOSECONDS.toSeconds((Long)range2.getStart());
            n = range2.getEnd() == null ? Integer.MAX_VALUE : (int)TimeUnit.NANOSECONDS.toSeconds((Long)range2.getEnd());
        } else {
            n2 = Integer.MIN_VALUE;
            n = Integer.MAX_VALUE;
        }
        this.graph.paint(graphics, this.upperLimit, list2, (int)((Long)range.getStart() / 1000000000L), (int)((Long)range.getEnd() / 1000000000L), list, n2, n, 0, 0, this.getWidth(), this.getHeight(), this.isEnabled());
    }

    public ViewportModel getViewportModel() {
        return this.viewportModel;
    }

    public void setViewportModel(ViewportModel viewportModel) {
        if (this.viewportModel != null) {
            this.viewportModel.removeChangeListener((ChangeListener)this);
        }
        this.viewportModel = viewportModel;
        this.viewportModel.addChangeListener((ChangeListener)this);
        this.repaintAll();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.viewportModel) {
            this.repaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataFilterManager(DataFilterManager dataFilterManager) {
        if (dataFilterManager != null) {
            dataFilterManager.addDataFilterListener((DataFilterListener)this);
        } else {
            Object object = this.timeFilterLock;
            synchronized (object) {
                this.timeFilter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        TimeIntervalDataFilter timeIntervalDataFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, list);
        Object object = this.timeFilterLock;
        synchronized (object) {
            if (timeIntervalDataFilter != this.timeFilter) {
                this.timeFilter = timeIntervalDataFilter;
                UIThread.invoke((Runnable)new Runnable(){

                    public void run() {
                        TimeSeriesPlot.this.repaintAll();
                    }
                });
            }
        }
    }

    public void repaintAll() {
        this.repaint();
        if (this.hAxis != null) {
            this.hAxis.repaint();
        }
        if (this.vAxis != null) {
            this.vAxis.repaint();
        }
    }

    private class Axis
    extends JComponent {
        private final AxisOrientation orientation;

        public Axis(AxisOrientation axisOrientation) {
            this.orientation = axisOrientation;
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.isEnabled()) {
                switch (this.orientation) {
                    case VERTICAL: {
                        FontMetrics fontMetrics = graphics.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.y_axis.font"));
                        List list = TimeSeriesPlot.this.valueMarksProvider.getAxisMarks(0L, (long)TimeSeriesPlot.this.upperLimit, this.getHeight() - fontMetrics.getAscent() / 2, fontMetrics);
                        TimeSeriesPlot.this.graph.paintVerticalAxis(graphics, 0, 0, this.getWidth(), this.getHeight(), list, this.getBackground());
                        break;
                    }
                    case HORIZONTAL: {
                        Range range = TimeSeriesPlot.this.viewportModel.getViewport();
                        FontMetrics fontMetrics = graphics.getFontMetrics(DLightUIPrefs.getFont((String)"indicator.x_axis.font"));
                        List list = TimeSeriesPlot.this.timeMarksProvider.getAxisMarks(((Long)range.getStart()).longValue(), ((Long)range.getEnd()).longValue(), this.getWidth(), fontMetrics);
                        TimeSeriesPlot.this.graph.paintHorizontalAxis(graphics, 0, 0, this.getWidth(), this.getHeight(), list, this.getBackground());
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AxisOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

