/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;

    SimpleTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel<WizardDescriptor> panel, boolean bl) {
        this.folders = sourceGroupArray;
        if (sourceGroupArray != null && sourceGroupArray.length == 0) {
            throw new IllegalArgumentException("Attempting to create panel with an empty folders list");
        }
        this.project = project;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = bl;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx helpCtx;
        if (this.bottomPanel != null && (helpCtx = this.bottomPanel.getHelp()) != null) {
            return helpCtx;
        }
        return null;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.gui != null && this.gui.getTargetName() != null && this.gui.getTargetGroup() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!bl) {
            return false;
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        String string = ProjectUtilities.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), fileObject.getExt(), this.isFolder);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        return string == null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        FileObject fileObject;
        this.wizard = wizardDescriptor;
        if (this.gui == null) {
            this.getComponent();
        }
        if ((fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard)) == null) {
            fileObject = this.project.getProjectDirectory();
        }
        String string = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), fileObject, string);
        Object object = this.gui.getClientProperty("NewFileWizard_Title");
        if (object != null) {
            this.wizard.putProperty("NewFileWizard_Title", object);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizardDescriptor);
        }
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(wizardDescriptor.getValue())) {
            return;
        }
        if (!wizardDescriptor.getValue().equals(WizardDescriptor.CANCEL_OPTION) && this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizardDescriptor);
            }
            FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
            String string = this.gui.getTargetName();
            if (string.indexOf(47) > 0) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)wizardDescriptor, (String)string);
        }
        wizardDescriptor.putProperty("NewFileWizard_Title", null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.changeSupport.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        Object object;
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string = this.gui.getTargetFolder();
        String string2 = this.gui.getTargetName();
        if (string2.indexOf(47) > 0) {
            object = string2.substring(0, string2.lastIndexOf(47));
            string = string == null || "".equals(string) ? object : string + '/' + (String)object;
        }
        if ((object = string == null ? fileObject : fileObject.getFileObject(string)) == null) {
            try {
                object = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
        return object;
    }
}

