/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard.impl;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.text.api.XMLFormatUtil;
import org.netbeans.modules.xml.util.Util;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DocumentModel;
import org.netbeans.modules.xml.wizard.XMLContentPanel;
import org.netbeans.modules.xml.wizard.XMLGeneratorVisitor;
import org.netbeans.modules.xml.wizard.impl.DTDPanel;
import org.netbeans.modules.xml.wizard.impl.DocumentPanel;
import org.netbeans.modules.xml.wizard.impl.SchemaObject;
import org.netbeans.modules.xml.wizard.impl.SchemaPanel;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class XMLWizardIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 5070430920636117204L;
    private static final String XML_EXT = "xml";
    private transient TemplateWizard templateWizard;
    private transient DocumentModel model;
    private transient int current;
    private static final int TARGET_PANEL = 0;
    private transient WizardDescriptor.Panel targetPanel;
    private static final int DOCUMENT_PANEL = 1;
    private transient DocumentPanel documentPanel;
    private static final int CONSTRAINT_PANEL = 2;
    private transient SchemaPanel schemaPanel;
    private transient DTDPanel dtdPanel;
    private static final int CONTENT_PANEL = 3;
    private transient XMLContentPanel xmlPanel;
    private static Reference<XMLWizardIterator> instance;
    private transient Map listenersMap = new HashMap(2);
    private transient String[] beforeSteps;
    private transient Object targetSteps;

    public static synchronized XMLWizardIterator singleton() {
        XMLWizardIterator xMLWizardIterator;
        XMLWizardIterator xMLWizardIterator2 = xMLWizardIterator = instance == null ? null : instance.get();
        if (xMLWizardIterator == null) {
            xMLWizardIterator = new XMLWizardIterator();
            instance = new WeakReference<XMLWizardIterator>(xMLWizardIterator);
        }
        return xMLWizardIterator;
    }

    public void initialize(TemplateWizard templateWizard) {
        Object object;
        this.templateWizard = templateWizard;
        this.current = 0;
        URL uRL = null;
        try {
            object = templateWizard.getTargetFolder();
            uRL = object.getPrimaryFile().getURL();
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model = new DocumentModel(uRL);
        object = templateWizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            this.beforeSteps = (String[])object;
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.targetPanel != null) {
            ((JComponent)this.targetPanel.getComponent()).putClientProperty("WizardPanel_contentData", this.targetSteps);
            this.targetPanel = null;
        }
        this.current = -1;
        this.model = null;
        templateWizard = null;
        this.schemaPanel = null;
        this.dtdPanel = null;
        this.documentPanel = null;
        this.xmlPanel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Object object;
        DataFolder dataFolder = templateWizard.getTargetFolder();
        File file = FileUtil.toFile((FileObject)dataFolder.getPrimaryFile());
        String string = templateWizard.getTargetName();
        if (string == null || "null".equals(string)) {
            string = "XMLDocument";
        }
        final FileObject fileObject = dataFolder.getPrimaryFile();
        String string2 = string;
        int n = 2;
        while (fileObject.getFileObject(string2, XML_EXT) != null) {
            string2 = string + n;
            ++n;
        }
        final String string3 = string2;
        String string4 = EncodingUtil.getProjectEncoding((FileObject)dataFolder.getPrimaryFile());
        if (!EncodingUtil.isValidEncoding((String)string4)) {
            string4 = "UTF-8";
        }
        String string5 = string3 + "." + XML_EXT;
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2;
                fileObjectArray[0] = fileObject2 = fileObject.createData(string3, XMLWizardIterator.XML_EXT);
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        StringBuffer stringBuffer = new StringBuffer();
        this.writeXMLComment(stringBuffer, string5, string4);
        this.writeXMLFile(stringBuffer);
        FileLock fileLock = null;
        try {
            fileLock = fileObjectArray[0].lock();
            object = fileObjectArray[0].getOutputStream(fileLock);
            object = new BufferedOutputStream((OutputStream)object, 999);
            outputStreamWriter = new OutputStreamWriter((OutputStream)object, string4);
            outputStreamWriter.write(stringBuffer.toString());
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            fileLock.releaseLock();
            fileLock = null;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        object = new HashSet(1);
        outputStreamWriter = DataObject.find((FileObject)fileObjectArray[0]);
        GuiUtil.performDefaultAction((DataObject)outputStreamWriter);
        object.add(outputStreamWriter);
        this.formatXML(fileObjectArray[0]);
        return object;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.currentComponent();
        if (panel.getComponent() instanceof JComponent) {
            ((JComponent)panel.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.current));
        }
        return panel;
    }

    private WizardDescriptor.Panel currentComponent() {
        switch (this.current) {
            case 0: {
                return this.getTargetPanel();
            }
            case 1: {
                return this.getDocumentPanel();
            }
            case 2: {
                switch (this.model.getType()) {
                    case 1: {
                        return this.getDTDPanel();
                    }
                    case 2: {
                        return this.getSchemaPanel();
                    }
                }
                throw new IllegalStateException();
            }
            case 3: {
                return this.getXMLContentPanel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        boolean bl = this.model.getType() == 0;
        int n = 0;
        if (this.model.getType() == 2) {
            n = 3;
        }
        if (this.model.getType() == 0) {
            n = 1;
        } else if (this.model.getType() == 1) {
            n = 2;
        }
        return this.current < n;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public String name() {
        return NbBundle.getMessage(XMLWizardIterator.class, (String)"TITLE_x_of_y", (Object)(this.current + 1), (Object)this.current);
    }

    public void nextPanel() {
        ++this.current;
    }

    public void previousPanel() {
        --this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            Object v = this.listenersMap.remove(changeListener);
            if (v == null) {
                return;
            }
            if (this.model == null) {
                return;
            }
            this.model.removePropertyChangeListener((PropertyChangeListener)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(final ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        Map map = this.listenersMap;
        synchronized (map) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                final ChangeEvent EVENT;
                {
                    this.EVENT = new ChangeEvent(XMLWizardIterator.this);
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    changeListener.stateChanged(this.EVENT);
                }
            };
            if (this.listenersMap.put(changeListener, propertyChangeListener) == null) {
                this.model.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private WizardDescriptor.Panel getDocumentPanel() {
        if (this.documentPanel == null) {
            this.documentPanel = new DocumentPanel();
            this.documentPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString(XMLWizardIterator.class, "MSG_unknown")};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.documentPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.documentPanel);
    }

    private WizardDescriptor.Panel getDTDPanel() {
        if (this.dtdPanel == null) {
            this.dtdPanel = new DTDPanel();
            this.dtdPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getDTDPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.dtdPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.dtdPanel);
    }

    private WizardDescriptor.Panel getSchemaPanel() {
        if (this.schemaPanel == null) {
            this.schemaPanel = new SchemaPanel(this.templateWizard);
            this.schemaPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.schemaPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.schemaPanel);
    }

    private WizardDescriptor.Panel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = this.templateWizard.targetChooser();
            if (this.targetPanel.getComponent() instanceof JComponent) {
                JComponent jComponent = (JComponent)this.targetPanel.getComponent();
                this.targetSteps = jComponent.getClientProperty("WizardPanel_contentData");
                String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), Util.THIS.getString(XMLWizardIterator.class, "MSG_unknown")};
                String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
                jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
            }
        }
        return this.targetPanel;
    }

    private String getTargetPanelName() {
        Component component = this.getTargetPanel().getComponent();
        if (component instanceof JComponent) {
            return ((JComponent)component).getName();
        }
        return "";
    }

    private String getDocumentPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_doc_panel_name");
    }

    private String getDTDPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_dtd_panel_name");
    }

    private String getSchemaPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_schema_panel_name");
    }

    private static String[] createSteps(String[] stringArray, String[] stringArray2) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray3 = new String[stringArray.length - n + stringArray2.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = i < stringArray.length - n ? stringArray[i] : stringArray2[i - stringArray.length + n];
        }
        return stringArray3;
    }

    private WizardDescriptor.Panel getXMLContentPanel() {
        if (this.xmlPanel == null) {
            this.xmlPanel = new XMLContentPanel();
            this.xmlPanel.setObject(this.model);
            String[] stringArray = new String[]{this.getTargetPanelName(), this.getDocumentPanelName(), this.getSchemaPanelName(), this.getXMLContentPanelName()};
            String[] stringArray2 = XMLWizardIterator.createSteps(this.beforeSteps, stringArray);
            this.xmlPanel.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        return new AbstractPanel.WizardStep(this.xmlPanel);
    }

    private String getXMLContentPanelName() {
        return Util.THIS.getString(XMLWizardIterator.class, "PROP_xml_content_panel_name");
    }

    private void generateXMLBody(DocumentModel documentModel, String string, StringBuffer stringBuffer) {
        String string2 = documentModel.getPrimarySchema();
        if (documentModel.getPrimarySchema().startsWith("http")) {
            string2 = this.retrieveURLSchema(documentModel.getPrimarySchema());
        }
        XMLGeneratorVisitor xMLGeneratorVisitor = new XMLGeneratorVisitor(string2, documentModel.getXMLContentAttributes(), stringBuffer);
        xMLGeneratorVisitor.generateXML(string);
    }

    private String retrieveURLSchema(String string) {
        try {
            String string2;
            Comparable<URI> comparable;
            URI uRI;
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject fileObject = project.getProjectDirectory();
            File file = FileUtil.toFile((FileObject)fileObject);
            Object var5_6 = null;
            URI uRI2 = null;
            CacheDirectoryProvider cacheDirectoryProvider = (CacheDirectoryProvider)project.getLookup().lookup(CacheDirectoryProvider.class);
            String string3 = "private/cache/retriever";
            try {
                if (cacheDirectoryProvider != null && cacheDirectoryProvider.getCacheDirectory() != null) {
                    uRI = file.toURI();
                    comparable = FileUtil.toFile((FileObject)cacheDirectoryProvider.getCacheDirectory()).toURI();
                    string2 = Utilities.relativize((URI)uRI, (URI)comparable);
                    string3 = string2 + "/" + "retriever";
                }
                uRI2 = new URI(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRI2 == null) {
                return null;
            }
            uRI = file.toURI().resolve(uRI2);
            comparable = new File(uRI);
            if (!((File)comparable).isDirectory()) {
                ((File)comparable).mkdirs();
            }
            string2 = RetrieverEngine.getRetrieverEngine(comparable, (boolean)false);
            RetrieveEntry retrieveEntry = new RetrieveEntry(null, string, null, null, Utilities.DocumentTypesEnum.schema, true);
            string2.addResourceToRetrieve(retrieveEntry);
            string2.setFileOverwrite(true);
            string2.start();
            String string4 = ((File)comparable).getPath() + string.substring(6, string.length());
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void modifyRootElementAttrs(StringBuffer stringBuffer) {
        Map<String, String> map = this.model.getXMLContentAttributes().getNamespaceToPrefixMap();
        if (map == null || map.size() == 0) {
            return;
        }
        int n = stringBuffer.indexOf("xmlns");
        int n2 = stringBuffer.indexOf("xmlns", n + 1);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (String string : map.keySet()) {
            String string2;
            String string3 = map.get(string);
            if (string3 == null || string3.trim().length() <= 0 || stringBuffer.indexOf(string2 = "xmlns:" + string3 + "='" + string + "'") != -1) continue;
            stringBuffer.insert(n2, string2 + "\n   ");
        }
        stringBuffer.insert(n2, stringBuffer2.toString());
    }

    private void writeXMLFile(StringBuffer stringBuffer) throws IOException {
        DataFolder dataFolder = this.templateWizard.getTargetFolder();
        File file = FileUtil.toFile((FileObject)dataFolder.getPrimaryFile());
        String string = this.model.getRoot();
        if (string == null) {
            string = "root";
        }
        String string2 = this.model.getPrefix();
        if (this.model.getType() == 1) {
            if (this.model.getPublicID() == null) {
                stringBuffer.append("<!DOCTYPE " + string + " SYSTEM '" + this.model.getSystemID() + "'>\n");
            } else {
                stringBuffer.append("<!DOCTYPE " + string + " PUBLIC '" + this.model.getPublicID() + "' '" + this.model.getSystemID() + "'>\n");
            }
            stringBuffer.append("<" + string + ">\n");
        } else if (this.model.getType() == 2) {
            String string3 = this.model.getNamespace();
            List list = this.model.getSchemaNodes();
            if (string2 == null || "".equals(string2)) {
                stringBuffer.append("<" + string + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
            } else {
                stringBuffer.append("<" + string2 + ":" + string + "  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (list != null) {
                SchemaObject schemaObject;
                int n;
                for (n = 0; n < list.size(); ++n) {
                    schemaObject = (SchemaObject)list.get(n);
                    hashMap.put(schemaObject.getNamespace(), schemaObject.getPrefix());
                    if (schemaObject.getPrefix() == null || "".equals(schemaObject.getPrefix())) {
                        stringBuffer.append("   xmlns='" + schemaObject.getNamespace() + "'\n");
                        continue;
                    }
                    stringBuffer.append("   xmlns:" + schemaObject.getPrefix() + "='" + schemaObject.getNamespace() + "'\n");
                }
                for (n = 0; n < list.size(); ++n) {
                    schemaObject = (SchemaObject)list.get(n);
                    String string4 = null;
                    string4 = schemaObject.toString().startsWith("http") ? schemaObject.toString() : Util.getRelativePath(new File(schemaObject.getSchemaFileName()), file);
                    if (n == 0) {
                        if (list.size() == 1) {
                            stringBuffer.append("   xsi:schemaLocation='" + schemaObject.getNamespace() + " " + string4 + "'>\n");
                            continue;
                        }
                        stringBuffer.append("   xsi:schemaLocation='" + schemaObject.getNamespace() + " " + string4 + "\n");
                        continue;
                    }
                    if (n == list.size() - 1) {
                        stringBuffer.append("   " + schemaObject.getNamespace() + " " + string4 + "'>\n");
                        continue;
                    }
                    stringBuffer.append("   " + schemaObject.getNamespace() + " " + string4 + "\n");
                }
            }
            this.model.getXMLContentAttributes().setNamespaceToPrefixMap(hashMap);
            this.generateXMLBody(this.model, string, stringBuffer);
            this.modifyRootElementAttrs(stringBuffer);
        } else {
            stringBuffer.append("<" + string + ">\n");
        }
        if (string2 == null || "".equals(string2)) {
            stringBuffer.append("\n");
            stringBuffer.append("</" + string + ">\n");
        } else {
            stringBuffer.append("\n");
            stringBuffer.append("</" + string2 + ":" + string + ">\n");
        }
    }

    private void writeXMLComment(StringBuffer stringBuffer, String string, String string2) throws IOException {
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>\n");
        stringBuffer.append("\n");
        Date date = new Date();
        String string3 = DateFormat.getDateInstance(1).format(date);
        String string4 = DateFormat.getTimeInstance(3).format(date);
        String string5 = System.getProperty("user.name");
        stringBuffer.append("<!--\n");
        stringBuffer.append("    Document   : " + string + "\n");
        stringBuffer.append("    Created on : " + string3 + ", " + string4 + "\n");
        stringBuffer.append("    Author     : " + string5 + "\n");
        stringBuffer.append("    Description:\n");
        stringBuffer.append("        Purpose of the document follows.\n");
        stringBuffer.append("-->\n");
        stringBuffer.append("\n");
    }

    private void formatXML(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            BaseDocument baseDocument = (BaseDocument)editorCookie.getDocument();
            XMLFormatUtil.reformat((BaseDocument)baseDocument, (int)0, (int)baseDocument.getLength());
            EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie instanceof TextEditorSupport && editCookie != null) {
                ((TextEditorSupport)editCookie).saveDocument();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

