/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestReparseAction
extends TestProjectActionBase {
    private static boolean running = false;

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestProjectReparse");
    }

    @Override
    protected void performAction(Collection<CsmProject> collection) {
        if (collection != null && !collection.isEmpty()) {
            this.testReparse(collection);
        }
    }

    private void testReparse(Collection<CsmProject> collection) {
        for (CsmProject csmProject : collection) {
            this.testReparse((ProjectBase)csmProject);
        }
    }

    private void testReparse(ProjectBase projectBase) {
        String string = "Parser Errors " + projectBase.getName();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        progressHandle.switchToDeterminate(projectBase.getAllFiles().size());
        int n = 0;
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        for (CsmFile csmFile : projectBase.getSourceFiles()) {
            progressHandle.progress("Parsing " + csmFile.getName(), n++);
            this.testReparse((FileImpl)csmFile, inputOutput.getOut());
        }
        for (CsmFile csmFile : projectBase.getHeaderFiles()) {
            progressHandle.progress("Parsing " + csmFile.getName(), n++);
            this.testReparse((FileImpl)csmFile, inputOutput.getOut());
        }
        progressHandle.finish();
    }

    private void testReparse(final FileImpl fileImpl, final OutputWriter outputWriter) {
        for (CsmInclude csmInclude : fileImpl.getIncludes()) {
            if (csmInclude.getIncludeFile() != null) continue;
            int n = csmInclude.getStartPosition().getLine();
            int n2 = csmInclude.getStartPosition().getColumn();
            char c = csmInclude.isSystem() ? (char)'<' : '\"';
            char c2 = csmInclude.isSystem() ? (char)'>' : '\"';
            this.printError(outputWriter, (CsmFile)fileImpl, n, n2, "Unresolved include: " + c + csmInclude.getIncludeName() + c2);
        }
        fileImpl.getErrors(new FileImpl.ErrorListener(){

            public void error(String string, int n, int n2) {
                TestReparseAction.this.printError(outputWriter, (CsmFile)fileImpl, n, n2, string);
            }
        });
    }

    private void printError(OutputWriter outputWriter, CsmFile csmFile, int n, int n2, String string) {
        ErrorInfo errorInfo = new ErrorInfo(n, n2, string);
        string = ((Object)csmFile.getAbsolutePath()).toString() + ':' + errorInfo.line + ':' + errorInfo.column + ": " + errorInfo.text;
        try {
            outputWriter.println(string, (OutputListener)new MyOutputListener(csmFile, errorInfo));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static class MyOutputListener
    implements OutputListener {
        private CsmFile file;
        private ErrorInfo info;

        public MyOutputListener(CsmFile csmFile, ErrorInfo errorInfo) {
            this.file = csmFile;
            this.info = errorInfo;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            CsmUtilities.openSource((CsmFile)this.file, (int)this.info.line, (int)this.info.column);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }

    private static class ErrorInfo {
        public final int line;
        public final int column;
        public final String text;

        public ErrorInfo(int n, int n2, String string) {
            this.line = n;
            this.column = n2;
            this.text = string;
        }
    }
}

