/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class EditorDebug {
    private EditorDebug() {
    }

    public static void dumpPlanes(BaseDocument baseDocument) {
    }

    public static void dumpSyntaxMarks(BaseDocument baseDocument) {
        System.out.println("--------------------------- DUMP OF SYNTAX MARKS --------------------------------");
        int n = baseDocument.getLength();
        System.out.println("--------------------------------------------------------------------------------\n");
    }

    public static void test(JTextComponent jTextComponent) {
    }

    public static void checkSettings(Class clazz) throws Exception {
    }

    public static String debugString(String string) {
        return string != null ? EditorDebug.debugChars(string.toCharArray(), 0, string.length()) : "NULL STRING";
    }

    public static String debugChars(Segment segment) {
        return EditorDebug.debugChars(segment.array, segment.offset, segment.count);
    }

    public static String debugChars(char[] cArray) {
        return EditorDebug.debugChars(cArray, 0, cArray.length);
    }

    public static String debugChars(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            return "EditorDebug.debugChars() !ERROR! len=" + n2 + " < 0";
        }
        if (n < 0) {
            return "EditorDebug.debugChars() !ERROR! offset=" + n + " < 0";
        }
        if (n + n2 > cArray.length) {
            return "EditorDebug.debugChars() !ERROR! offset=" + n + " + len=" + n2 + " > chars.length=" + cArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        while (n < n3) {
            switch (cArray[n]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String debugChar(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
        }
        return String.valueOf(c);
    }

    public static String debugPairs(int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null pairs";
        } else if (nArray.length == 0) {
            string = "No pairs";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; i += 2) {
                stringBuffer.append('[');
                stringBuffer.append(nArray[i]);
                stringBuffer.append(", ");
                stringBuffer.append(nArray[i + 1]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append("]\n");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugArray(Object[] objectArray) {
        String string;
        if (objectArray == null) {
            string = "Null array";
        } else if (objectArray.length == 0) {
            string = "Empty array";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(i);
                stringBuffer.append("]=");
                stringBuffer.append(objectArray[i]);
                if (i == objectArray.length - 1) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugArray(int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null array";
        } else if (nArray.length == 0) {
            string = "Empty array";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(i);
                stringBuffer.append("]=");
                stringBuffer.append(nArray[i]);
                if (i == nArray.length - 1) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugBlocks(BaseDocument baseDocument, int[] nArray) {
        String string;
        if (nArray == null) {
            string = "Null blocks";
        } else if (nArray.length == 0) {
            string = "Empty blocks";
        } else if (nArray.length % 2 != 0) {
            string = "Blocks.length=" + nArray.length + " is not even!";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; i += 2) {
                stringBuffer.append('[');
                stringBuffer.append(i);
                stringBuffer.append("]=(");
                stringBuffer.append(nArray[i]);
                stringBuffer.append(", ");
                stringBuffer.append(nArray[i + 1]);
                stringBuffer.append(") or (");
                stringBuffer.append(Utilities.debugPosition(baseDocument, nArray[i]));
                stringBuffer.append(", ");
                stringBuffer.append(Utilities.debugPosition(baseDocument, nArray[i + 1]));
                stringBuffer.append(')');
                if (i == nArray.length - 1) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugList(List list) {
        String string;
        if (list == null) {
            string = "Null list";
        } else if (list.size() == 0) {
            string = "Empty list";
        } else {
            int n = list.size();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('[');
                stringBuffer.append(i);
                stringBuffer.append("]=");
                stringBuffer.append(list.get(i));
                if (i == n - 1) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String debugIterator(Iterator iterator) {
        String string;
        if (iterator == null) {
            string = "Null iterator";
        } else if (!iterator.hasNext()) {
            string = "Empty iterator";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (iterator.hasNext()) {
                stringBuffer.append('[');
                stringBuffer.append(n++);
                stringBuffer.append("]=");
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append('\n');
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

