/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakPropertyChangeSupport;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.modules.PatchedPublic;
import org.openide.util.WeakListeners;

public final class JumpList {
    private static final Logger LOG = Logger.getLogger(JumpList.class.getName());
    private static final WeakPropertyChangeSupport support = new WeakPropertyChangeSupport();
    private static PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            support.firePropertyChange(JumpList.class, null, null, null);
        }
    };

    static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        support.addPropertyChangeListener(propertyChangeListener);
    }

    public static void checkAddEntry() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null) {
            JumpList.addEntry(jTextComponent, jTextComponent.getCaret().getDot());
        }
    }

    public static void checkAddEntry(JTextComponent jTextComponent) {
        JumpList.addEntry(jTextComponent, jTextComponent.getCaret().getDot());
    }

    public static void checkAddEntry(JTextComponent jTextComponent, int n) {
        JumpList.addEntry(jTextComponent, n);
    }

    public static void addEntry(JTextComponent jTextComponent, int n) {
        try {
            NavigationHistory.getNavigations().markWaypoint(jTextComponent, n, false, false);
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Can't add position to the navigation history.", badLocationException);
        }
    }

    public static void jumpPrev(JTextComponent jTextComponent) {
        NavigationHistory.Waypoint waypoint = NavigationHistory.getNavigations().navigateBack();
        JumpList.show(waypoint);
    }

    public static void jumpPrevComponent(JTextComponent jTextComponent) {
        List<NavigationHistory.Waypoint> list = NavigationHistory.getNavigations().getPreviousWaypoints();
        for (NavigationHistory.Waypoint waypoint : list) {
            JTextComponent jTextComponent2 = waypoint.getComponent();
            if (jTextComponent2 == null || jTextComponent2 == jTextComponent) continue;
            JumpList.show(waypoint);
            return;
        }
    }

    public static boolean hasPrev() {
        return NavigationHistory.getNavigations().hasPreviousWaypoints();
    }

    public static void jumpNext(JTextComponent jTextComponent) {
        NavigationHistory.Waypoint waypoint = NavigationHistory.getNavigations().navigateForward();
        JumpList.show(waypoint);
    }

    public static void jumpNextComponent(JTextComponent jTextComponent) {
        List<NavigationHistory.Waypoint> list = NavigationHistory.getNavigations().getNextWaypoints();
        for (NavigationHistory.Waypoint waypoint : list) {
            JTextComponent jTextComponent2 = waypoint.getComponent();
            if (jTextComponent2 == null || jTextComponent2 == jTextComponent) continue;
            JumpList.show(waypoint);
            return;
        }
    }

    public static boolean hasNext() {
        return NavigationHistory.getNavigations().hasNextWaypoints();
    }

    public static String dump() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Previous waypoints: {\n");
        List<NavigationHistory.Waypoint> list = NavigationHistory.getNavigations().getPreviousWaypoints();
        for (NavigationHistory.Waypoint object22 : list) {
            object = object22.getUrl();
            stringBuilder.append("    ").append(((URL)object).toString()).append("\n");
        }
        stringBuilder.append("}\n");
        stringBuilder.append("Next waypoints: {\n");
        List<NavigationHistory.Waypoint> list2 = NavigationHistory.getNavigations().getNextWaypoints();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (NavigationHistory.Waypoint)iterator.next();
            URL uRL = ((NavigationHistory.Waypoint)object).getUrl();
            stringBuilder.append("    ").append(uRL.toString()).append("\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @PatchedPublic
    private JumpList() {
    }

    private static void show(NavigationHistory.Waypoint waypoint) {
        JTextComponent jTextComponent;
        JTextComponent jTextComponent2 = jTextComponent = waypoint == null ? null : waypoint.getComponent();
        if (jTextComponent != null) {
            int n;
            if (Utilities.getLastActiveComponent() != jTextComponent) {
                Utilities.requestFocus(jTextComponent);
                Registry.activate(jTextComponent);
            }
            if ((n = waypoint.getOffset()) >= 0 && n <= jTextComponent.getDocument().getLength()) {
                jTextComponent.getCaret().setDot(n);
            }
        }
    }

    static {
        NavigationHistory.getNavigations().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)NavigationHistory.getNavigations()));
    }

    public static final class Entry {
        private Entry(JTextComponent jTextComponent, int n, Entry entry) throws BadLocationException {
        }

        public int getPosition() {
            return -1;
        }

        public JTextComponent getComponent() {
            return null;
        }

        public boolean setDot() {
            return false;
        }
    }
}

