/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class StatusBar
implements PropertyChangeListener,
DocumentListener {
    public static final String CELL_MAIN = "main";
    public static final String CELL_POSITION = "position";
    public static final String CELL_TYPING_MODE = "typing-mode";
    public static final String INSERT_LOCALE = "status-bar-insert";
    public static final String OVERWRITE_LOCALE = "status-bar-overwrite";
    private static final String[] POS_MAX_STRINGS = new String[]{"99999 | 999"};
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    static final Border CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("control")), BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, UIManager.getDefaults().getColor("controlHighlight")), BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlDkShadow")))), BorderFactory.createEmptyBorder(0, 2, 0, 2));
    private static Map<String, JLabel> cellName2GlobalCell = new HashMap<String, JLabel>();
    protected EditorUI editorUI;
    private JPanel panel;
    private boolean visible;
    private List cellList = new ArrayList();
    private Caret caret;
    private CaretListener caretL;
    private int caretDelay;
    private boolean overwriteModeDisplayed;
    private String insText;
    private String ovrText;
    private String caretPositionLocaleString;
    private String insertModeLocaleString;
    private String overwriteModeLocaleString;
    private Preferences prefs = null;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.refreshPanel();
                }
            });
            if (preferenceChangeEvent == null || "status-bar-caret-delay".equals(preferenceChangeEvent.getKey())) {
                StatusBar.this.caretDelay = StatusBar.this.prefs.getInt("status-bar-caret-delay", 200);
                if (StatusBar.this.caretL != null) {
                    StatusBar.this.caretL.setDelay(StatusBar.this.caretDelay);
                }
            }
        }
    };
    private PreferenceChangeListener weakListener = null;
    static final long serialVersionUID = -6266183959929157349L;

    public static void setGlobalCell(String string, JLabel jLabel) {
        cellName2GlobalCell.put(string, jLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusBar(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.caretDelay = 10;
        this.caretL = new CaretListener(this.caretDelay);
        ResourceBundle resourceBundle = NbBundle.getBundle(BaseKit.class);
        this.insText = resourceBundle.getString(INSERT_LOCALE);
        this.ovrText = resourceBundle.getString(OVERWRITE_LOCALE);
        this.caretPositionLocaleString = resourceBundle.getString("status-bar-caret-position");
        this.insertModeLocaleString = resourceBundle.getString("status-bar-insert-mode");
        this.overwriteModeLocaleString = resourceBundle.getString("status-bar-overwrite-mode");
        Object object = editorUI.getComponentLock();
        synchronized (object) {
            JTextComponent jTextComponent = editorUI.getComponent();
            if (jTextComponent != null) {
                this.propertyChange(new PropertyChangeEvent(editorUI, "component", null, jTextComponent));
            }
            editorUI.addPropertyChangeListener(this);
        }
    }

    private void documentUndo(DocumentEvent documentEvent) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                StatusBar.this.setText(StatusBar.CELL_MAIN, "");
            }
        });
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
            this.documentUndo(documentEvent);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
            this.documentUndo(documentEvent);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    protected JPanel createPanel() {
        return new JPanel(new GridBagLayout());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            if (this.panel != null || this.visible) {
                if (this.visible) {
                    this.refreshPanel();
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    this.getPanel().setVisible(this.visible);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StatusBar.this.getPanel().setVisible(StatusBar.this.visible);
                        }
                    });
                }
            }
        }
    }

    public void updateGlobal() {
        for (Map.Entry<String, JLabel> entry : cellName2GlobalCell.entrySet()) {
            if (CELL_MAIN.equals(entry.getKey())) continue;
            String string = this.getText(entry.getKey());
            entry.getValue().setText(string);
        }
    }

    public final JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.initPanel();
        }
        return this.panel;
    }

    protected void initPanel() {
        JLabel jLabel = this.addCell(CELL_POSITION, POS_MAX_STRINGS);
        jLabel.setHorizontalAlignment(0);
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Action action;
                BaseKit baseKit;
                JTextComponent jTextComponent;
                if (mouseEvent.getClickCount() == 2 && (jTextComponent = StatusBar.this.editorUI.getComponent()) != null && (baseKit = Utilities.getKit(jTextComponent)) != null && (action = baseKit.getActionByName("goto")) != null) {
                    action.actionPerformed(new ActionEvent(jTextComponent, 0, null));
                }
            }
        });
        this.addCell(CELL_TYPING_MODE, new String[]{this.insText, this.ovrText}).setHorizontalAlignment(0);
        this.setText(CELL_TYPING_MODE, this.insText);
        this.addCell(CELL_MAIN, null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("component".equals(string)) {
            JTextComponent jTextComponent;
            if (this.prefs != null && this.weakListener != null) {
                this.prefs.removePreferenceChangeListener(this.weakListener);
            }
            if ((jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue()) != null) {
                Document document;
                jTextComponent.addPropertyChangeListener(this);
                this.caret = jTextComponent.getCaret();
                if (this.caret != null) {
                    this.caret.addChangeListener(this.caretL);
                }
                if ((document = jTextComponent.getDocument()) != null) {
                    document.addDocumentListener(this);
                }
                String string2 = DocumentUtilities.getMimeType((JTextComponent)jTextComponent);
                this.prefs = (Preferences)MimeLookup.getLookup((String)string2).lookup(Preferences.class);
                this.weakListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs);
                this.prefs.addPreferenceChangeListener(this.weakListener);
                this.prefsListener.preferenceChange(null);
                this.refreshPanel();
            } else {
                Document document;
                jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                jTextComponent.removePropertyChangeListener(this);
                this.caret = jTextComponent.getCaret();
                if (this.caret != null) {
                    this.caret.removeChangeListener(this.caretL);
                }
                if ((document = jTextComponent.getDocument()) != null) {
                    document.removeDocumentListener(this);
                }
            }
        } else if ("caret".equals(string)) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretL);
            }
            this.caret = (Caret)propertyChangeEvent.getNewValue();
            if (this.caret != null) {
                this.caret.addChangeListener(this.caretL);
            }
        } else if ("document".equals(string)) {
            Document document = (Document)propertyChangeEvent.getOldValue();
            Document document2 = (Document)propertyChangeEvent.getNewValue();
            if (document != null) {
                document.removeDocumentListener(this);
            }
            if (document2 != null) {
                document2.addDocumentListener(this);
            }
        }
        if ("overwriteMode".equals(string)) {
            this.caretL.actionPerformed(null);
        } else {
            this.caretL.stateChanged(null);
        }
    }

    private void applyColoring(Cell cell, Coloring coloring) {
        coloring.apply(cell);
        if (coloring.getForeColor() == null) {
            cell.setForeground(cell.getDefaultForeground());
        }
        if (coloring.getBackColor() == null) {
            cell.setBackground(cell.getDefaultBackground());
        }
    }

    public int getCellCount() {
        return this.cellList.size();
    }

    public JLabel addCell(String string, String[] stringArray) {
        return this.addCell(-1, string, stringArray);
    }

    public JLabel addCell(int n, String string, String[] stringArray) {
        Cell cell = new Cell(string, stringArray);
        this.addCellImpl(n, cell);
        return cell;
    }

    public void addCustomCell(int n, JLabel jLabel) {
        this.addCellImpl(n, jLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCellImpl(int n, JLabel jLabel) {
        List list = this.cellList;
        synchronized (list) {
            ArrayList<JLabel> arrayList = new ArrayList<JLabel>(this.cellList);
            int n2 = arrayList.size();
            if (n < 0 || n > n2) {
                n = n2;
            }
            arrayList.add(n, jLabel);
            this.cellList = arrayList;
            this.updateCellBorders(n);
        }
        this.refreshPanel();
    }

    private void updateCellBorders(int n) {
        int n2 = this.getCellCount();
        Border border = (Border)UIManager.get("Nb.Editor.Status.innerBorder");
        Border border2 = (Border)UIManager.get("Nb.Editor.Status.leftBorder");
        Border border3 = (Border)UIManager.get("Nb.Editor.Status.rightBorder");
        Border border4 = (Border)UIManager.get("Nb.Editor.Status.onlyOneBorder");
        if (border == null || border2 == null || border3 == null || border4 == null) {
            return;
        }
        if (n2 == 1) {
            ((JLabel)this.cellList.get(0)).setBorder(border4);
            return;
        }
        if (n == 0) {
            ((JLabel)this.cellList.get(0)).setBorder(border2);
            JLabel jLabel = (JLabel)this.cellList.get(1);
            jLabel.setBorder(n2 == 2 ? border3 : border);
        } else if (n == n2 - 1) {
            ((JLabel)this.cellList.get(n2 - 1)).setBorder(border3);
            JLabel jLabel = (JLabel)this.cellList.get(n2 - 2);
            jLabel.setBorder(n2 == 2 ? border2 : border);
        } else {
            ((JLabel)this.cellList.get(n)).setBorder(border);
        }
    }

    public JLabel getCellByName(String string) {
        for (JLabel jLabel : this.cellList) {
            if (!string.equals(jLabel.getName())) continue;
            return jLabel;
        }
        return null;
    }

    public String getText(String string) {
        JLabel jLabel = this.getCellByName(string);
        return jLabel != null ? jLabel.getText() : null;
    }

    public void setText(String string, String string2) {
        this.setText(string, string2, null);
    }

    private static Coloring getColoring(String string, String string2) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)string).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings == null ? null : fontColorSettings.getFontColors(string2);
        return attributeSet == null ? null : Coloring.fromAttributeSet(attributeSet);
    }

    public void setBoldText(String string, String string2) {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        this.setText(string, string2, jTextComponent != null ? StatusBar.getColoring(DocumentUtilities.getMimeType((JTextComponent)jTextComponent), "status-bar-bold") : null);
    }

    public void setText(String string, String string2, Coloring coloring) {
        this.setText(string, string2, coloring, 1);
    }

    public void setText(String string, String string2, Coloring coloring, int n) {
        JLabel jLabel = this.getCellByName(string);
        if (jLabel != null) {
            jLabel.setText(string2);
            if (this.visible) {
                Coloring coloring2;
                JTextComponent jTextComponent = this.editorUI.getComponent();
                Coloring coloring3 = coloring2 = jTextComponent != null ? StatusBar.getColoring(DocumentUtilities.getMimeType((JTextComponent)jTextComponent), "status-bar") : null;
                if (coloring2 != null && coloring != null) {
                    coloring2 = coloring.apply(coloring2);
                } else if (coloring2 == null) {
                    coloring2 = coloring;
                }
                if (CELL_POSITION.equals(string)) {
                    jLabel.setToolTipText(this.caretPositionLocaleString);
                } else if (CELL_TYPING_MODE.equals(string)) {
                    jLabel.setToolTipText(this.insText.equals(string2) ? this.insertModeLocaleString : this.overwriteModeLocaleString);
                } else {
                    jLabel.setToolTipText(string2 == null || string2.length() == 0 ? null : string2);
                }
                if (coloring2 != null && jLabel instanceof Cell) {
                    this.applyColoring((Cell)jLabel, coloring2);
                }
            } else {
                JLabel jLabel2 = cellName2GlobalCell.get(string);
                if (jLabel2 != null) {
                    if (CELL_MAIN.equals(string)) {
                        jLabel2.putClientProperty("importance", n);
                    }
                    jLabel2.setText(string2);
                }
            }
        }
    }

    public void setText(String string, int n) {
        JTextComponent jTextComponent = this.editorUI.getComponent();
        this.setText(CELL_MAIN, string, jTextComponent != null ? StatusBar.getColoring(DocumentUtilities.getMimeType((JTextComponent)jTextComponent), "status-bar-bold") : null, n);
    }

    private void refreshPanel() {
        if (this.isVisible()) {
            Serializable serializable2;
            for (Serializable serializable2 : this.cellList) {
                Coloring coloring;
                JComponent jComponent = this.editorUI.getComponent();
                if (!(serializable2 instanceof Cell) || jComponent == null || (coloring = StatusBar.getColoring(DocumentUtilities.getMimeType((JTextComponent)jComponent), "status-bar")) == null) continue;
                this.applyColoring((Cell)serializable2, coloring);
            }
            serializable2 = new GridBagConstraints();
            ((GridBagConstraints)serializable2).gridx = -1;
            ((GridBagConstraints)serializable2).gridwidth = 1;
            ((GridBagConstraints)serializable2).gridheight = 1;
            for (JComponent jComponent : this.cellList) {
                boolean bl = CELL_MAIN.equals(jComponent.getName());
                if (bl) {
                    ((GridBagConstraints)serializable2).fill = 2;
                    ((GridBagConstraints)serializable2).weightx = 1.0;
                }
                this.getPanel().add((Component)jComponent, serializable2);
                if (!bl) continue;
                ((GridBagConstraints)serializable2).fill = 0;
                ((GridBagConstraints)serializable2).weightx = 0.0;
            }
        }
    }

    public static final class StatusBarFactory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return Utilities.getEditorUI(jTextComponent).getStatusBar().getPanel();
        }
    }

    static class Cell
    extends JLabel {
        Dimension maxDimension;
        String[] widestStrings;
        private final Color defaultBackground;
        private final Color defaultForeground;
        static final long serialVersionUID = -2554600362177165648L;

        Cell(String string, String[] stringArray) {
            this.setName(string);
            this.setBorder(CELL_BORDER);
            this.setOpaque(true);
            this.widestStrings = stringArray;
            this.defaultBackground = this.getBackground();
            this.defaultForeground = this.getForeground();
            this.updateSize();
        }

        private void updateSize() {
            Font font = this.getFont();
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            if (font != null) {
                Border border = this.getBorder();
                Insets insets = border != null ? border.getBorderInsets(this) : NULL_INSETS;
                FontMetrics fontMetrics = this.getFontMetrics(font);
                String string = this.getText();
                int n = string == null ? 0 : fontMetrics.stringWidth(string);
                this.maxDimension.height = fontMetrics.getHeight() + insets.top + insets.bottom;
                if (this.widestStrings != null) {
                    for (int i = 0; i < this.widestStrings.length; ++i) {
                        String string2 = this.widestStrings[i];
                        if (string2 == null) continue;
                        n = Math.max(n, fontMetrics.stringWidth(string2));
                    }
                }
                this.maxDimension.width = n + insets.left + insets.right;
            }
        }

        public Dimension getPreferredSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public Dimension getMinimumSize() {
            if (this.maxDimension == null) {
                this.maxDimension = new Dimension();
            }
            return new Dimension(this.maxDimension);
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        public void setBorder(Border border) {
            super.setBorder(border);
            this.updateSize();
        }

        public Color getDefaultForeground() {
            Color color = (Color)UIManager.get("Label.foreground");
            return color != null ? color : this.defaultForeground;
        }

        public Color getDefaultBackground() {
            Color color = UIManager.getColor("NbEditorStatusBar.background");
            if (null == color) {
                color = (Color)UIManager.get("Label.background");
            }
            return color != null ? color : this.defaultBackground;
        }
    }

    class CaretListener
    implements ChangeListener,
    ActionListener {
        Timer timer;

        CaretListener(int n) {
            this.timer = new Timer(n, new WeakTimerListener(this));
            this.timer.setRepeats(false);
        }

        void setDelay(int n) {
            this.timer.setInitialDelay(n);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.timer.restart();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Caret caret = StatusBar.this.caret;
            JTextComponent jTextComponent = StatusBar.this.editorUI.getComponent();
            if (jTextComponent != null && jTextComponent == EditorRegistry.lastFocusedComponent()) {
                boolean bl;
                Serializable serializable;
                if (caret != null && (serializable = Utilities.getDocument(jTextComponent)) != null && ((BaseDocument)serializable).getDefaultRootElement().getElementCount() > 0) {
                    int bl2 = caret.getDot();
                    String string = Utilities.debugPosition((BaseDocument)serializable, bl2, " | ");
                    StatusBar.this.setText(StatusBar.CELL_POSITION, string);
                }
                boolean bl3 = bl = (serializable = (Boolean)StatusBar.this.editorUI.getProperty("overwriteMode")) != null && ((Boolean)serializable).booleanValue();
                if (bl != StatusBar.this.overwriteModeDisplayed) {
                    StatusBar.this.overwriteModeDisplayed = bl;
                    StatusBar.this.setText(StatusBar.CELL_TYPING_MODE, StatusBar.this.overwriteModeDisplayed ? StatusBar.this.ovrText : StatusBar.this.insText);
                }
            }
        }
    }
}

