/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.View;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.ViewInsets;
import org.netbeans.editor.view.spi.ViewLayoutState;
import org.netbeans.lib.editor.view.GapBoxView;
import org.netbeans.lib.editor.view.GapObjectArray;

class GapBoxViewChildren
extends GapObjectArray
implements GapObjectArray.RemoveUpdater {
    private static final int INITIAL_INDEX_GAP_LENGTH = 0x3FFFFFFF;
    private static final double INITIAL_MAJOR_AXIS_OFFSET_GAP_LENGTH = 0.0;
    protected final GapBoxView view;
    private double majorAxisOffsetGapLength;
    private int majorAxisOffsetGapIndex;
    private int indexGapLength;
    private int firstUpdateLayoutChildIndex;
    private int updateLayoutChildCount;
    private float minorAxisPreferredSpan;
    private int maxMinorAxisPreferredSpanChildIndex = -1;
    private int firstRepaintChildIndex = -1;

    GapBoxViewChildren(GapBoxView gapBoxView) {
        this.view = gapBoxView;
        this.indexGapLength = 0x3FFFFFFF;
        this.majorAxisOffsetGapLength = 0.0;
    }

    public int getChildCount() {
        return this.getItemCount();
    }

    public ViewLayoutState getChild(int n) {
        return (ViewLayoutState)this.getItem(n);
    }

    public int getChildIndex(ViewLayoutState viewLayoutState) {
        int n = this.getChildIndexNoCheck(viewLayoutState);
        if (n >= this.getChildCount() || this.getChild(n) != viewLayoutState) {
            n = -1;
        }
        return n;
    }

    public int getChildIndexNoCheck(ViewLayoutState viewLayoutState) {
        return this.getTranslatedChildIndex(viewLayoutState.getViewRawIndex());
    }

    private int getTranslatedChildIndex(int n) {
        if (n >= this.indexGapLength) {
            n -= this.indexGapLength;
        }
        return n;
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        int n4;
        this.checkConsistency();
        int n5 = n4 = viewArray != null ? viewArray.length : 0;
        if (this.isReplaceRemovingIndexes(n, n2)) {
            ViewLayoutState viewLayoutState;
            int n6;
            int n7;
            n3 = n + n2;
            if (n > 0) {
                n6 = n7 = n - 1;
                viewLayoutState = this.getChild(n7);
            } else if (n3 < this.getChildCount()) {
                n7 = n3;
                n6 = n + n4;
                viewLayoutState = this.getChild(n7);
            } else {
                n7 = -1;
                n6 = -1;
                viewLayoutState = null;
            }
            this.replaceUpdateIndexes(n, n2, n4, n7, n6, viewLayoutState);
        } else {
            this.replaceUpdateIndexes(n, n2, n4);
        }
        double d = 0.0;
        if (n2 == 0) {
            if (this.getChildCount() == 0) {
                this.ensureCapacity(n4);
            }
        } else {
            int n8 = n + n2;
            this.removeInvalidChildIndexesArea(n, n2);
            this.moveMajorAxisOffsetGap(n8);
            this.moveIndexGap(n8);
            d = this.getMajorAxisOffset(n);
            double d2 = this.getMajorAxisOffset(n8) - d;
            this.majorAxisOffsetGapIndex = n;
            this.majorAxisOffsetGapLength += d2;
            this.indexGapLength += n2;
            this.remove(n, n2, this);
        }
        if (n4 > 0) {
            boolean bl;
            boolean bl2;
            if (n2 == 0) {
                this.moveIndexGap(n);
                this.moveMajorAxisOffsetGap(n);
                d = this.getMajorAxisOffset(n) - this.majorAxisOffsetGapLength;
            }
            int n9 = this.view.getMajorAxis();
            n3 = this.view.isEstimatedSpan() ? 1 : 0;
            if (n3 != 0) {
                bl2 = true;
                bl = false;
            } else {
                bl2 = bl = n4 >= this.view.getReplaceEstimatedThreshold();
            }
            for (int i = 0; i < n4; ++i) {
                ViewLayoutState viewLayoutState = this.view.createChild(viewArray[i]);
                View view = viewLayoutState.getView();
                int n10 = n + i;
                if (bl2 && view instanceof EstimatedSpanView) {
                    ((EstimatedSpanView)((Object)view)).setEstimatedSpan(bl2);
                }
                viewLayoutState.selectLayoutMajorAxis(n9);
                this.insertItem(n10, viewLayoutState);
                --this.indexGapLength;
                ++this.majorAxisOffsetGapIndex;
                if (!viewLayoutState.isFlyweight()) {
                    viewLayoutState.setViewRawIndex(n10);
                    viewLayoutState.setLayoutMajorAxisRawOffset(d);
                    view.setParent(this.view);
                    viewLayoutState.viewPreferenceChanged(true, true);
                    this.moveMajorAxisOffsetGap(n10 + 1);
                    d = viewLayoutState.getLayoutMajorAxisRawOffset() + viewLayoutState.getLayoutMajorAxisPreferredSpan();
                    continue;
                }
                d += viewLayoutState.getLayoutMajorAxisPreferredSpan();
            }
            if (bl2 && n3 == 0) {
                this.view.resetEstimatedSpan(n, n4);
            }
        }
        this.view.markMajorAxisPreferenceChanged();
        this.markLayoutInvalid(n, n4);
        this.view.markRepaint(n, true);
        this.checkConsistency();
    }

    public void removeUpdate(Object object) {
        this.releaseChild((ViewLayoutState)object);
    }

    protected void releaseChild(ViewLayoutState viewLayoutState) {
        if (!viewLayoutState.isFlyweight()) {
            viewLayoutState.getView().setParent(null);
        }
    }

    protected boolean isReplaceRemovingIndexes(int n, int n2) {
        int n3 = this.getMaxMinorAxisPreferredSpanChildIndex();
        return !this.view.isChildrenLayoutNecessary() && n3 >= n && n3 < n + n2;
    }

    protected void replaceUpdateIndexes(int n, int n2, int n3) {
        if (!this.view.isChildrenLayoutNecessary()) {
            int n4 = n + n2;
            int n5 = this.getMaxMinorAxisPreferredSpanChildIndex();
            if (n5 >= n4) {
                this.setMaxMinorAxisPreferredSpanChildIndex(n5 + n3 - n2);
            }
        }
    }

    protected void replaceUpdateIndexes(int n, int n2, int n3, int n4, int n5, ViewLayoutState viewLayoutState) {
        if (!this.view.isChildrenLayoutNecessary()) {
            int n6 = n + n2;
            int n7 = this.getMaxMinorAxisPreferredSpanChildIndex();
            if (n7 >= n6) {
                this.setMaxMinorAxisPreferredSpanChildIndex(n7 + n3 - n2);
            } else if (n7 >= n) {
                if (viewLayoutState == null || viewLayoutState.getLayoutMinorAxisPreferredSpan() < this.view.getMinorAxisPreferredSpan()) {
                    this.view.markChildrenLayoutNecessary();
                }
                this.setMaxMinorAxisPreferredSpanChildIndex(n5);
            }
        }
    }

    public double getMajorAxisOffset(int n) {
        ViewLayoutState viewLayoutState;
        if (n < this.getChildCount() && !(viewLayoutState = this.getChild(n)).isFlyweight()) {
            double d = viewLayoutState.getLayoutMajorAxisRawOffset();
            if (n >= this.majorAxisOffsetGapIndex) {
                d -= this.majorAxisOffsetGapLength;
            }
            return d;
        }
        double d = 0.0;
        while (--n >= 0) {
            ViewLayoutState viewLayoutState2 = this.getChild(n);
            d += viewLayoutState2.getLayoutMajorAxisPreferredSpan();
            if (viewLayoutState2.isFlyweight()) continue;
            double d2 = viewLayoutState2.getLayoutMajorAxisRawOffset();
            if (n >= this.majorAxisOffsetGapIndex) {
                d2 -= this.majorAxisOffsetGapLength;
            }
            d += d2;
            break;
        }
        return d;
    }

    protected double getMajorAxisPreferredSpan() {
        return 0.0 - this.majorAxisOffsetGapLength;
    }

    protected final float getMinorAxisPreferredSpan() {
        return this.minorAxisPreferredSpan;
    }

    protected void setMinorAxisPreferredSpan(float f) {
        this.minorAxisPreferredSpan = f;
    }

    protected float getMinorAxisOffset(ViewLayoutState viewLayoutState) {
        float f = this.view.getMinorAxisAssignedSpan();
        float f2 = viewLayoutState.getLayoutMinorAxisPreferredSpan();
        if (f2 < f) {
            float f3 = viewLayoutState.getLayoutMinorAxisAlignment();
            return (f - f2) * f3;
        }
        return 0.0f;
    }

    protected float getMinorAxisSpan(ViewLayoutState viewLayoutState) {
        float f = this.view.getMinorAxisAssignedSpan();
        float f2 = viewLayoutState.getLayoutMinorAxisPreferredSpan();
        return f2 < f ? f2 : f;
    }

    protected void majorAxisPreferenceChanged(ViewLayoutState viewLayoutState, int n, double d) {
        this.moveMajorAxisOffsetGap(n + 1);
        this.majorAxisOffsetGapLength -= d;
        this.view.markMajorAxisPreferenceChanged();
    }

    protected void minorAxisPreferenceChanged(ViewLayoutState viewLayoutState, int n) {
        if (!this.view.isChildrenLayoutNecessary()) {
            float f = viewLayoutState.getLayoutMinorAxisPreferredSpan();
            float f2 = this.getMinorAxisPreferredSpan();
            int n2 = this.getMaxMinorAxisPreferredSpanChildIndex();
            if (n2 == -1 || f > f2) {
                this.setMinorAxisPreferredSpan(f);
                this.view.markMinorAxisPreferenceChanged();
                this.setMaxMinorAxisPreferredSpanChildIndex(n);
            } else if (n == n2 && f < f2) {
                this.view.markChildrenLayoutNecessary();
            }
        }
    }

    public int getChildStartOffset(int n) {
        ViewLayoutState viewLayoutState = this.getChild(n);
        if (!viewLayoutState.isFlyweight()) {
            return viewLayoutState.getView().getStartOffset();
        }
        int n2 = 0;
        while (--n >= 0) {
            viewLayoutState = this.getChild(n);
            n2 += viewLayoutState.getView().getEndOffset();
            if (viewLayoutState.isFlyweight()) continue;
            break;
        }
        return n2;
    }

    public int getChildEndOffset(int n) {
        int n2 = 0;
        while (n >= 0) {
            ViewLayoutState viewLayoutState = this.getChild(n--);
            n2 += viewLayoutState.getView().getEndOffset();
            if (viewLayoutState.isFlyweight()) continue;
            break;
        }
        return n2;
    }

    public Rectangle getChildCoreAllocation(int n, Rectangle rectangle) {
        this.childrenUpdateLayout(n);
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        ViewLayoutState viewLayoutState = this.getChild(n);
        int n2 = (int)this.getMajorAxisOffset(n);
        int n3 = (int)this.getMinorAxisOffset(viewLayoutState);
        int n4 = (int)viewLayoutState.getLayoutMajorAxisPreferredSpan();
        int n5 = (int)this.getMinorAxisSpan(viewLayoutState);
        if (this.view.isXMajorAxis()) {
            rectangle.x = n2;
            rectangle.y = n3;
            rectangle.width = n4;
            rectangle.height = n5;
        } else {
            rectangle.x = n3;
            rectangle.y = n2;
            rectangle.width = n5;
            rectangle.height = n4;
        }
        ViewInsets viewInsets = this.view.getInsets();
        if (viewInsets != null) {
            rectangle.x += (int)viewInsets.getLeft();
            rectangle.y += (int)viewInsets.getTop();
        }
        return rectangle;
    }

    public int getChildIndexAtCorePoint(float f, float f2) {
        int n;
        int n2 = this.getChildCount();
        int n3 = 0;
        int n4 = n2 - 1;
        if (n4 == -1) {
            return -1;
        }
        double d = this.view.isXMajorAxis() ? (double)f : (double)f2;
        int n5 = this.getUpdateLayoutChildCount();
        if (n5 > 0) {
            n = this.getFirstUpdateLayoutChildIndex();
            if (this.getMajorAxisOffset(n) <= d) {
                this.childrenUpdateLayout(n4);
                n3 = n;
            } else {
                n4 = n - 1;
            }
        }
        while (n3 <= n4) {
            n = (n3 + n4) / 2;
            ViewLayoutState viewLayoutState = this.getChild(n);
            double d2 = this.getMajorAxisOffset(n);
            if (d2 < d) {
                n3 = n + 1;
                continue;
            }
            if (d2 > d) {
                n4 = n - 1;
                continue;
            }
            return n;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return n4;
    }

    protected void paintChildren(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        if ((rectangle = graphics.getClipBounds(rectangle)) == null) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        boolean bl = this.view.isXMajorAxis();
        int n5 = bl ? n3 + rectangle.width : n4 + rectangle.height;
        int n6 = this.getChildIndexAtCorePoint(n3, n4);
        int n7 = this.getChildCount();
        for (int i = Math.max(n6, 0); i < n7; ++i) {
            int n8;
            ViewLayoutState viewLayoutState = this.getChild(i);
            rectangle = this.getChildCoreAllocation(i, rectangle);
            rectangle.x += n;
            rectangle.y += n2;
            int n9 = n8 = bl ? rectangle.x : rectangle.y;
            if (n8 >= n5) break;
            View view = viewLayoutState.getView();
            view.paint(graphics, rectangle);
        }
    }

    protected final int getFirstRepaintChildIndex() {
        return this.firstRepaintChildIndex;
    }

    final void setFirstRepaintChildIndex(int n) {
        this.firstRepaintChildIndex = n;
    }

    final int getMaxMinorAxisPreferredSpanChildIndex() {
        return this.maxMinorAxisPreferredSpanChildIndex;
    }

    void setMaxMinorAxisPreferredSpanChildIndex(int n) {
        this.maxMinorAxisPreferredSpanChildIndex = n;
    }

    final int getFirstUpdateLayoutChildIndex() {
        return this.firstUpdateLayoutChildIndex;
    }

    final int getUpdateLayoutChildCount() {
        return this.updateLayoutChildCount;
    }

    void markLayoutInvalid(int n, int n2) {
        if (n2 > 0) {
            if (this.updateLayoutChildCount > 0) {
                int n3 = this.firstUpdateLayoutChildIndex + this.updateLayoutChildCount;
                this.firstUpdateLayoutChildIndex = Math.min(this.firstUpdateLayoutChildIndex, n);
                this.updateLayoutChildCount = Math.max(n3, n + n2) - this.firstUpdateLayoutChildIndex;
            } else {
                this.firstUpdateLayoutChildIndex = n;
                this.updateLayoutChildCount = n2;
                this.view.markLayoutInvalid();
            }
        }
    }

    void removeInvalidChildIndexesArea(int n, int n2) {
        int n3;
        int n4 = n + n2;
        if (this.updateLayoutChildCount > 0 && (n3 = this.firstUpdateLayoutChildIndex + this.updateLayoutChildCount) > n) {
            if (this.firstUpdateLayoutChildIndex >= n4) {
                this.firstUpdateLayoutChildIndex -= n2;
            } else if (this.firstUpdateLayoutChildIndex < n) {
                this.updateLayoutChildCount -= Math.min(n3, n4) - n;
            } else {
                this.updateLayoutChildCount -= Math.min(n3, n4) - this.firstUpdateLayoutChildIndex;
                this.firstUpdateLayoutChildIndex = n4;
                while (this.updateLayoutChildCount > 0 && this.getChild(this.firstUpdateLayoutChildIndex).isFlyweight()) {
                    ++this.firstUpdateLayoutChildIndex;
                    --this.updateLayoutChildCount;
                }
            }
        }
    }

    protected final void childrenUpdateLayout(int n) {
        while (this.updateLayoutChildCount > 0 && this.firstUpdateLayoutChildIndex <= n) {
            --this.updateLayoutChildCount;
            ViewLayoutState viewLayoutState = this.getChild(this.firstUpdateLayoutChildIndex++);
            viewLayoutState.updateLayout();
        }
    }

    protected final void childrenUpdateLayout() {
        this.childrenUpdateLayout(Integer.MAX_VALUE);
    }

    protected void childrenLayout() {
        int n = this.getChildCount();
        int n2 = -1;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            ViewLayoutState viewLayoutState = this.getChild(i);
            float f2 = viewLayoutState.getLayoutMinorAxisPreferredSpan();
            if (!(f2 > f)) continue;
            n2 = i;
            f = f2;
        }
        this.setMaxMinorAxisPreferredSpanChildIndex(n2);
        if (f != this.getMinorAxisPreferredSpan()) {
            this.setMinorAxisPreferredSpan(f);
            this.view.markMinorAxisPreferenceChanged();
        }
    }

    protected void unload() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.releaseChild(this.getChild(i));
        }
    }

    private void moveIndexGap(int n) {
        this.checkConsistency();
        int n2 = this.indexGapLength;
        int n3 = n;
        boolean bl = false;
        while (--n3 >= 0) {
            ViewLayoutState viewLayoutState = this.getChild(n3);
            if (viewLayoutState.isFlyweight()) continue;
            int n4 = viewLayoutState.getViewRawIndex();
            if (n4 < n2) break;
            viewLayoutState.setViewRawIndex(n4 - n2);
            bl = true;
        }
        if (!bl) {
            int n5 = this.getChildCount();
            while (n < n5) {
                ViewLayoutState viewLayoutState;
                if ((viewLayoutState = this.getChild(n++)).isFlyweight()) continue;
                int n6 = viewLayoutState.getViewRawIndex();
                if (n6 >= n2) break;
                viewLayoutState.setViewRawIndex(n6 + n2);
            }
        }
        this.checkConsistency();
    }

    private void moveMajorAxisOffsetGap(int n) {
        if (n == this.majorAxisOffsetGapIndex) {
            return;
        }
        this.checkConsistency();
        if (n < this.majorAxisOffsetGapIndex) {
            while (--this.majorAxisOffsetGapIndex >= n) {
                ViewLayoutState viewLayoutState = this.getChild(this.majorAxisOffsetGapIndex);
                if (viewLayoutState.isFlyweight()) continue;
                viewLayoutState.setLayoutMajorAxisRawOffset(viewLayoutState.getLayoutMajorAxisRawOffset() + this.majorAxisOffsetGapLength);
            }
            ++this.majorAxisOffsetGapIndex;
        } else {
            while (this.majorAxisOffsetGapIndex < n) {
                ViewLayoutState viewLayoutState = this.getChild(this.majorAxisOffsetGapIndex);
                if (!viewLayoutState.isFlyweight()) {
                    viewLayoutState.setLayoutMajorAxisRawOffset(viewLayoutState.getLayoutMajorAxisRawOffset() - this.majorAxisOffsetGapLength);
                }
                ++this.majorAxisOffsetGapIndex;
            }
        }
        this.checkConsistency();
    }

    private void checkConsistency() {
    }

    private int computeIndexGapStart() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (this.getChild(i).getViewRawIndex() < this.indexGapLength) continue;
            return i;
        }
        return n;
    }

    public String toStringDetail() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.view.toString());
        stringBuffer.append(", indexGapStart=");
        stringBuffer.append(this.computeIndexGapStart());
        stringBuffer.append(", majorAxisOffsetGapIndex=");
        stringBuffer.append(this.majorAxisOffsetGapIndex);
        stringBuffer.append(", majorAxisOffsetGapLength=");
        stringBuffer.append(this.majorAxisOffsetGapLength);
        stringBuffer.append(this.view.childrenToString());
        return stringBuffer.toString();
    }
}

