/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeComment;
import org.netbeans.tax.TreeException;

public class TreeCommentCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -2298790138555257739L;
    private JTextArea dataTextArea;
    private JPanel dataPanel;
    private JScrollPane dataScroll;

    public TreeCommentCustomizer() {
        this.initComponents();
        this.initAccessibility();
    }

    protected final TreeComment getComment() {
        return (TreeComment)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.safePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equals("data")) {
            this.updateDataComponent();
        }
    }

    protected final void updateCommentData() {
        try {
            this.getComment().setData(this.dataTextArea.getText());
        }
        catch (TreeException treeException) {
            this.updateDataComponent();
            TAXUtil.notifyTreeException(treeException);
        }
    }

    protected final void updateDataComponent() {
        this.dataTextArea.setText(this.getComment().getData());
    }

    protected final void initComponentValues() {
        this.updateDataComponent();
    }

    protected final void updateReadOnlyStatus(boolean bl) {
        this.dataTextArea.setEditable(bl);
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.dataScroll = new JScrollPane();
        this.dataTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.dataPanel.setLayout(new BorderLayout());
        this.dataTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TreeCommentCustomizer.this.dataTextAreaFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                TreeCommentCustomizer.this.dataTextAreaFocusLost(focusEvent);
            }
        });
        this.dataTextArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TreeCommentCustomizer.this.dataTextAreaKeyPressed(keyEvent);
            }
        });
        this.dataScroll.setViewportView(this.dataTextArea);
        this.dataPanel.add((Component)this.dataScroll, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    private void dataTextAreaFocusGained(FocusEvent focusEvent) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.dataTextArea.selectAll();
        }
    }

    private void dataTextAreaKeyPressed(KeyEvent keyEvent) {
        if (TreeCommentCustomizer.applyKeyPressed(keyEvent)) {
            this.updateCommentData();
        }
    }

    private void dataTextAreaFocusLost(FocusEvent focusEvent) {
        this.updateCommentData();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeCommentCustomizer"));
        this.dataTextArea.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_dataPanel"));
        this.dataTextArea.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_dataPanel"));
    }
}

