/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

class GraphConstructor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private Map<String, ArtifactGraphNode> cache;
    private List<ArtifactGraphEdge> edges;

    GraphConstructor(DependencyGraphScene dependencyGraphScene) {
        this.scene = dependencyGraphScene;
        this.path = new Stack();
        this.cache = new HashMap<String, ArtifactGraphNode>();
        this.edges = new ArrayList<ArtifactGraphEdge>();
    }

    public boolean visit(DependencyNode dependencyNode) {
        Artifact artifact;
        if (this.root == null) {
            this.root = dependencyNode;
        }
        boolean bl = false;
        ArtifactGraphNode artifactGraphNode = this.cache.get(dependencyNode.getArtifact().getDependencyConflictId());
        if (dependencyNode.getState() == 0) {
            if (artifactGraphNode == null) {
                artifactGraphNode = new ArtifactGraphNode(dependencyNode);
                this.cache.put(dependencyNode.getArtifact().getDependencyConflictId(), artifactGraphNode);
            } else {
                artifactGraphNode.setArtifact(dependencyNode);
            }
            artifactGraphNode.setPrimaryLevel(this.path.size());
            bl = true;
        } else {
            if (artifactGraphNode == null) {
                artifactGraphNode = new ArtifactGraphNode(null);
                artifact = dependencyNode.getState() == 2 ? dependencyNode.getRelatedArtifact() : dependencyNode.getArtifact();
                this.cache.put(artifact.getDependencyConflictId(), artifactGraphNode);
            }
            artifactGraphNode.addDuplicateOrConflict(dependencyNode);
        }
        if (!this.path.empty()) {
            artifact = this.path.peek();
            ArtifactGraphEdge artifactGraphEdge = new ArtifactGraphEdge((DependencyNode)artifact, dependencyNode);
            artifactGraphEdge.setLevel(this.path.size() - 1);
            artifactGraphEdge.setPrimaryPath(bl);
            this.edges.add(artifactGraphEdge);
        }
        if (dependencyNode != this.root && artifactGraphNode.getArtifact() != null) {
            artifactGraphNode.setManagedState(GraphConstructor.obtainManagedState(artifactGraphNode.getArtifact().getArtifact(), this.scene));
        }
        this.path.push(dependencyNode);
        return true;
    }

    public boolean endVisit(DependencyNode dependencyNode) {
        this.path.pop();
        if (this.root == dependencyNode) {
            ArtifactGraphNode artifactGraphNode = this.cache.get(dependencyNode.getArtifact().getDependencyConflictId());
            this.scene.addNode(artifactGraphNode);
            for (ArtifactGraphNode object : this.cache.values()) {
                if (object == artifactGraphNode) continue;
                this.scene.addNode(object);
            }
            for (ArtifactGraphEdge artifactGraphEdge : this.edges) {
                this.scene.addEdge(artifactGraphEdge);
                ArtifactGraphNode artifactGraphNode2 = this.cache.get(artifactGraphEdge.getTarget().getArtifact().getDependencyConflictId());
                if (artifactGraphNode2 == null) {
                    artifactGraphNode2 = this.cache.get(artifactGraphEdge.getTarget().getRelatedArtifact().getDependencyConflictId());
                }
                this.scene.setEdgeTarget(artifactGraphEdge, artifactGraphNode2);
                ArtifactGraphNode artifactGraphNode3 = this.cache.get(artifactGraphEdge.getSource().getArtifact().getDependencyConflictId());
                this.scene.setEdgeSource(artifactGraphEdge, artifactGraphNode3);
            }
        }
        return true;
    }

    private static int obtainManagedState(Artifact artifact, DependencyGraphScene dependencyGraphScene) {
        MavenProject mavenProject = dependencyGraphScene.getMavenProject();
        if (mavenProject == null) {
            return 0;
        }
        DependencyManagement dependencyManagement = mavenProject.getDependencyManagement();
        if (dependencyManagement == null) {
            return 0;
        }
        List list = dependencyManagement.getDependencies();
        if (list == null) {
            return 0;
        }
        String string = artifact.getArtifactId();
        String string2 = artifact.getGroupId();
        String string3 = artifact.getVersion();
        for (Dependency dependency : list) {
            if (!string.equals(dependency.getArtifactId()) || !string2.equals(dependency.getGroupId())) continue;
            if (!string3.equals(dependency.getVersion())) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

