/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphEdge;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.netbeans.modules.maven.graph.EdgeWidget;

class HighlightVisitor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private int max = Integer.MAX_VALUE;
    Rectangle rectangle = new Rectangle(0, 0, 1, 1);

    HighlightVisitor(DependencyGraphScene dependencyGraphScene) {
        this.scene = dependencyGraphScene;
        this.path = new Stack();
    }

    void setMaxDepth(int n) {
        this.max = n;
    }

    Rectangle getVisibleRectangle() {
        return this.rectangle;
    }

    public boolean visit(DependencyNode dependencyNode) {
        if (this.root == null) {
            this.root = dependencyNode;
        }
        if (dependencyNode.getState() == 0) {
            ArtifactGraphNode artifactGraphNode = this.scene.getGraphNodeRepresentant(dependencyNode);
            ArtifactWidget artifactWidget = (ArtifactWidget)this.scene.findWidget(artifactGraphNode);
            Collection collection = this.scene.findNodeEdges(artifactGraphNode, true, true);
            artifactWidget.setReadable(false);
            if (this.path.size() > this.max) {
                artifactWidget.setPaintState(1);
                for (ArtifactGraphEdge artifactGraphEdge : collection) {
                    EdgeWidget edgeWidget = (EdgeWidget)this.scene.findWidget(artifactGraphEdge);
                    edgeWidget.setState(1);
                }
            } else {
                this.rectangle = this.rectangle.union(artifactWidget.convertLocalToScene(artifactWidget.getBounds()));
                artifactWidget.setPaintState(2);
                for (ArtifactGraphEdge artifactGraphEdge : collection) {
                    EdgeWidget edgeWidget = (EdgeWidget)this.scene.findWidget(artifactGraphEdge);
                    edgeWidget.setState(2);
                }
            }
            this.path.push(dependencyNode);
            return true;
        }
        return false;
    }

    public boolean endVisit(DependencyNode dependencyNode) {
        if (dependencyNode.getState() == 0) {
            this.path.pop();
        }
        return true;
    }
}

