/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.net.URL;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.DocumentationQuery;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.util.NbBundle;

public abstract class DocumentationItem
implements CompletionDocumentation {
    private CompletionResultItem completionItem;

    public DocumentationItem(CompletionResultItem completionResultItem) {
        this.completionItem = completionResultItem;
    }

    public static DocumentationItem createDocumentationItem(CompletionResultItem completionResultItem) {
        if (completionResultItem.getAXIComponent() instanceof AbstractElement) {
            return new ElementDocItem(completionResultItem);
        }
        if (completionResultItem.getAXIComponent() instanceof AbstractAttribute) {
            return new AttributeDocItem(completionResultItem);
        }
        return null;
    }

    public abstract String getText();

    public final CompletionResultItem getCompletionItem() {
        return this.completionItem;
    }

    public URL getURL() {
        return null;
    }

    public CompletionDocumentation resolveLink(String string) {
        return null;
    }

    public Action getGotoSourceAction() {
        return null;
    }

    static class AttributeDocItem
    extends DocumentationItem {
        public AttributeDocItem(CompletionResultItem completionResultItem) {
            super(completionResultItem);
        }

        public String getText() {
            AXIType aXIType;
            AXIComponent aXIComponent = this.getCompletionItem().getAXIComponent();
            if (!(aXIComponent instanceof AbstractAttribute)) {
                return null;
            }
            AbstractAttribute abstractAttribute = (AbstractAttribute)aXIComponent;
            Object[] objectArray = new String[]{"", "", "", ""};
            objectArray[0] = abstractAttribute.getTargetNamespace();
            if (objectArray[0] == null) {
                objectArray[0] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-No-TNS");
            }
            objectArray[1] = abstractAttribute.getName();
            objectArray[2] = abstractAttribute.getDocumentation();
            if (objectArray[2] == null) {
                objectArray[2] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Attribute-No-Description");
            }
            if (abstractAttribute instanceof Attribute && (aXIType = ((Attribute)abstractAttribute).getType()) instanceof Datatype) {
                objectArray[3] = ((Datatype)aXIType).getKind().getName();
            }
            return NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Attribute", (Object[])objectArray);
        }
    }

    static class ElementDocItem
    extends DocumentationItem {
        public ElementDocItem(CompletionResultItem completionResultItem) {
            super(completionResultItem);
        }

        public String getText() {
            AXIComponent aXIComponent = this.getCompletionItem().getAXIComponent();
            if (!(aXIComponent instanceof AbstractElement)) {
                return null;
            }
            AbstractElement abstractElement = (AbstractElement)aXIComponent;
            Object[] objectArray = new String[]{"", "", "", "", ""};
            objectArray[0] = abstractElement.getTargetNamespace();
            if (objectArray[0] == null) {
                objectArray[0] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-No-TNS");
            }
            objectArray[1] = abstractElement.getName();
            objectArray[2] = abstractElement.getDocumentation();
            if (objectArray[2] == null) {
                objectArray[2] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Element-No-Description");
            }
            objectArray[3] = this.formChildElementsHTML(abstractElement);
            if (objectArray[3] == null) {
                objectArray[3] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Element-No-Child-Elements");
            }
            objectArray[4] = this.formAttributesHTML(abstractElement);
            if (objectArray[4] == null) {
                objectArray[4] = NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Element-No-Attributes");
            }
            return NbBundle.getMessage(DocumentationQuery.class, (String)"Documentation-Text-Element", (Object[])objectArray);
        }

        private String formChildElementsHTML(AbstractElement abstractElement) {
            List list = abstractElement.getChildElements();
            if (list == null || list.size() == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (AbstractElement abstractElement2 : list) {
                String string = abstractElement2.getMinOccurs();
                if (string != null && string.equals("1")) {
                    stringBuffer.append("<b>" + abstractElement2.getName() + "</b>");
                } else {
                    stringBuffer.append(abstractElement2.getName());
                }
                stringBuffer.append(" ");
                if (abstractElement2.supportsCardinality()) {
                    stringBuffer.append("[" + abstractElement2.getMinOccurs() + ".." + abstractElement2.getMaxOccurs() + "]");
                }
                if (abstractElement2 instanceof AnyElement) {
                    stringBuffer.append(" ");
                    stringBuffer.append("{" + abstractElement2.getTargetNamespace() + "}");
                }
                stringBuffer.append("<br>");
            }
            return stringBuffer.toString();
        }

        private String formAttributesHTML(AbstractElement abstractElement) {
            List list = abstractElement.getAttributes();
            if (list == null || list.size() == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (AbstractAttribute abstractAttribute : list) {
                if (abstractAttribute instanceof Attribute) {
                    Attribute.Use use = ((Attribute)abstractAttribute).getUse();
                    if (use != null && use == Attribute.Use.REQUIRED) {
                        stringBuffer.append("<b>" + abstractAttribute.getName() + "</b>");
                    } else {
                        stringBuffer.append(abstractAttribute.getName());
                    }
                } else {
                    stringBuffer.append(abstractAttribute.getName());
                }
                if (abstractAttribute instanceof AnyAttribute) {
                    stringBuffer.append(" ");
                    stringBuffer.append("{" + abstractAttribute.getTargetNamespace() + "}");
                }
                stringBuffer.append("<br>");
            }
            return stringBuffer.toString();
        }
    }
}

