/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;

public class CndUtils {
    private static Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;

    private CndUtils() {
    }

    public static boolean isStandalone() {
        return !CndUtils.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !CndUtils.isReleaseMode();
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static void threadsDump() {
        System.err.println("-----Start Thread Dump-----");
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            System.err.println(entry.getKey().getName());
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                System.err.println("\tat " + stackTraceElement.toString());
            }
            System.err.println();
        }
        System.err.println("-----End Thread Dump-----");
    }

    public static void assertTrue(boolean bl) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(bl, "Assertion error");
        }
    }

    public static void assertNotNull(Object object, String string) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(object != null, string);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int n = Integer.getInteger("cnd.modelimpl.parser.threads", Runtime.getRuntime().availableProcessors());
        return Math.max(n, 1);
    }

    public static int getConcurrencyLevel() {
        return CndUtils.getNumberCndWorkerThreads();
    }

    public static void assertFalse(boolean bl) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(!bl, "Assertion error");
        }
    }

    public static void assertFalse(boolean bl, String string) {
        CndUtils.assertTrue(!bl, string);
    }

    public static void assertTrue(boolean bl, String string) {
        if (CndUtils.isDebugMode() && !bl) {
            LOG.log(Level.SEVERE, string, new Exception(string));
        }
    }

    public static void assertTrueInConsole(boolean bl, String string) {
        if (CndUtils.isDebugMode() && !bl) {
            LOG.log(Level.INFO, string, new Exception(string));
        }
    }

    public static final void assertNonUiThread() {
        CndUtils.assertFalse(SwingUtilities.isEventDispatchThread(), "Should not be called from UI thread");
    }

    public static void assertNormalized(File file) {
        File file2;
        if (CndUtils.isDebugMode() && !file.equals(file2 = CndFileUtils.normalizeFile(file))) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + file + " instead of " + file2);
        }
    }

    static {
        String string = System.getProperty("cnd.release.mode");
        if (string == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(string);
        }
    }
}

