/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.spi.utils.FileSystemsProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CndFileUtils {
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static final FileChangeListener FSL;
    private static final Lock maRefLock;
    private static final Lock mapNormalizedRefLock;
    private static Reference<ConcurrentMap<String, Flags>> mapRef;
    private static Reference<Map<String, String>> normalizedRef;
    private static final boolean TRACE_EXTERNAL_CHANGES;

    private CndFileUtils() {
    }

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static void clearFileExistenceCache() {
        mapRef.clear();
    }

    public static File normalizeFile(File file) {
        String string;
        String string2;
        if (CndUtils.isDebugMode() && !file.isAbsolute()) {
            CndUtils.assertTrueInConsole(false, "Is it OK to normalize not absolute file? [" + file + "] during this session it is [" + file.getAbsolutePath() + "] but will be different if start IDE from another folder");
        }
        return (string2 = file.getPath()).equals(string = CndFileUtils.normalizeAbsolutePath(file.getAbsolutePath())) ? file : new File(string);
    }

    public static String normalizeAbsolutePath(String string) {
        Map<String, String> map;
        String string2;
        if (CndUtils.isDebugMode() && !new File(string).isAbsolute()) {
            CndUtils.assertTrueInConsole(false, "path for normalization must be absolute " + string);
        }
        if ((string2 = (map = CndFileUtils.getNormalizedFilesMap()).get(string)) == null) {
            boolean bl = CndFileUtils.isSystemCaseSensitive();
            if (!bl) {
                string = FileSystemsProvider.getCaseInsensitivePath(string);
            }
            string2 = !bl || string.endsWith("/.") || string.endsWith("\\.") || string.contains("..") || string.contains("./") || string.contains(".\\") ? FileUtil.normalizeFile((File)new File(string)).getAbsolutePath() : string;
            map.put(string, string2);
        }
        return string2;
    }

    public static boolean exists(File file) {
        return CndFileUtils.getFlags(file, null, true).exist;
    }

    public static boolean isExistingFile(File file) {
        return CndFileUtils.isExistingFile(file, null);
    }

    public static boolean isExistingFile(String string) {
        return CndFileUtils.isExistingFile(null, string);
    }

    public static boolean isExistingFile(File file, String string) {
        Flags flags = CndFileUtils.getFlags(file, string, true);
        return flags.exist && !flags.directory;
    }

    public static boolean isExistingDirectory(File file) {
        return CndFileUtils.isExistingDirectory(file, null);
    }

    public static boolean isExistingDirectory(String string) {
        return CndFileUtils.isExistingDirectory(null, string);
    }

    public static boolean isExistingDirectory(File file, String string) {
        return CndFileUtils.getFlags(file, string, false).directory;
    }

    public static InputStream getInputStream(CharSequence charSequence) throws IOException {
        FileSystemsProvider.Data data = FileSystemsProvider.get(charSequence);
        if (data == null) {
            File file = new File(((Object)charSequence).toString());
            FileObject fileObject = FileUtil.toFileObject((File)file);
            InputStream inputStream = fileObject != null ? fileObject.getInputStream() : new FileInputStream(file);
            return inputStream;
        }
        FileObject fileObject = data.fileSystem.getRoot().getFileObject(data.path);
        if (fileObject == null) {
            throw new FileNotFoundException(((Object)charSequence).toString());
        }
        return fileObject.getInputStream();
    }

    private static Flags getFlags(File file, String string, boolean bl) {
        assert (file != null || string != null);
        string = string == null ? file.getAbsolutePath() : string;
        ConcurrentMap<String, Flags> concurrentMap = CndFileUtils.getFilesMap();
        Flags flags = (Flags)concurrentMap.get(string);
        if (flags == null) {
            String string2 = (file = file == null ? new File(string) : file).getParent();
            if (string2 != null) {
                Flags flags2 = (Flags)concurrentMap.get(string2);
                if (flags2 == null || flags2 == Flags.DIRECTORY) {
                    File file2 = file.getParentFile();
                    if (flags2 == null) {
                        flags2 = Flags.get(file2);
                        concurrentMap.put(string2, flags2);
                    }
                    if (flags2 == Flags.NOT_FOUND || flags2 == Flags.FILE) {
                        flags = Flags.NOT_FOUND;
                    } else if (bl) {
                        assert (flags2 == Flags.DIRECTORY) : "must be DIRECTORY but was " + flags2;
                        CndFileUtils.index(file2, string2, concurrentMap);
                        flags = (Flags)concurrentMap.get(string);
                    }
                } else {
                    flags = Flags.NOT_FOUND;
                }
            }
            if (flags == null) {
                flags = Flags.get(file);
                concurrentMap.put(string, flags);
            }
            if (flags == Flags.DIRECTORY) {
                CndFileUtils.index(file, string, concurrentMap);
            }
        }
        return flags;
    }

    private static void index(File file, String string, ConcurrentMap<String, Flags> concurrentMap) {
        if (file.canRead()) {
            File[] fileArray = CndFileUtils.listFilesImpl(file);
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string2 = file2.getAbsolutePath();
                if (file2.isDirectory()) {
                    concurrentMap.putIfAbsent(string2, Flags.DIRECTORY);
                    continue;
                }
                concurrentMap.put(string2, Flags.FILE);
            }
        }
        concurrentMap.put(string, Flags.INDEXED_DIRECTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, Flags> getFilesMap() {
        ConcurrentMap<String, Flags> concurrentMap = mapRef.get();
        if (concurrentMap == null) {
            try {
                maRefLock.lock();
                concurrentMap = mapRef.get();
                if (concurrentMap == null) {
                    concurrentMap = new ConcurrentHashMap<String, Flags>();
                    mapRef = new SoftReference<ConcurrentMap<String, Flags>>(concurrentMap);
                }
            }
            finally {
                maRefLock.unlock();
            }
        }
        return concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNormalizedFilesMap() {
        Map<String, String> map = normalizedRef.get();
        if (map == null) {
            try {
                mapNormalizedRefLock.lock();
                map = normalizedRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, String>();
                    normalizedRef = new SoftReference<Map<String, String>>(map);
                }
            }
            finally {
                mapNormalizedRefLock.unlock();
            }
        }
        return map;
    }

    private static boolean existsImpl(File file) {
        FileSystemsProvider.Data data = FileSystemsProvider.get(file);
        if (data == null) {
            return file.exists();
        }
        FileObject fileObject = data.fileSystem.getRoot().getFileObject(data.path);
        if (fileObject == null) {
            return false;
        }
        return !fileObject.isVirtual();
    }

    private static File[] listFilesImpl(File file) {
        FileSystemsProvider.Data data = FileSystemsProvider.get(file);
        if (data == null) {
            return file.listFiles();
        }
        FileObject fileObject = data.fileSystem.getRoot().getFileObject(data.path);
        fileObject.getFileObject("dummy");
        return file.listFiles();
    }

    static {
        boolean bl;
        FSL = new FSListener();
        try {
            File file = File.createTempFile("CaseSensitiveFile", ".check");
            String string = file.getAbsolutePath();
            string = string.toUpperCase();
            bl = !new File(string).exists();
            file.delete();
            FileUtil.addFileChangeListener((FileChangeListener)FSL);
        }
        catch (IOException iOException) {
            bl = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = bl;
        maRefLock = new ReentrantLock();
        mapNormalizedRefLock = new ReentrantLock();
        mapRef = new SoftReference(new ConcurrentHashMap());
        normalizedRef = new SoftReference(new ConcurrentHashMap());
        TRACE_EXTERNAL_CHANGES = Boolean.getBoolean("cnd.modelimpl.trace.external.changes");
    }

    private static final class FSListener
    implements FileChangeListener {
        private FSListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.clearCachesAboutFile(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.clearCachesAboutFile(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.clearCachesAboutFile(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            File file = this.clearCachesAboutFile((FileEvent)fileRenameEvent);
            if (file != null) {
                String string = fileRenameEvent.getExt();
                String string2 = string.length() == 0 ? fileRenameEvent.getName() : fileRenameEvent.getName() + "." + string;
                this.clearCachesAboutFile(new File(file, string2), false);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        private File clearCachesAboutFile(FileEvent fileEvent) {
            return this.clearCachesAboutFile(FileUtil.toFile((FileObject)fileEvent.getFile()), true);
        }

        private File clearCachesAboutFile(File file, boolean bl) {
            this.cleanCachesImpl(file.getAbsolutePath());
            if (bl) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    this.cleanCachesImpl(file2.getAbsolutePath());
                }
                return file2;
            }
            return null;
        }

        private void cleanCachesImpl(String string) {
            if (TRACE_EXTERNAL_CHANGES) {
                System.err.println("clean cache for " + string);
            }
            CndFileUtils.getFilesMap().remove(string);
        }
    }

    private static final class Flags {
        private final boolean exist;
        private final boolean directory;
        private static final Flags FILE = new Flags(true, false);
        private static final Flags DIRECTORY = new Flags(true, true);
        private static final Flags INDEXED_DIRECTORY = new Flags(true, true);
        private static final Flags NOT_FOUND = new Flags(false, true);
        private static final Flags NOT_FOUND_INDEXED_DIRECTORY = new Flags(false, true);

        private Flags(boolean bl, boolean bl2) {
            this.exist = bl;
            this.directory = bl2;
        }

        private static Flags get(File file) {
            if (CndFileUtils.existsImpl(file)) {
                if (file.isDirectory()) {
                    return DIRECTORY;
                }
                return FILE;
            }
            return NOT_FOUND;
        }

        public String toString() {
            if (this == NOT_FOUND) {
                return "NOT_FOUND";
            }
            if (this == NOT_FOUND_INDEXED_DIRECTORY) {
                return "NOT_FOUND_INDEXED_DIRECTORY";
            }
            if (this == INDEXED_DIRECTORY) {
                return "INDEXED_DIRECTORY";
            }
            if (this == DIRECTORY) {
                return "DIRECTORY";
            }
            if (this == FILE) {
                return "FILE";
            }
            return "UNKNOWN";
        }
    }
}

