/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TinySingletonMap<K, V>
implements Map<K, V> {
    private K key;
    private V value;

    public TinySingletonMap() {
    }

    public TinySingletonMap(K k, V v) {
        this.key = k;
        this.value = v;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public int size() {
        if (this.key == null) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.key == null;
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.key == null) {
            return false;
        }
        return this.key.equals(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.value != null && this.value.equals(object);
    }

    @Override
    public V get(Object object) {
        if (this.key != null && this.key.equals(object)) {
            return this.value;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        V v2 = null;
        if (this.key != null && this.key.equals(k)) {
            v2 = this.value;
        }
        this.key = k;
        this.value = v;
        return v2;
    }

    @Override
    public V remove(Object object) {
        if (this.key == null) {
            return null;
        }
        if (this.key.equals(object)) {
            V v = this.value;
            this.key = null;
            this.value = null;
            return v;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.key = null;
        this.value = null;
    }

    @Override
    public Set<K> keySet() {
        if (this.key == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<V> values() {
        if (this.key == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.key == null) {
            return Collections.emptySet();
        }
        return new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private boolean last = false;

                    @Override
                    public boolean hasNext() {
                        return !this.last;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.last) {
                            this.last = true;
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return TinySingletonMap.this.key;
                                }

                                @Override
                                public V getValue() {
                                    return TinySingletonMap.this.value;
                                }

                                @Override
                                public V setValue(V v) {
                                    Object object = TinySingletonMap.this.value;
                                    TinySingletonMap.this.value = v;
                                    return object;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public boolean contains(Object object) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean add(Map.Entry<K, V> entry) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

