/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.LogSupport;
import org.netbeans.modules.tomcat5.util.UnsupportedLoggerException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class LogViewer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(LogViewer.class.getName());
    private volatile boolean stop = false;
    private final TomcatManager tomcatManager;
    private InputOutput inOut;
    private OutputWriter writer;
    private OutputWriter errorWriter;
    private File directory;
    private String prefix;
    private String suffix;
    private boolean isTimestamped;
    private boolean takeFocus;
    private ContextLogSupport logSupport;
    private String catalinaWorkDir;
    private String webAppContext;
    private boolean isStarted;
    private List stopListeners = Collections.synchronizedList(new LinkedList());
    private String displayName;

    public LogViewer(TomcatManager tomcatManager, String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) throws UnsupportedLoggerException {
        super("LogViewer - Thread");
        this.tomcatManager = tomcatManager;
        this.catalinaWorkDir = tomcatManager.getCatalinaWork();
        if (string2 != null && !"org.apache.catalina.logger.FileLogger".equals(string2)) {
            throw new UnsupportedLoggerException(string2);
        }
        if (string3 != null) {
            this.directory = new File(string3);
            if (!this.directory.isAbsolute()) {
                this.directory = new File(tomcatManager.getTomcatProperties().getCatalinaDir(), string3);
            }
        } else {
            this.directory = new File(tomcatManager.getTomcatProperties().getCatalinaDir(), "logs");
        }
        this.prefix = string4 != null ? string4 : "catalina.";
        this.suffix = string5 != null ? string5 : ".log";
        this.isTimestamped = bl;
        this.takeFocus = bl2;
        this.webAppContext = string;
        this.logSupport = new ContextLogSupport(this.catalinaWorkDir, string);
        this.setDaemon(true);
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogViewer logViewer = this;
        synchronized (logViewer) {
            this.stop = true;
            this.notify();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LogViewer) {
            LogViewer logViewer = (LogViewer)object;
            if (this.catalinaWorkDir.equals(logViewer.catalinaWorkDir) && (this.webAppContext != null && this.webAppContext.equals(logViewer.webAppContext) || this.webAppContext == logViewer.webAppContext) && this.directory.equals(logViewer.directory) && this.prefix.equals(logViewer.prefix) && this.suffix.equals(logViewer.suffix) && this.isTimestamped) {
                return true;
            }
        }
        return false;
    }

    public boolean isOpen() {
        InputOutput inputOutput = this.inOut;
        return inputOutput != null && !this.stop && (!this.isStarted || !inputOutput.isClosed());
    }

    public void takeFocus() {
        InputOutput inputOutput = this.inOut;
        if (inputOutput != null) {
            inputOutput.select();
        }
    }

    private File getLogFile(String string) throws IOException {
        File file = new File(this.directory, this.prefix + string + this.suffix);
        try {
            FileUtil.createData((File)file);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return null;
        }
        return file;
    }

    private String getTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date());
    }

    private void processLine(String string) {
        LogSupport.LineInfo lineInfo = this.logSupport.analyzeLine(string);
        if (lineInfo.isError()) {
            if (lineInfo.isAccessible()) {
                try {
                    this.errorWriter.println(string, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                this.errorWriter.println(string);
            }
        } else {
            if (string.contains("java.lang.LinkageError: JAXB 2.0 API")) {
                File file = InstalledFileLocator.getDefault().locate("modules/ext/jaxws21/api/jaxws-api.jar", null, false);
                File file2 = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
                File file3 = this.tomcatManager.getTomcatProperties().getJavaEndorsedDir();
                if (file != null && file2 != null) {
                    this.writer.println(NbBundle.getMessage(LogViewer.class, (String)"MSG_WSSERVLET11", (Object)file.getParent(), (Object)file2.getParent(), (Object)file3));
                } else {
                    this.writer.println(NbBundle.getMessage(LogViewer.class, (String)"MSG_WSSERVLET11_NOJAR", (Object)file3));
                }
            }
            this.writer.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block30: {
            String string;
            if (this.displayName == null) {
                this.displayName = this.prefix;
                int n = this.displayName.lastIndexOf(46);
                if (n > -1) {
                    this.displayName = this.displayName.substring(0, n);
                }
            }
            this.inOut = IOProvider.getDefault().getIO(this.displayName, false);
            try {
                this.inOut.getOut().reset();
            }
            catch (IOException iOException) {
                Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, iOException);
            }
            this.inOut.select();
            this.writer = this.inOut.getOut();
            this.errorWriter = this.inOut.getErr();
            this.isStarted = true;
            String string2 = string = this.getTimestamp();
            try {
                File file = this.getLogFile(string);
                BufferedReader bufferedReader = null;
                if (file != null) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                }
                block17: while (true) {
                    while (!this.stop && !this.inOut.isClosed()) {
                        Process process = this.tomcatManager.getTomcatProcess();
                        try {
                            process.exitValue();
                            break block30;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            string = this.getTimestamp();
                            if (!string.equals(string2)) {
                                string2 = string;
                                if (bufferedReader != null) {
                                    bufferedReader.close();
                                }
                                if ((file = this.getLogFile(string)) != null) {
                                    bufferedReader = new BufferedReader(new FileReader(file));
                                }
                            }
                            if (bufferedReader != null) {
                                int n = 0;
                                boolean bl = false;
                                while (bufferedReader.ready() && n++ < 1024) {
                                    this.processLine(bufferedReader.readLine());
                                    bl = true;
                                }
                                if (bl) {
                                    this.writer.flush();
                                    this.errorWriter.flush();
                                    if (this.takeFocus) {
                                        this.inOut.select();
                                    }
                                }
                            }
                            try {
                                LogViewer logViewer = this;
                                synchronized (logViewer) {
                                    if (!this.stop && !this.inOut.isClosed()) {
                                        this.wait(100L);
                                    }
                                    continue block17;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                    break block30;
                    {
                        continue block17;
                        break;
                    }
                    break;
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                this.writer.close();
                this.errorWriter.close();
            }
        }
        this.fireLogViewerStopListener();
        this.logSupport.detachAnnotation();
    }

    public void addLogViewerStopListener(LogViewerStopListener logViewerStopListener) {
        this.stopListeners.add(logViewerStopListener);
    }

    public void removeAllLogViewerStopListener() {
        this.stopListeners.removeAll(this.stopListeners);
    }

    private void fireLogViewerStopListener() {
        Iterator iterator = this.stopListeners.iterator();
        while (iterator.hasNext()) {
            ((LogViewerStopListener)iterator.next()).callOnStop();
        }
    }

    static class ContextLogSupport
    extends LogSupport {
        private final String CATALINA_WORK_DIR;
        private String context = null;
        private String prevMessage = null;
        private static final String STANDARD_CONTEXT = "StandardContext[";
        private static final int STANDARD_CONTEXT_LENGTH = "StandardContext[".length();
        private GlobalPathRegistry globalPathReg = GlobalPathRegistry.getDefault();

        public ContextLogSupport(String string, String string2) {
            this.CATALINA_WORK_DIR = string;
            this.context = string2;
        }

        public LogSupport.LineInfo analyzeLine(String string) {
            String string2 = null;
            int n = -1;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = false;
            string = string.trim();
            int n2 = string.length();
            if (string.startsWith("/")) {
                bl = true;
                int n3 = string.indexOf(58);
                if (n3 > -1) {
                    int n4;
                    string2 = string.substring(0, n3);
                    bl2 = true;
                    if (n2 > n3 && (n4 = string.indexOf(58, n3 + 1)) > -1) {
                        String string4 = string.substring(n3 + 1, n4);
                        try {
                            n = Integer.valueOf(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        if (n2 > n4) {
                            string3 = string.substring(n4 + 1, n2);
                        }
                    }
                }
            } else if (n2 > 3 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                bl = true;
                int n5 = string.indexOf(58, 2);
                if (n5 > -1) {
                    int n6;
                    string2 = string.substring(0, n5);
                    bl2 = true;
                    if (n2 > n5 && (n6 = string.indexOf(58, n5 + 1)) > -1) {
                        String string5 = string.substring(n5 + 1, n6);
                        try {
                            n = Integer.valueOf(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        if (n2 > n6) {
                            string3 = string.substring(n6 + 1, n2);
                        }
                    }
                }
            } else if (string.startsWith("at ") && n2 > 3) {
                String string6;
                int n7;
                bl = true;
                int n8 = string.indexOf(40);
                if (n8 > -1 && (n7 = (string6 = string.substring(3, n8)).lastIndexOf(46)) > -1) {
                    int n9;
                    int n10 = string.lastIndexOf(41);
                    int n11 = string.lastIndexOf(58);
                    if (n10 > -1 && n11 > -1) {
                        String string7 = string.substring(n11 + 1, n10);
                        try {
                            n = Integer.valueOf(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Logger.getLogger(LogViewer.class.getName()).log(Level.INFO, null, numberFormatException);
                        }
                        string3 = this.prevMessage;
                    }
                    String string8 = string6.substring(0, (n9 = string6.indexOf(36)) > -1 ? n9 : n7);
                    string2 = string8.replace('.', '/') + ".java";
                    boolean bl3 = bl2 = this.globalPathReg.findResource(string2) != null;
                    if (string8.startsWith("org.apache.jsp.") && this.context != null && this.context != null) {
                        String string9 = this.context.equals("/") ? "/_" : this.context;
                        string2 = this.CATALINA_WORK_DIR + string9 + "/" + string2;
                        bl2 = new File(string2).exists();
                    }
                }
            } else {
                this.prevMessage = string;
                int n12 = string.indexOf(STANDARD_CONTEXT);
                int n13 = -1;
                if (n12 > -1) {
                    n13 = n12 + STANDARD_CONTEXT_LENGTH;
                }
                int n14 = string.indexOf(93);
                if (n13 > -1 && n14 > -1 && n14 > n13) {
                    this.context = string.substring(n13, n14);
                }
            }
            return new LogSupport.LineInfo(string2, n, string3, bl, bl2);
        }
    }

    public static interface LogViewerStopListener
    extends EventListener {
        public void callOnStop();
    }
}

