/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.ExpandableWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class ExpanderWidget
extends ButtonWidget {
    private static Map<Object, Boolean> expandedCache = new WeakHashMap<Object, Boolean>();
    private ExpandableWidget expandable;

    public ExpanderWidget(Scene scene, ExpandableWidget expandableWidget, boolean bl) {
        super(scene, (String)null);
        this.expandable = expandableWidget;
        this.setImage(new ExpanderImageWidget(scene, true, 8, 30));
        this.setSelectedImage((Object)new ExpanderImageWidget(scene, false, 8, 30));
        this.setSelected(bl);
        this.setRoundedBorder(0, 4, 4, null);
        this.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpanderWidget.this.expandable.setExpanded(!ExpanderWidget.this.expandable.isExpanded());
            }
        });
    }

    public static boolean isExpanded(ExpandableWidget expandableWidget, boolean bl) {
        Boolean bl2 = expandedCache.get(expandableWidget.hashKey());
        return bl2 != null ? bl2 : bl;
    }

    public void setSelected(boolean bl) {
        expandedCache.put(this.expandable.hashKey(), bl);
        super.setSelected(bl);
        this.revalidate(true);
    }

    private static class ExpanderImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private static final Stroke STROKE = new BasicStroke(2.5f, 2, 0);
        private double cos;

        public ExpanderImageWidget(Scene scene, boolean bl, int n, int n2) {
            super(scene, ButtonWidget.BORDER_COLOR, n, n);
            double d = Math.PI * (double)n2 / 180.0;
            this.cos = Math.cos(d / 2.0);
            if (!bl) {
                this.cos = -this.cos;
            }
        }

        protected Stroke getImageStroke() {
            return STROKE;
        }

        protected Shape createImage(int n, int n2) {
            GeneralPath generalPath = new GeneralPath();
            float f = (float)((double)n2 + this.cos * (double)n2 / 2.0) / 2.0f;
            float f2 = (float)((double)n2 - this.cos * (double)n2 / 2.0) / 2.0f;
            generalPath.moveTo(n / 2, f);
            generalPath.lineTo(0.0f, f2);
            generalPath.moveTo(n / 2, f);
            generalPath.lineTo(n, f2);
            return generalPath;
        }
    }
}

