/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParserResult;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.HtmlVersion;
import org.netbeans.modules.html.editor.gsf.HtmlParserResultAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParserResult
extends ParserResult {
    public static final String FALLBACK_DTD_PROPERTY_NAME = "fallbackDTD";
    private SyntaxParserResult result;
    private List<Error> errors;
    private boolean isValid = true;

    private HtmlParserResult(Snapshot snapshot, SyntaxParserResult syntaxParserResult) {
        super(snapshot);
        this.result = syntaxParserResult;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public HtmlVersion getHtmlVersion() {
        String string = this.result.getPublicID();
        if (string == null) {
            FileObject fileObject = this.getSnapshot().getSource().getFileObject();
            if (fileObject != null) {
                if ("text/xhtml".equals(fileObject.getMIMEType())) {
                    return HtmlVersion.XHTML10;
                }
                if (this.result.getDeclaredNamespaces().containsKey(HtmlVersion.XHTML10.getDefaultNamespace())) {
                    return HtmlVersion.XHTML10;
                }
            }
            return HtmlVersion.UNKNOWN;
        }
        return HtmlVersion.findHtmlVersion(string);
    }

    public DTD dtd() {
        return this.result.getDTD();
    }

    public AstNode root() {
        return this.root(this.getHtmlVersion().getDefaultNamespace());
    }

    public AstNode root(String string) {
        DTD dTD = null;
        if (string == null || string != null && string.equals(this.getHtmlVersion().getDefaultNamespace())) {
            dTD = this.getFallbackDTD(this.getHtmlVersion());
        }
        return this.result.getASTRoot(string, dTD);
    }

    private DTD getFallbackDTD(HtmlVersion htmlVersion) {
        String string = htmlVersion == HtmlVersion.UNKNOWN ? HtmlVersion.HTML41.getFallbackPublicId() : htmlVersion.getFallbackPublicId();
        return Registry.getDTD((String)string, null);
    }

    public Map<String, AstNode> roots() {
        HashMap<String, AstNode> hashMap = new HashMap<String, AstNode>();
        for (String string : this.getNamespaces().keySet()) {
            hashMap.put(string, this.root(string));
        }
        if (!hashMap.containsValue(this.root())) {
            hashMap.put(null, this.root());
        }
        return hashMap;
    }

    public Map<String, String> getNamespaces() {
        return this.result.getDeclaredNamespaces();
    }

    public AstNode findLeaf(int n) {
        return this.findLeaf(n, false);
    }

    public AstNode findLeaf(int n, boolean bl) {
        AstNode astNode = AstNodeUtils.findDescendant((AstNode)this.root(), (int)n, (boolean)bl);
        for (String string : this.getNamespaces().keySet()) {
            AstNode astNode2 = this.root(string);
            AstNode astNode3 = AstNodeUtils.findDescendant((AstNode)astNode2, (int)n, (boolean)bl);
            if (astNode == null) {
                astNode = astNode3;
                continue;
            }
            if (astNode3.logicalStartOffset() <= astNode.logicalStartOffset()) continue;
            astNode = astNode3;
        }
        return astNode;
    }

    public AstNode findLeafTag(int n, boolean bl, boolean bl2) {
        AstNode astNode = AstNodeUtils.findDescendantTag((AstNode)this.root(), (int)n, (boolean)bl, (boolean)bl2);
        for (String string : this.getNamespaces().keySet()) {
            AstNode astNode2 = this.root(string);
            AstNode astNode3 = AstNodeUtils.findDescendantTag((AstNode)astNode2, (int)n, (boolean)bl, (boolean)bl2);
            if (astNode3 == null) continue;
            if (astNode == null) {
                astNode = astNode3;
                continue;
            }
            if (astNode3.logicalStartOffset() <= astNode.logicalStartOffset()) continue;
            astNode = astNode3;
        }
        return astNode;
    }

    public List<SyntaxElement> elementsList() {
        return this.result.getElements();
    }

    public synchronized List<? extends Error> getDiagnostics() {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>(this.findErrors());
        }
        return this.errors;
    }

    protected void invalidate() {
        this.isValid = false;
    }

    private List<Error> findErrors() {
        final ArrayList<Error> arrayList = new ArrayList<Error>();
        AstNodeUtils.visitChildren((AstNode)this.root(), (AstNodeVisitor)new AstNodeVisitor(){

            public void visit(AstNode astNode) {
                if (astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.ENDTAG || astNode.type() == AstNode.NodeType.UNKNOWN_TAG) {
                    for (AstNode.Description description : astNode.getDescriptions()) {
                        if (description.getType() < 1) continue;
                        Error error = DefaultError.createDefaultError((String)"tag_error", (String)description.getText(), (String)description.getText(), (FileObject)HtmlParserResult.this.getSnapshot().getSource().getFileObject(), (int)HtmlParserResult.this.getSnapshot().getOriginalOffset(description.getFrom()), (int)HtmlParserResult.this.getSnapshot().getOriginalOffset(description.getTo()), (boolean)false, (Severity)(description.getType() == 1 ? Severity.WARNING : Severity.ERROR));
                        arrayList.add(error);
                    }
                }
            }
        });
        return arrayList;
    }

    static {
        HtmlParserResultAccessor.set(new Accessor());
    }

    private static class Accessor
    extends HtmlParserResultAccessor {
        private Accessor() {
        }

        public HtmlParserResult createInstance(Snapshot snapshot, SyntaxParserResult syntaxParserResult) {
            return new HtmlParserResult(snapshot, syntaxParserResult);
        }
    }
}

