/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

final class DefaultES
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
SaveAsCapable {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            DefaultES.this.saveDocument();
        }
    };
    private CookieSet set;

    DefaultES(DataObject dataObject, MultiDataObject.Entry entry, CookieSet cookieSet) {
        super(dataObject, new Environment(dataObject, entry));
        this.set = cookieSet;
        this.setMIMEType("text/plain");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    protected boolean asynchronousOpen() {
        return false;
    }

    private void addSaveCookie() {
        DataObject dataObject = this.getDataObject();
        if (dataObject.getCookie(SaveCookie.class) == null) {
            this.set.add((Node.Cookie)this.saveCookie);
            dataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        DataObject dataObject = this.getDataObject();
        SaveCookie saveCookie = dataObject.getCookie(SaveCookie.class);
        if (saveCookie != null && saveCookie.equals(this.saveCookie)) {
            this.set.remove((Node.Cookie)this.saveCookie);
            dataObject.setModified(false);
        }
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 5451434321155443431L;
        private MultiDataObject.Entry entry;

        public Environment(DataObject dataObject, MultiDataObject.Entry entry) {
            super(dataObject);
            this.entry = entry;
        }

        protected FileObject getFile() {
            return this.entry.getFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.entry.takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            DataObject dataObject = this.getDataObject();
            DefaultES defaultES = dataObject instanceof DefaultDataObject ? ((DefaultDataObject)dataObject).getCookie(DefaultES.class, true) : this.getDataObject().getCookie(DefaultES.class);
            super.findCloneableOpenSupport();
            return defaultES;
        }
    }
}

