/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphScene
extends GraphScene<Function, Call> {
    private static final Border BORDER_4 = BorderFactory.createLineBorder((int)4);
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private Router router;
    private SceneLayout sceneLayout;
    private WidgetAction moveAction = ActionFactory.createMoveAction();
    private WidgetAction hoverAction = this.createWidgetHoverAction();
    private WidgetAction popupAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new MyPopupMenuProvider());
    private Font defaultItalicFont;
    private Action exportAction;
    private CallModel callModel;

    public CallGraphScene() {
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[]{this.mainLayer, this.connectionLayer});
        this.defaultItalicFont = new Font(this.getDefaultFont().getName(), 2, this.getDefaultFont().getSize());
        this.getActions().addAction(this.popupAction);
        this.getActions().addAction(ActionFactory.createWheelPanAction());
    }

    public void setLayout(SceneLayout sceneLayout) {
        this.sceneLayout = sceneLayout;
    }

    public void setModel(CallModel callModel) {
        this.callModel = callModel;
    }

    public void doLayout() {
        Runnable runnable = new Runnable(){

            public void run() {
                CallGraphScene.this.sceneLayout.invokeLayout();
                CallGraphScene.this.validate();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void hideNode(final Function function) {
        Runnable runnable = new Runnable(){

            public void run() {
                CallGraphScene.this.removeNodeWithEdges(function);
                CallGraphScene.this.doLayout();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void clean() {
        Runnable runnable = new Runnable(){

            public void run() {
                ArrayList arrayList = new ArrayList(CallGraphScene.this.getNodes());
                for (Function function : arrayList) {
                    CallGraphScene.this.removeNodeWithEdges(function);
                }
                CallGraphScene.this.doLayout();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addCallToScene(final Call call) {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                Function function = call.getCallee();
                Widget widget = CallGraphScene.this.findWidget(function);
                if (widget == null) {
                    widget = CallGraphScene.this.addNode(function);
                    widget.setPreferredLocation(new Point(100, 100));
                    bl = true;
                }
                if (call.getCaller() != null) {
                    Function function2 = call.getCaller();
                    Widget widget2 = CallGraphScene.this.findWidget(function2);
                    if (widget2 == null) {
                        widget2 = CallGraphScene.this.addNode(function2);
                        widget2.setPreferredLocation(new Point(10, 10));
                        bl = true;
                    }
                    if (CallGraphScene.this.findEdgesBetween(function2, function).size() == 0) {
                        if (function.equals(function2)) {
                            CallGraphScene.this.addLoopEdge(call, function);
                        } else {
                            CallGraphScene.this.addEdge(call);
                            CallGraphScene.this.setEdgeSource(call, function2);
                            CallGraphScene.this.setEdgeTarget(call, function);
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    CallGraphScene.this.doLayout();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addFunctionToScene(final Function function) {
        Runnable runnable = new Runnable(){

            public void run() {
                Widget widget = CallGraphScene.this.findWidget(function);
                if (widget == null) {
                    widget = CallGraphScene.this.addNode(function);
                    widget.setPreferredLocation(new Point(100, 100));
                    CallGraphScene.this.doLayout();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void addLoopEdge(Call call, Function function) {
        ConnectionWidget connectionWidget = (ConnectionWidget)this.addEdge(call);
        Widget widget = this.findWidget(function);
        connectionWidget.setRouter(this.router);
        MyVMDNodeAnchor myVMDNodeAnchor = new MyVMDNodeAnchor(widget);
        this.setEdgeSource(call, function);
        connectionWidget.setSourceAnchor((Anchor)myVMDNodeAnchor);
        this.setEdgeTarget(call, function);
        connectionWidget.setTargetAnchor((Anchor)myVMDNodeAnchor);
    }

    protected Widget attachNodeWidget(Function function) {
        String string = function.getName();
        String string2 = function.getScopeName();
        Object object = string2 != null && string2.length() > 0 ? new MyMemberLabelWidget((Scene)this, string2, string) : new MyLabelWidget((Scene)this, string);
        if (function.isVurtual()) {
            object.setFont(this.defaultItalicFont);
        }
        object.setToolTipText(function.getDescription());
        object.setBorder(BORDER_4);
        object.getActions().addAction(this.moveAction);
        object.getActions().addAction(this.hoverAction);
        object.getActions().addAction(ActionFactory.createEditAction((EditProvider)new NodeEditProvider(function)));
        object.getActions().addAction(this.popupAction);
        this.mainLayer.addChild((Widget)object);
        return object;
    }

    protected Widget attachEdgeWidget(Call call) {
        ConnectionWidget connectionWidget = new ConnectionWidget((Scene)this);
        connectionWidget.setToolTipText(call.getDescription());
        connectionWidget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        connectionWidget.getActions().addAction(this.hoverAction);
        connectionWidget.getActions().addAction(ActionFactory.createEditAction((EditProvider)new EdgeEditProvider(call)));
        this.connectionLayer.addChild((Widget)connectionWidget);
        return connectionWidget;
    }

    protected void attachEdgeSourceAnchor(Call call, Function function, Function function2) {
        Widget widget = function2 != null ? this.findWidget(function2) : null;
        ((ConnectionWidget)this.findWidget(call)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)widget));
    }

    protected void attachEdgeTargetAnchor(Call call, Function function, Function function2) {
        Widget widget = function2 != null ? this.findWidget(function2) : null;
        ((ConnectionWidget)this.findWidget(call)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)widget));
    }

    public void setExportAction(Action action) {
        this.exportAction = action;
    }

    private class RemoveNode
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public RemoveNode(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"RemoveNode"));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CallGraphScene.this.hideNode(RemoveNode.this.function);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class ExpandCallers
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public ExpandCallers(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"ExpandCallers"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallers(ExpandCallers.this.function)) {
                        CallGraphScene.this.addCallToScene(call);
                    }
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class ExpandCallees
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public ExpandCallees(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"ExpandCallees"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallees(ExpandCallees.this.function)) {
                        CallGraphScene.this.addCallToScene(call);
                    }
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class MyPopupMenuProvider
    implements PopupMenuProvider {
        private MyPopupMenuProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point point) {
            JPopupMenu jPopupMenu = null;
            Object object = CallGraphScene.this.findObject(widget);
            if (object instanceof Function) {
                Function function = (Function)object;
                jPopupMenu = new JPopupMenu();
                jPopupMenu.add(new GoToReferenceAction(function, 0).getPopupPresenter());
                jPopupMenu.add(new ExpandCallees(function).getPopupPresenter());
                jPopupMenu.add(new ExpandCallers(function).getPopupPresenter());
                jPopupMenu.add(new JSeparator());
                jPopupMenu.add(new RemoveNode(function).getPopupPresenter());
            } else if (widget instanceof CallGraphScene) {
                jPopupMenu = new JPopupMenu();
                jPopupMenu.add(((Presenter.Popup)CallGraphScene.this.exportAction).getPopupPresenter());
            }
            return jPopupMenu;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyVMDNodeAnchor
    extends Anchor {
        private boolean requiresRecalculation = true;
        private HashMap<Anchor.Entry, Anchor.Result> results = new HashMap();
        private final boolean vertical;

        public MyVMDNodeAnchor(Widget widget) {
            super(widget);
            this.vertical = true;
        }

        protected void notifyEntryAdded(Anchor.Entry entry) {
            this.requiresRecalculation = true;
        }

        protected void notifyEntryRemoved(Anchor.Entry entry) {
            this.results.remove(entry);
            this.requiresRecalculation = true;
        }

        protected void notifyRevalidate() {
            this.requiresRecalculation = true;
        }

        private void recalculate() {
            Anchor.Entry entry;
            int n;
            int n2;
            int n3;
            Anchor.Entry[] entryArray2;
            if (!this.requiresRecalculation) {
                return;
            }
            Widget widget = this.getRelatedWidget();
            Point point = this.getRelatedSceneLocation();
            Rectangle rectangle = widget.convertLocalToScene(widget.getBounds());
            HashMap<Anchor.Entry, Float> hashMap = new HashMap<Anchor.Entry, Float>();
            HashMap<Anchor.Entry, Float> hashMap2 = new HashMap<Anchor.Entry, Float>();
            for (Anchor.Entry[] entryArray2 : this.getEntries()) {
                Point point2 = this.getOppositeSceneLocation((Anchor.Entry)entryArray2);
                if (point2 == null || point == null) {
                    this.results.put((Anchor.Entry)entryArray2, new Anchor.Result((Anchor)this, new Point(rectangle.x, rectangle.y), DIRECTION_ANY));
                    continue;
                }
                n3 = point2.y - point.y;
                n2 = point2.x - point.x;
                if (this.vertical) {
                    if (n3 > 0) {
                        hashMap2.put((Anchor.Entry)entryArray2, Float.valueOf((float)n2 / (float)n3));
                        continue;
                    }
                    if (n3 < 0) {
                        hashMap.put((Anchor.Entry)entryArray2, Float.valueOf((float)(-n2) / (float)n3));
                        continue;
                    }
                    hashMap.put((Anchor.Entry)entryArray2, Float.valueOf(n2 < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
                    continue;
                }
                if (n2 > 0) {
                    hashMap2.put((Anchor.Entry)entryArray2, Float.valueOf((float)n3 / (float)n2));
                    continue;
                }
                if (n3 < 0) {
                    hashMap.put((Anchor.Entry)entryArray2, Float.valueOf((float)(-n3) / (float)n2));
                    continue;
                }
                hashMap.put((Anchor.Entry)entryArray2, Float.valueOf(n3 < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
            }
            Anchor.Entry[] entryArray3 = this.toArray(hashMap);
            entryArray2 = this.toArray(hashMap2);
            int n4 = 0;
            n3 = rectangle.y - n4;
            n2 = rectangle.x - n4;
            int n5 = entryArray3.length;
            for (n = 0; n < n5; ++n) {
                entry = entryArray3[n];
                if (this.vertical) {
                    n2 = rectangle.x + (n + 1) * rectangle.width / (n5 + 1);
                } else {
                    n3 = rectangle.y + (n + 1) * rectangle.height / (n5 + 1);
                }
                this.results.put(entry, new Anchor.Result((Anchor)this, new Point(n2, n3), this.vertical ? Anchor.Direction.TOP : Anchor.Direction.LEFT));
            }
            n3 = rectangle.y + rectangle.height + n4;
            n2 = rectangle.x + rectangle.width + n4;
            n5 = entryArray2.length;
            for (n = 0; n < n5; ++n) {
                entry = entryArray2[n];
                if (this.vertical) {
                    n2 = rectangle.x + (n + 1) * rectangle.width / (n5 + 1);
                } else {
                    n3 = rectangle.y + (n + 1) * rectangle.height / (n5 + 1);
                }
                this.results.put(entry, new Anchor.Result((Anchor)this, new Point(n2, n3), this.vertical ? Anchor.Direction.BOTTOM : Anchor.Direction.RIGHT));
            }
            this.requiresRecalculation = false;
        }

        private Anchor.Entry[] toArray(final HashMap<Anchor.Entry, Float> hashMap) {
            Set<Anchor.Entry> set = hashMap.keySet();
            Anchor.Entry[] entryArray = set.toArray(new Anchor.Entry[set.size()]);
            Arrays.sort(entryArray, new Comparator<Anchor.Entry>(){

                @Override
                public int compare(Anchor.Entry entry, Anchor.Entry entry2) {
                    float f = ((Float)hashMap.get(entry)).floatValue() - ((Float)hashMap.get(entry2)).floatValue();
                    if (f > 0.0f) {
                        return 1;
                    }
                    if (f < 0.0f) {
                        return -1;
                    }
                    return 0;
                }
            });
            return entryArray;
        }

        public Anchor.Result compute(Anchor.Entry entry) {
            this.recalculate();
            return this.results.get(entry);
        }
    }

    private static final class MyMemberLabelWidget
    extends Widget {
        private String scope;
        private String label;

        public MyMemberLabelWidget(Scene scene, String string, String string2) {
            super(scene);
            this.scope = string;
            this.label = string2;
            this.setOpaque(false);
            this.revalidate();
            this.setCheckClipping(true);
        }

        protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
            if (objectState.isHovered() == objectState2.isHovered()) {
                return;
            }
            this.setForeground(this.getScene().getLookFeel().getLineColor(objectState2));
            this.repaint();
        }

        protected Rectangle calculateClientArea() {
            Graphics2D graphics2D = this.getGraphics();
            Rectangle2D rectangle2D = graphics2D.getFontMetrics(this.getFont()).getStringBounds(this.scope, graphics2D);
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics(this.getFont().deriveFont(1)).getStringBounds(this.label, graphics2D);
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()), rectangle2D.getHeight() + rectangle2D2.getHeight());
            return MyMemberLabelWidget.roundRectangle(double_);
        }

        private static Rectangle roundRectangle(Rectangle2D rectangle2D) {
            int n = (int)Math.floor(rectangle2D.getX());
            int n2 = (int)Math.floor(rectangle2D.getY());
            int n3 = (int)Math.ceil(rectangle2D.getMaxX());
            int n4 = (int)Math.ceil(rectangle2D.getMaxY());
            return new Rectangle(n, n2, n3 - n, n4 - n2);
        }

        protected void paintWidget() {
            if (this.label == null) {
                return;
            }
            Graphics2D graphics2D = this.getGraphics();
            graphics2D.setFont(this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle rectangle = this.getClientArea();
            int n = rectangle.x;
            int n2 = 0;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n, n2);
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(this.scope, 0, 0);
            graphics2D.setFont(this.getFont().deriveFont(1));
            graphics2D.drawString(this.label, 0, fontMetrics.getHeight());
            graphics2D.setTransform(affineTransform);
        }
    }

    private static final class MyLabelWidget
    extends LabelWidget {
        public MyLabelWidget(Scene scene, String string) {
            super(scene);
            this.setFont(scene.getFont().deriveFont(1));
            this.setLabel(string);
        }

        protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
            if (objectState.isHovered() == objectState2.isHovered()) {
                return;
            }
            this.setForeground(this.getScene().getLookFeel().getLineColor(objectState2));
            this.repaint();
        }
    }

    private static class EdgeEditProvider
    implements EditProvider {
        private Call call;

        private EdgeEditProvider(Call call) {
            this.call = call;
        }

        public void edit(Widget widget) {
            this.call.open();
        }
    }

    private static class NodeEditProvider
    implements EditProvider {
        private Function node;

        private NodeEditProvider(Function function) {
            this.node = function;
        }

        public void edit(Widget widget) {
            this.node.open();
        }
    }
}

