/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.dlight.visualizers.MultiSortTableCellHeaderRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TableSorter
extends AbstractTableModel
implements TableModelListener {
    private static final boolean TRACE = Boolean.getBoolean("table.sorter.trace");
    private int[] indexes;
    private List<Integer> sortingColumns = new Vector<Integer>();
    private int compares;
    private TableModel model;
    List<Boolean> sortingColumnsOrder = new Vector<Boolean>();

    public TableSorter() {
        this.indexes = new int[0];
    }

    List<Integer> getSortingColumns() {
        return this.sortingColumns;
    }

    public TableSorter(TableModel tableModel) {
        this.setModel(tableModel);
    }

    private void setModel(TableModel tableModel) {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        this.model = tableModel;
        this.sortingColumns.clear();
        this.sortingColumnsOrder.clear();
        this.fireTableStructureChanged();
        this.fireTableChanged(new TableModelEvent(this));
        tableModel.addTableModelListener(this);
        if (TRACE) {
            System.out.printf("Sorter: @%d setModel\n", this.hashCode());
        }
        this.reallocateIndexes();
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        super.addTableModelListener(tableModelListener);
        if (this.model != null) {
            this.model.addTableModelListener(tableModelListener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        super.removeTableModelListener(tableModelListener);
        if (this.model != null) {
            this.model.removeTableModelListener(tableModelListener);
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this.model != null ? this.model.getRowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.model != null ? this.model.getColumnCount() : 0;
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(n, n2);
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class<?> clazz = this.model.getColumnClass(n3);
        TableModel tableModel = this.model;
        Object object2 = tableModel.getValueAt(n, n3);
        Object object3 = tableModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Number.class) {
            Number number;
            double d;
            Number number2 = (Number)tableModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)tableModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        if (clazz == Date.class) {
            Date date;
            long l;
            Date date2 = (Date)tableModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)tableModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == String.class) {
            String string2;
            String string3 = (String)tableModel.getValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)tableModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)tableModel.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)tableModel.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = tableModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = tableModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        ++this.compares;
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Integer n3 = this.sortingColumns.get(i);
            int n4 = this.compareRowsByColumn(n, n2, n3);
            if (n4 == 0) continue;
            return this.sortingColumnsOrder.get(i) != false ? n4 : -n4;
        }
        return 0;
    }

    public synchronized void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (TRACE) {
            System.out.printf("Sorter: @%d tableChanged\n", this.hashCode());
        }
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    public synchronized void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            if (TRACE) {
                System.out.printf("Sorter: @%d not informed of a change in model.\n", this.hashCode());
            }
            this.reallocateIndexes();
        }
    }

    public void sort(Object object) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            for (int i = n; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[n], n2);
    }

    @Override
    public synchronized void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortingColumnsOrder.clear();
        this.sortingColumnsOrder.add(bl);
        this.sortingColumns.clear();
        this.sortingColumns.add(n);
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    boolean bl = true;
                    if (TableSorter.this.sortingColumns.contains(n2)) {
                        bl = TableSorter.this.sortingColumnsOrder.get(TableSorter.this.sortingColumns.indexOf(n2)) == false;
                    }
                    tableSorter.sortByColumn(n2, bl);
                }
            }
        };
        JTableHeader jTableHeader2 = jTable2.getTableHeader();
        jTableHeader2.setDefaultRenderer(new MultiSortTableCellHeaderRenderer());
        jTableHeader2.addMouseListener(mouseAdapter);
    }
}

