/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.dlight.api.impl.TreeTableNode;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TreeTableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.AdvancedTableViewVisualizer;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.TreeTableVisualizerColumnModel;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.TreeTableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeTableVisualizer<T extends TreeTableNode>
extends JPanel
implements Visualizer<TreeTableVisualizerConfiguration>,
OnTimerTask,
ComponentListener {
    private final Object queryLock = TreeTableVisualizer.class.getName() + "Lock";
    private boolean isShown = true;
    private JToolBar buttonsToolbar;
    private JButton refresh;
    private final TreeTableVisualizerConfiguration configuration;
    private final DefaultTreeModel treeModel;
    protected final DefaultMutableTreeNode TREE_ROOT = new DefaultMutableTreeNode("ROOT");
    private JPanel mainPanel = null;
    private TreeModelImpl treeModelImpl;
    private TableModelImpl tableModelImpl;
    private Models.CompoundModel compoundModel;
    protected JComponent treeTableView;
    private final TreeTableDataProvider<T> dataProvider;
    private OnTimerRefreshVisualizerHandler timerHandler;
    protected boolean isEmptyContent;
    protected boolean isLoadingContent;
    private Future<Boolean> task;
    private Future<List<T>> syncFillDataTask;
    private final Object syncFillInLock = new Object();
    private final ColumnsUIMapping columnsUIMapping;

    TreeTableVisualizer(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration, TreeTableDataProvider<T> treeTableDataProvider) {
        this.configuration = treeTableVisualizerConfiguration;
        this.dataProvider = treeTableDataProvider;
        this.columnsUIMapping = TreeTableVisualizerConfigurationAccessor.getDefault().getColumnsUIMapping(treeTableVisualizerConfiguration);
        this.treeModel = new DefaultTreeModel(this.TREE_ROOT);
        this.setLoadingContent();
    }

    protected void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel jLabel = new JLabel(NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)"Loading"));
        jLabel.setAlignmentX(0.5f);
        this.add(jLabel);
        this.repaint();
        this.revalidate();
    }

    protected void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
        } else {
            this.mainPanel.removeAll();
        }
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JLabel jLabel = new JLabel(NbBundle.getMessage(TreeTableVisualizer.class, (String)"NoDataAvailableYet"));
        jLabel.setAlignmentX(0.5f);
        this.mainPanel.add(jLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.repaint();
        this.revalidate();
    }

    protected void setContent(final boolean bl) {
        UIThread.invoke((Runnable)new Runnable(){

            public void run() {
                if (TreeTableVisualizer.this.isLoadingContent && bl) {
                    TreeTableVisualizer.this.isLoadingContent = false;
                    TreeTableVisualizer.this.setEmptyContent();
                    return;
                }
                if (TreeTableVisualizer.this.isLoadingContent && !bl) {
                    TreeTableVisualizer.this.isLoadingContent = false;
                    TreeTableVisualizer.this.setNonEmptyContent();
                    return;
                }
                if (TreeTableVisualizer.this.isEmptyContent && bl) {
                    return;
                }
                if (TreeTableVisualizer.this.isEmptyContent && !bl) {
                    TreeTableVisualizer.this.setNonEmptyContent();
                    return;
                }
                if (!TreeTableVisualizer.this.isEmptyContent && bl) {
                    TreeTableVisualizer.this.setEmptyContent();
                    return;
                }
            }
        });
    }

    protected void setNonEmptyContent() {
        this.initComponents();
        this.updateButtons();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        if (this.timerHandler != null && this.timerHandler.isSessionRunning()) {
            this.timerHandler.startTimer();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
        object = this.syncFillInLock;
        synchronized (object) {
            if (this.syncFillDataTask != null) {
                this.syncFillDataTask.cancel(true);
                this.syncFillDataTask = null;
            }
        }
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNodes(List<DefaultMutableTreeNode> list) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.TREE_ROOT;
        synchronized (defaultMutableTreeNode) {
            this.TREE_ROOT.removeAllChildren();
            this.fireTreeModelChanged();
            if (list != null) {
                for (DefaultMutableTreeNode defaultMutableTreeNode2 : list) {
                    this.TREE_ROOT.add(defaultMutableTreeNode2);
                }
                this.fireTreeModelChanged();
            }
        }
    }

    protected void fireTreeModelChanged() {
        this.fireTreeModelChanged(null);
    }

    protected void fireTreeModelChanged(final DefaultMutableTreeNode defaultMutableTreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (defaultMutableTreeNode == null) {
                    TreeTableVisualizer.this.treeModelImpl.fireTreeModelChanged();
                } else {
                    TreeTableVisualizer.this.treeModelImpl.fireTreeModelChanged(defaultMutableTreeNode);
                }
            }
        });
    }

    protected void updateButtons() {
    }

    protected JToolBar getButtonsTolbar() {
        return this.buttonsToolbar;
    }

    protected void initComponents() {
        DataTableMetadata.Column column;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonsToolbar = new JToolBar();
        this.refresh = new JButton();
        this.buttonsToolbar.setFloatable(false);
        this.buttonsToolbar.setOrientation(1);
        this.buttonsToolbar.setRollover(true);
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setFocusable(false);
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableVisualizer.this.asyncFillModel(TreeTableVisualizer.this.configuration.getMetadata().getColumns(), false);
            }
        });
        this.buttonsToolbar.add(this.refresh);
        this.add((Component)this.buttonsToolbar, "Before");
        this.mainPanel = new JPanel();
        this.mainPanel.removeAll();
        this.add((Component)this.mainPanel, "Center");
        TreeTableVisualizerConfigurationAccessor treeTableVisualizerConfigurationAccessor = TreeTableVisualizerConfigurationAccessor.getDefault();
        ArrayList<TreeTableVisualizerColumnModel> arrayList = new ArrayList<TreeTableVisualizerColumnModel>();
        for (DataTableMetadata.Column column2 : column = treeTableVisualizerConfigurationAccessor.getTableColumns(this.configuration)) {
            arrayList.add(new TreeTableVisualizerColumnModel(column2, this.columnsUIMapping));
        }
        DataTableMetadata.Column column3 = treeTableVisualizerConfigurationAccessor.getTreeColumn(this.configuration);
        arrayList.add(new TreeTableVisualizerColumnModel(column3, this.columnsUIMapping){

            public Class getType() {
                return null;
            }
        });
        this.treeModelImpl = new TreeModelImpl();
        this.tableModelImpl = new TableModelImpl();
        NodeActionsProvider nodeActionsProvider = treeTableVisualizerConfigurationAccessor.getNodesActionProvider(this.configuration);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(this.treeModelImpl);
        arrayList2.add(this.tableModelImpl);
        arrayList2.addAll(arrayList);
        arrayList2.add(new NodeModelImpl());
        if (nodeActionsProvider != null) {
            arrayList2.add(nodeActionsProvider);
        }
        this.compoundModel = Models.createCompoundModel(arrayList2);
        this.treeTableView = Models.createView((Models.CompoundModel)this.compoundModel);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.treeTableView, "Center");
        this.treeModelImpl.fireTreeModelChanged();
        this.mainPanel.repaint();
        this.repaint();
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void asyncFillModel(final List<DataTableMetadata.Column> list, boolean bl) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (bl) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    TreeTableVisualizer.this.syncFillModel(list);
                    return Boolean.TRUE;
                }
            }, (String)("Async TreeTableVisualizer model fill " + this.configuration.getID()));
        }
    }

    protected void syncFillModel(List<DataTableMetadata.Column> list) {
        List list2 = this.dataProvider.getTableView(list, null, Integer.MAX_VALUE);
        this.updateList(list2);
    }

    protected void updateList(List<T> list) {
        if (list == null) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>(list.size());
        for (TreeTableNode treeTableNode : list) {
            arrayList.add(new DefaultMutableTreeNode(treeTableNode));
        }
        this.setNodes(arrayList);
    }

    protected void loadTree(final DefaultMutableTreeNode defaultMutableTreeNode, final List<T> list) {
        Runnable runnable = new Runnable(){

            public void run() {
                final List list2 = TreeTableVisualizer.this.dataProvider.getChildren(list, TreeTableVisualizer.this.configuration.getMetadata().getColumns(), null);
                UIThread.invoke((Runnable)new Runnable(){

                    public void run() {
                        TreeTableVisualizer.this.updateTree(defaultMutableTreeNode, list2);
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            DLightExecutorService.submit((Runnable)runnable, (String)("Loading data for TreeTableVisualizer " + this.configuration.getID()));
        } else {
            runnable.run();
        }
    }

    protected void updateTree(DefaultMutableTreeNode defaultMutableTreeNode, List<T> list) {
        defaultMutableTreeNode.removeAllChildren();
        if (list != null) {
            for (TreeTableNode treeTableNode : list) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(treeTableNode));
            }
        }
        this.fireTreeModelChanged();
    }

    protected boolean isShown() {
        return this.isShown;
    }

    @Override
    public int onTimer() {
        if (!this.isShown() || !this.isShowing()) {
            return 0;
        }
        this.syncFillModel(this.configuration.getMetadata().getColumns());
        return 0;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public TreeTableVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void timerStopped() {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    public void refresh() {
        this.asyncFillModel(this.configuration.getMetadata().getColumns(), false);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }

    public void updateVisualizerConfiguration(TreeTableVisualizerConfiguration treeTableVisualizerConfiguration) {
    }

    protected String getIcon(T t) {
        return null;
    }

    class NodeModelImpl
    implements ExtendedNodeModel {
        private final Object nodesMapLock = new Object();
        private final Object listenersLock = new Object();
        private Vector<ModelListener> listeners = new Vector();
        private Map<String, String> nodes = new HashMap<String, String>();

        NodeModelImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDisplayName(Object object) {
            if (object == "Root") {
                String string = TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnUName();
                return string;
            }
            final Object object2 = object;
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object3 = defaultMutableTreeNode.getUserObject();
                String string = "";
                if (object3 instanceof TreeTableNode) {
                    final Object object4 = ((TreeTableNode)object3).getValue();
                    Object object5 = this.nodesMapLock;
                    synchronized (object5) {
                        if (this.nodes.containsKey(object4 + "")) {
                            return this.nodes.get(object4 + "");
                        }
                    }
                    if (TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnClass() == String.class) {
                        return object4 + "";
                    }
                    DLightExecutorService.submit((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnClass());
                            if (propertyEditor != null) {
                                propertyEditor.setValue(object4);
                                Object object = NodeModelImpl.this.nodesMapLock;
                                synchronized (object) {
                                    NodeModelImpl.this.nodes.put(object4 + "", propertyEditor.getAsText());
                                }
                                NodeModelImpl.this.fireNodeModelChanged(object2);
                            }
                        }
                    }, (String)"insight getDisplayName.. ");
                    return "...";
                }
                string = object3.toString();
                return string;
            }
            return "Unknown";
        }

        public String getIconBase(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            if (object == "Root") {
                return null;
            }
            if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof TreeTableNode) {
                return TreeTableVisualizer.this.getIcon((TreeTableNode)object2);
            }
            return null;
        }

        public String getShortDescription(Object object) {
            if (object == "Root") {
                return TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnUName();
            }
            if (object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                return ((TreeTableNode)defaultMutableTreeNode.getUserObject()).getValue() + "";
            }
            return "Unknown";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireNodeModelChanged(final Object object) {
            if (EventQueue.isDispatchThread()) {
                Object object2 = this.listenersLock;
                synchronized (object2) {
                    for (ModelListener modelListener : this.listeners) {
                        modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object));
                    }
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object2 = NodeModelImpl.this.listenersLock;
                        synchronized (object2) {
                            for (ModelListener modelListener : NodeModelImpl.this.listeners) {
                                modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)NodeModelImpl.this, object));
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener modelListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                if (this.listeners.contains(modelListener)) {
                    return;
                }
                this.listeners.add(modelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener modelListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(modelListener);
            }
        }

        public boolean canRename(Object object) throws UnknownTypeException {
            return false;
        }

        public boolean canCopy(Object object) throws UnknownTypeException {
            return false;
        }

        public boolean canCut(Object object) throws UnknownTypeException {
            return false;
        }

        public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
            return null;
        }

        public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
            return null;
        }

        public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
            return null;
        }

        public void setName(Object object, String string) throws UnknownTypeException {
        }

        public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
            return null;
        }
    }

    class TableModelImpl
    implements TableModel {
        private Vector<ModelListener> listeners = new Vector();

        TableModelImpl() {
        }

        public Object getValueAt(Object object, String string) throws UnknownTypeException {
            if (!(object instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(object);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof TreeTableNode) {
                return ((TreeTableNode)object2).getValue(string);
            }
            return "";
        }

        public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
            return true;
        }

        public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        }

        public void addModelListener(ModelListener modelListener) {
            this.listeners.add(modelListener);
        }

        void fireTableValueChanged() {
        }

        public void removeModelListener(ModelListener modelListener) {
            this.listeners.remove(modelListener);
        }
    }

    protected class TreeModelImpl
    implements TreeModel,
    TreeExpansionModel {
        private final Object listenersLock = new Object();
        private Vector<ModelListener> listeners = new Vector();

        protected TreeModelImpl() {
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
            Object object2 = object;
            if (object == "Root") {
                object2 = TreeTableVisualizer.this.TREE_ROOT;
            }
            if (object2 instanceof DefaultMutableTreeNode) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = n; i <= n2; ++i) {
                    if (i < 0 || i >= TreeTableVisualizer.this.treeModel.getChildCount(object2)) continue;
                    arrayList.add(TreeTableVisualizer.this.treeModel.getChild(object2, i));
                }
                return arrayList.toArray();
            }
            throw new UnknownTypeException(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireTreeModelChanged(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object = this.listenersLock;
            synchronized (object) {
                for (ModelListener modelListener : this.listeners) {
                    modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)TreeTableVisualizer.this, (Object)defaultMutableTreeNode));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireTreeModelChanged() {
            Object object = this.listenersLock;
            synchronized (object) {
                for (ModelListener modelListener : this.listeners) {
                    modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)TreeTableVisualizer.this));
                    modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)TreeTableVisualizer.this, (Object)"Root"));
                }
            }
        }

        public boolean isLeaf(Object object) {
            if (object == "Root") {
                return false;
            }
            if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(TreeTableVisualizer.this.configuration)) {
                return true;
            }
            return TreeTableVisualizer.this.timerHandler != null && TreeTableVisualizer.this.timerHandler.isSessionRunning();
        }

        public int getChildrenCount(Object object) throws UnknownTypeException {
            Object object2 = object;
            if (object == "Root") {
                object2 = TreeTableVisualizer.this.TREE_ROOT;
                return TreeTableVisualizer.this.treeModel.getChildCount(object2);
            }
            if (object2 instanceof DefaultMutableTreeNode) {
                if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(TreeTableVisualizer.this.configuration)) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener modelListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(modelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener modelListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(modelListener);
            }
        }

        public boolean isExpanded(Object object) throws UnknownTypeException {
            return false;
        }

        public void nodeExpanded(Object object) {
            if (object == "Root") {
                return;
            }
            if (!(object instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            List<TreeTableNode> list = Arrays.asList((TreeTableNode)defaultMutableTreeNode.getUserObject());
            TreeTableVisualizer.this.loadTree(defaultMutableTreeNode, list);
        }

        public void nodeCollapsed(Object object) {
        }
    }
}

