/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.visualizers.RefreshStateVisualizer;

public class VisualizerSessionsStateHandler
implements SessionStateListener,
DLightSessionListener {
    private DLightSession.SessionState currentSessionState = null;
    private final RefreshStateVisualizer vis;

    VisualizerSessionsStateHandler(RefreshStateVisualizer refreshStateVisualizer) {
        this.vis = refreshStateVisualizer;
        DLightManager dLightManager = DLightManager.getDefault();
        DLightSession dLightSession = dLightManager.getActiveSession();
        dLightManager.addDLightSessionListener((DLightSessionListener)this);
        dLightSession.addSessionStateListener((SessionStateListener)this);
        this.currentSessionState = dLightSession.getState();
    }

    protected boolean isSessionRunning() {
        return this.currentSessionState == DLightSession.SessionState.RUNNING;
    }

    protected boolean isSessionPaused() {
        return this.currentSessionState == DLightSession.SessionState.PAUSED;
    }

    protected boolean isSessionAnalyzed() {
        return this.currentSessionState == DLightSession.SessionState.ANALYZE;
    }

    public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        this.currentSessionState = sessionState2;
        if (sessionState2 == DLightSession.SessionState.PAUSED || sessionState2 == DLightSession.SessionState.ANALYZE) {
            return;
        }
        if (sessionState2 == DLightSession.SessionState.STARTING || sessionState2 == DLightSession.SessionState.RUNNING) {
            return;
        }
    }

    public void activeSessionChanged(DLightSession dLightSession, DLightSession dLightSession2) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
        }
        if (dLightSession2 != null) {
            dLightSession2.addSessionStateListener((SessionStateListener)this);
            this.sessionStateChanged(dLightSession2, DLightSession.SessionState.CONFIGURATION, dLightSession2.getState());
        }
    }

    public void sessionAdded(DLightSession dLightSession) {
    }

    public void sessionRemoved(DLightSession dLightSession) {
        if (dLightSession != null) {
            dLightSession.removeSessionStateListener((SessionStateListener)this);
        }
    }
}

