/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;

public class ThreadStateHeaderRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private ThreadsPanel viewManager;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;
    static int shift = 0;

    public ThreadStateHeaderRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getFont().getSize() + 11);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.timeLine = this.viewManager.getTimeLine();
        return this;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintResizableMark(graphics);
        this.paintTimeMarks(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void revalidate() {
    }

    public void validate() {
    }

    private void paintResizableMark(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(Color.BLACK);
        for (n2 = n = 4; n2 < this.getSize().height - n; n2 += 2) {
            graphics.drawLine(1, n2, 1, n2);
        }
        for (n2 = n + 1; n2 < this.getSize().height - n - 1; n2 += 2) {
            graphics.drawLine(0, n2, 0, n2);
        }
        graphics.setClip(4, 0, this.getWidth() - 3, this.getHeight());
    }

    private void paintTimeMarkString(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 2;
        Font font = graphics.getFont();
        Font font2 = font.deriveFont((float)(font.getSize() - 2));
        String string = TimeLineUtils.getTimeMarkNoMillisString(n, n2);
        int n7 = graphics.getFontMetrics().stringWidth(string);
        String string2 = TimeLineUtils.getTimeMarkMillisString(n, n2);
        if (!string2.equals("")) {
            string2 = "." + string2;
        }
        int n8 = n3 - n7 / 2 + 1;
        int n9 = n8 + n7 + n5;
        graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
        graphics.drawString(string, n8, n4);
        graphics.setFont(font2);
        graphics.drawString(string2, n9, n4 - n6 + 1);
        graphics.setFont(font);
    }

    private void paintTimeMarks(Graphics graphics) {
        graphics.setFont(graphics.getFont().deriveFont(1));
        if (this.viewEnd - this.viewStart > 0L) {
            long l;
            int n = (int)(this.viewStart - this.dataStart);
            int n2 = (int)(this.viewEnd - this.dataStart);
            float f = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int n3 = TimeLineUtils.getOptimalUnits(f);
            int n4 = Math.max((int)(Math.ceil((double)n / (double)n3) * (double)n3), 0);
            int n5 = this.getFont().getSize();
            for (int i = n4 - n3; i <= n2 + n3; i += n3) {
                if (i < 0) continue;
                float f2 = i - n;
                int n6 = (int)(f2 * f);
                this.paintTimeTicks(graphics, (int)(f2 * f), (int)((f2 + (float)n3) * f), TimeLineUtils.getTicksCount(n3));
                graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                graphics.drawLine(n6 += shift, 0, n6, 4);
                this.paintTimeMarkString(graphics, i, n3, n6, 5 + n5);
                graphics.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                graphics.drawLine(n6, 8 + n5, n6, this.getHeight() - 1);
            }
            Font font = graphics.getFont();
            Font font2 = font.deriveFont(0);
            String string = TimeLineUtils.getUnitsLegend(n2, n3);
            int n7 = graphics.getFontMetrics(font2).stringWidth(string);
            if (n7 + 7 <= this.getWidth()) {
                graphics.setFont(font2);
                graphics.setColor(Color.WHITE);
                graphics.fillRect(this.getWidth() - n7 - 6, 5, n7 + 7, 4 + font2.getSize());
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, this.getWidth() - n7 - 2, 5 + font2.getSize());
                graphics.setFont(font);
            }
            if (this.timeLine != null && this.viewStart < (l = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && l < this.viewEnd) {
                int n8 = (int)((long)this.getWidth() * (l - this.viewStart) / (this.viewEnd - this.viewStart));
                graphics.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
                graphics.drawLine((n8 += shift) - 3, 0, n8 - 3, 2);
                graphics.drawLine(n8 - 3, 2, n8, 5);
                graphics.drawLine(n8, 5, n8 + 3, 2);
                graphics.drawLine(n8 + 3, 2, n8 + 3, 0);
                graphics.drawLine(n8 + 3, 0, n8 - 3, 0);
            }
        }
    }

    private void paintTimeTicks(Graphics graphics, int n, int n2, int n3) {
        long l;
        float f = (float)(n2 - n) / (float)n3;
        for (int i = 1; i < n3; ++i) {
            int n4 = n + (int)((float)i * f);
            graphics.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
            graphics.drawLine(n4 += shift, 0, n4, 2);
            graphics.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
            graphics.drawLine(n4, 3, n4, this.getHeight() - 1);
        }
        if (this.timeLine != null && this.viewStart < (l = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && l < this.viewEnd) {
            int n5 = (int)((long)this.getWidth() * (l - this.viewStart) / (this.viewEnd - this.viewStart));
            graphics.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
            graphics.drawLine(n5 += shift, 6, n5, this.getHeight() - 1);
        }
    }
}

