/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapSummaryData;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.visualizers.threadmap.DataManagerListener;
import org.netbeans.modules.dlight.visualizers.threadmap.MonitoredData;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;

public class ThreadsDataManager {
    private final List<ThreadStateColumnImpl> threadData = new ArrayList<ThreadStateColumnImpl>();
    private boolean threadsMonitoringEnabled = true;
    private long endTime;
    private long startTime;
    private final Set<DataManagerListener> listeners = new HashSet<DataManagerListener>();
    private ThreadMapSummaryData summary;
    private ThreadMapDataProvider provider;
    private int threadNameFormat = 0;
    private ThreadNameUpdateTask updater = new ThreadNameUpdateTask();
    private ScheduledFuture<?> updateNameTask;
    private final Object lock = new Lock();
    private boolean fillThreadNames = false;

    public ThreadsDataManager() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(DataManagerListener dataManagerListener) {
        Set<DataManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(dataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(DataManagerListener dataManagerListener) {
        Set<DataManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(dataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataChanged() {
        HashSet<DataManagerListener> hashSet;
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet<DataManagerListener>(this.listeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((DataManagerListener)object.next()).dataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataReset() {
        HashSet<DataManagerListener> hashSet;
        Object object = this.listeners;
        synchronized (object) {
            hashSet = new HashSet<DataManagerListener>(this.listeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((DataManagerListener)object.next()).dataReset();
        }
    }

    public synchronized long getEndTimeStump() {
        return this.endTime;
    }

    public synchronized long getEndTime() {
        return ThreadStateColumnImpl.timeStampToMilliSeconds(this.endTime);
    }

    public synchronized long getStartTime() {
        return ThreadStateColumnImpl.timeStampToMilliSeconds(this.startTime);
    }

    public synchronized ThreadStateColumnImpl getThreadData(int n) {
        return this.threadData.get(n);
    }

    public synchronized String getThreadName(int n) {
        return this.threadData.get(n).getName();
    }

    public synchronized String findThreadName(int n) {
        for (int i = 0; i < this.threadData.size(); ++i) {
            if (this.threadData.get(i).getThreadID() != n) continue;
            return this.threadData.get(i).getName();
        }
        return "" + n;
    }

    public synchronized int getThreadsCount() {
        return this.threadData.size();
    }

    public synchronized void setThreadsMonitoringEnabled(boolean bl) {
        if (this.threadsMonitoringEnabled == bl) {
            return;
        }
        this.threadsMonitoringEnabled = bl;
        if (!this.threadsMonitoringEnabled) {
            for (int i = 0; i < this.threadData.size(); ++i) {
                this.threadData.get(i).clearStates();
            }
        }
    }

    public synchronized boolean hasData() {
        return this.getThreadsCount() != 0;
    }

    public synchronized void processData(ThreadMapSummaryData threadMapSummaryData) {
        this.summary = threadMapSummaryData;
    }

    public synchronized ThreadSummaryColumnImpl getThreadSummary(int n) {
        n = this.getThreadData(n).getThreadID();
        ThreadMapSummaryData threadMapSummaryData = this.summary;
        List list = null;
        if (threadMapSummaryData != null) {
            for (ThreadSummaryData threadSummaryData : threadMapSummaryData.getThreadsData()) {
                if (threadSummaryData.getThreadInfo().getThreadId() != n) continue;
                list = threadSummaryData.getThreadSummary();
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return new ThreadSummaryColumnImpl(list);
    }

    public synchronized void processData(MonitoredData monitoredData, DLightSession dLightSession, ThreadMapDataProvider threadMapDataProvider, long l) {
        int n = monitoredData.getThreadsSize();
        if (n == 0) {
            return;
        }
        this.mergeData(monitoredData, l);
        n = this.threadData.size();
        if (n == 0) {
            return;
        }
        if (this.provider == null) {
            this.provider = threadMapDataProvider;
        }
        this.startTime = dLightSession.getStartTime();
        this.endTime = 0L;
        if (this.threadsMonitoringEnabled) {
            for (int i = 0; i < n; ++i) {
                ThreadStateColumnImpl threadStateColumnImpl = this.threadData.get(i);
                this.endTime = Math.max(this.endTime, threadStateColumnImpl.getThreadStateAt(threadStateColumnImpl.size() - 1).getTimeStamp());
            }
            this.fireDataChanged();
        }
        if (this.fillThreadNames) {
            this.fillThreadNames = false;
            this.setThreadNameFormat();
        }
    }

    private void mergeData(MonitoredData monitoredData, long l) {
        ThreadData threadData;
        int n;
        int n2 = monitoredData.getThreadsSize();
        if (n2 == 0) {
            return;
        }
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        for (n = 0; n < n2; ++n) {
            ThreadInfo threadInfo = monitoredData.getThreadInfo(n);
            linkedHashMap.put(threadInfo.getThreadId(), n);
        }
        n = this.threadData.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.threadData.get(i);
            Integer n3 = (Integer)linkedHashMap.get(((ThreadStateColumnImpl)object).getThreadID());
            if (n3 == null) continue;
            long l2 = ((ThreadStateColumnImpl)object).getThreadStateAt(((ThreadStateColumnImpl)object).size() - 1).getTimeStamp();
            if (l == 0L) {
                ((ThreadStateColumnImpl)object).clearStates();
                l2 = -1L;
            }
            int n4 = n3;
            threadData = monitoredData.getThreadStates(n4);
            for (int j = 0; j < threadData.size(); ++j) {
                ThreadState threadState = (ThreadState)threadData.get(j);
                if (threadState.getTimeStamp() > l2) {
                    ((ThreadStateColumnImpl)object).add(threadState);
                }
                ((ThreadStateColumnImpl)object).updateStackProvider(monitoredData.getStackProvider(n4));
            }
            linkedHashMap.remove(((ThreadStateColumnImpl)object).getThreadID());
        }
        for (Object object : linkedHashMap.values()) {
            int n5 = (Integer)object;
            List<ThreadState> list = monitoredData.getThreadStates(n5);
            int n6 = list.size();
            if (n6 <= 0) continue;
            MergedThreadInfo mergedThreadInfo = new MergedThreadInfo(monitoredData.getThreadInfo(n5), monitoredData.getStartTimestamp(n5));
            threadData = monitoredData.getStackProvider(n5);
            ThreadStateColumnImpl threadStateColumnImpl = new ThreadStateColumnImpl(mergedThreadInfo, threadData);
            this.threadData.add(threadStateColumnImpl);
            for (int i = 0; i < n6; ++i) {
                threadStateColumnImpl.add(list.get(i));
            }
        }
    }

    public synchronized void startup(DLightSession.SessionState sessionState) {
        if (sessionState == DLightSession.SessionState.ANALYZE) {
            if (this.updateNameTask != null) {
                this.updateNameTask.cancel(true);
            }
            this.fillThreadNames = true;
        } else if (this.updateNameTask == null || this.updateNameTask.isDone()) {
            this.updateNameTask = DLightExecutorService.scheduleAtFixedRate((Runnable)this.updater, (long)5L, (TimeUnit)TimeUnit.SECONDS, (String)"updateNameTask");
        }
    }

    public synchronized void shutdown(DLightSession.SessionState sessionState) {
        if (this.updateNameTask != null) {
            this.updateNameTask.cancel(true);
        }
        if (sessionState == DLightSession.SessionState.ANALYZE) {
            this.fillThreadNames = true;
        }
    }

    public synchronized void reset() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.provider = null;
        this.threadData.clear();
        this.fireDataReset();
    }

    public ThreadsDataManager(long l, long l2, ThreadMapSummaryData threadMapSummaryData, ThreadMapDataProvider threadMapDataProvider) {
        this.endTime = l;
        this.startTime = l2;
        this.summary = threadMapSummaryData;
        this.provider = threadMapDataProvider;
    }

    void setThreadNameFormat(int n, boolean bl) {
        if (this.threadNameFormat != n) {
            this.threadNameFormat = n;
            if (bl) {
                return;
            }
            this.setThreadNameFormat();
        }
    }

    private void setThreadNameFormat() {
        switch (this.threadNameFormat) {
            case 1: 
            case 2: {
                DLightExecutorService.submit((Runnable)this.updater, (String)"urgentUpdateNameTask");
                break;
            }
            default: {
                for (ThreadStateColumnImpl threadStateColumnImpl : this.threadData) {
                    threadStateColumnImpl.resetName();
                }
                this.fireDataChanged();
            }
        }
    }

    int getThreadNameFormat() {
        return this.threadNameFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateThreadNames() {
        ThreadMapDataProvider threadMapDataProvider = this.provider;
        if (this.threadNameFormat == 0 || threadMapDataProvider == null) {
            this.fireDataChanged();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Collection collection;
            ThreadSnapshotQuery threadSnapshotQuery;
            ThreadSnapshotQuery.TimeFilter timeFilter;
            block16: {
                timeFilter = new ThreadSnapshotQuery.TimeFilter(0L, Long.MAX_VALUE, ThreadSnapshotQuery.TimeFilter.Mode.FIRST);
                threadSnapshotQuery = new ThreadSnapshotQuery(true, new ThreadSnapshotQuery.Filter[]{timeFilter});
                collection = threadMapDataProvider.getThreadSnapshots(threadSnapshotQuery);
                if (collection == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 7, 14] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.fireDataChanged();
                    return;
                }
                if (this.threadNameFormat != 0) break block16;
                // MONITOREXIT @DISABLED, blocks:[0, 2, 7] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                this.fireDataChanged();
                return;
            }
            try {
                int n = this.threadNameFormat + 1;
                if (n <= 0) return;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    int n2;
                    ThreadSnapshot threadSnapshot = (ThreadSnapshot)iterator.next();
                    int n3 = threadSnapshot.getThreadInfo().getThreadId();
                    int n4 = n2 = n3 == 1 ? 1 : n;
                    if (!this.isValidDump(threadSnapshot, n2)) {
                        timeFilter = new ThreadSnapshotQuery.TimeFilter(threadSnapshot.getTimestamp(), threadSnapshot.getTimestamp() + 50000000L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                        ThreadSnapshotQuery.ThreadFilter threadFilter = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList(n3));
                        threadSnapshotQuery = new ThreadSnapshotQuery(true, new ThreadSnapshotQuery.Filter[]{timeFilter, threadFilter});
                        threadSnapshot = null;
                        for (ThreadSnapshot threadSnapshot2 : threadMapDataProvider.getThreadSnapshots(threadSnapshotQuery)) {
                            if (!this.isValidDump(threadSnapshot2, n2)) continue;
                            threadSnapshot = threadSnapshot2;
                        }
                    }
                    if (threadSnapshot == null) continue;
                    this.updateName(((FunctionCall)threadSnapshot.getStack().get(n2)).getFunction().getQuilifiedName(), n3);
                }
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private boolean isValidDump(ThreadSnapshot threadSnapshot, int n) {
        String string;
        return threadSnapshot.getStack().size() > n && ("_start".equals(string = ((FunctionCall)threadSnapshot.getStack().get(0)).getFunction().getQuilifiedName()) || "_lwp_start".equals(string));
    }

    private void updateName(String string, int n) {
        for (ThreadStateColumnImpl threadStateColumnImpl : this.threadData) {
            if (threadStateColumnImpl.getThreadID() != n) continue;
            threadStateColumnImpl.updateName(string + " (" + n + ")");
            break;
        }
    }

    private final class ThreadNameUpdateTask
    implements Runnable {
        private ThreadNameUpdateTask() {
        }

        public void run() {
            ThreadsDataManager.this.updateThreadNames();
        }
    }

    private static final class ProcessID {
        private final ThreadInfo info;
        private final long startTimeStamp;

        private ProcessID(ThreadInfo threadInfo, long l) {
            this.info = threadInfo;
            this.startTimeStamp = l;
        }

        private int getId() {
            return this.info.getThreadId();
        }

        private ThreadInfo getThreadInfo() {
            return this.info;
        }

        private long getStartTimeStamp() {
            return this.startTimeStamp;
        }
    }

    static class MergedThreadInfo {
        private String name;
        private final LinkedList<ProcessID> processes = new LinkedList();

        private MergedThreadInfo(ThreadInfo threadInfo, long l) {
            this.name = threadInfo.getThreadName();
            this.processes.add(new ProcessID(threadInfo, l));
        }

        String getThreadName() {
            return this.name;
        }

        void setThreadName(String string) {
            this.name = string;
        }

        int getThreadId() {
            return this.processes.getFirst().getId();
        }

        void resetName() {
            this.name = this.processes.getFirst().getThreadInfo().getThreadName();
        }

        long getStartTimeStamp() {
            return this.processes.getFirst().getStartTimeStamp();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

