/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.php;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasClientPhpAuthenticationGenerator
extends SaasClientAuthenticationGenerator {
    public static final String INDENT = "             ";
    private FileObject saasAuthFile;
    private FileObject loginFile;
    private FileObject callbackFile;

    public SaasClientPhpAuthenticationGenerator(SaasBean saasBean, Project project) {
        super(saasBean, project);
    }

    public String getPreAuthenticationCode() {
        String string = "";
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.API_KEY) {
            string = string + "             $apiKey = " + this.getBean().getAuthenticatorClassName() + "::getApiKey();";
        } else if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            string = string + INDENT + this.getBean().getAuthenticatorClassName() + "::login(" + this.getLoginArguments() + ");\n";
            List list = sessionKeyAuthentication.getParameters();
            String string2 = "";
            if (list != null && list.size() > 0) {
                string2 = SaasClientPhpAuthenticationGenerator.getSignParamDeclaration(this.getBean(), list, Collections.<ParameterInfo>emptyList());
            }
            String string3 = sessionKeyAuthentication.getSigKeyName();
            string2 = string2 + "             $sign_params = array();\n";
            for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
                if (parameterInfo.getName().equals(string3)) continue;
                string2 = string2 + "             $sign_params[\"" + parameterInfo.getName() + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n";
            }
            string2 = string2 + "             $" + Util.getVariableName((String)string3) + " = " + this.getBean().getAuthenticatorClassName() + "::sign($sign_params);\n";
            string = string + string2;
        } else if (saasAuthenticationType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            string = string + INDENT + this.getBean().getAuthenticatorClassName() + "::login(" + this.getLoginArguments() + ");\n";
        }
        return string;
    }

    public String getPostAuthenticationCode() {
        String string = "";
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SIGNED_URL) {
            SaasBean.SignedUrlAuthentication signedUrlAuthentication = (SaasBean.SignedUrlAuthentication)this.getBean().getAuthentication();
            List list = signedUrlAuthentication.getParameters();
            if (list != null && list.size() > 0) {
                String string2 = SaasClientPhpAuthenticationGenerator.getSignParamDeclaration(this.getBean(), list, this.getBean().getInputParameters());
                string2 = string2 + "             $sign_params = array();\n";
                for (ParameterInfo parameterInfo : list) {
                    string2 = string2 + "             $sign_params[\"" + parameterInfo.getName() + "\"] = $" + Util.getVariableName((String)parameterInfo.getName()) + ";\n";
                }
                string2 = string2 + "             $" + Util.getVariableName((String)signedUrlAuthentication.getSigKeyName()) + " = " + this.getBean().getAuthenticatorClassName() + "::sign($sign_params);\n";
                string = string + string2;
            }
        } else if (saasAuthenticationType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            String string3 = "";
            try {
                string3 = this.getSaasServiceFolder().getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            string = string + "             $username = " + this.getBean().getAuthenticatorClassName() + "::getSession(\"" + string3 + "username\");\n";
            string = string + "             $password = " + this.getBean().getAuthenticatorClassName() + "::getSession(\"" + string3 + "password\");\n";
            string = string + "             $conn->setAuthentication($username, $password);\n";
        }
        return string;
    }

    public void createAuthenticatorClass() throws IOException {
        String string;
        FileObject fileObject;
        block11: {
            Object object;
            block10: {
                DataObject dataObject;
                fileObject = this.getSaasServiceFolder();
                if (this.getBean().isUseTemplates()) break block10;
                if (this.saasAuthFile != null) break block11;
                string = this.getBean().getAuthenticatorClassName();
                String string2 = null;
                Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
                if (saasAuthenticationType == Constants.SaasAuthenticationType.API_KEY || saasAuthenticationType == Constants.SaasAuthenticationType.HTTP_BASIC || saasAuthenticationType == Constants.SaasAuthenticationType.SIGNED_URL || saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
                    string2 = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                }
                if (string2 == null || (dataObject = Util.createDataObjectFromTemplate((String)(string2 + "Authenticator" + "." + "php"), (FileObject)fileObject, (String)string)) == null) break block11;
                this.saasAuthFile = dataObject.getPrimaryFile();
                break block11;
            }
            string = null;
            if (this.getBean().getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                object = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
                string = object.getUseTemplates();
            } else if (this.getBean().getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                object = (SaasBean.HttpBasicAuthentication)this.getBean().getAuthentication();
                string = object.getUseTemplates();
            }
            if (string != null) {
                object = this.getDropFileType().prefix();
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : string.getTemplates()) {
                    String string3;
                    FileObject fileObject2;
                    if (!template.getDropTypeList().contains(object)) continue;
                    String string4 = template.getId();
                    String string5 = template.getType();
                    String string6 = template.getUrl();
                    if (!string6.contains("Authenticator") || (fileObject2 = fileObject.getFileObject(string3 = this.getBean().getAuthenticatorClassName())) != null) continue;
                    Util.createDataObjectFromTemplate((String)string6, (FileObject)fileObject, (String)string3);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("__GROUP__", fileObject.getName());
                    SaasClientPhpAuthenticationGenerator.replaceTokens(fileObject.getFileObject(string3, "php"), hashMap);
                }
            }
        }
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            string = this.getBean().getAuthenticatorClassName() + "Profile";
            if (this.getAuthenticationProfile() != null && !this.getAuthenticationProfile().trim().equals("")) {
                try {
                    Util.createDataObjectFromTemplate((String)this.getAuthenticationProfile(), (FileObject)fileObject, (String)string);
                }
                catch (Exception exception) {
                    throw new IOException("Profile file specified in saas-services/service-metadata/authentication/@profile, not found: " + this.getAuthenticationProfile());
                }
            }
        }
    }

    public void createAuthorizationClasses() throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            List list = this.getAuthenticatorMethodParameters();
            String[] stringArray = Util.getGetParamNames((List)list);
            Object[] objectArray = Util.getGetParamTypes((List)list);
            SaasClientPhpAuthenticationGenerator.createSessionKeyAuthorizationClassesForWeb(this.getBean(), this.getProject(), this.getBean().getSaasName(), this.getBean().getSaasServicePackageName(), this.getSaasServiceFolder(), this.loginFile, this.callbackFile, stringArray, objectArray, this.getBean().isUseTemplates(), this.getDropFileType());
        }
    }

    public void modifyAuthenticationClass() throws IOException {
    }

    public void modifyAuthenticationClass(String string, Object[] objectArray, Object object, String string2, String[] stringArray, Object[] objectArray2, Object[] objectArray3, String string3) throws IOException {
    }

    public String getLoginBody(SaasBean saasBean, String string, String string2) throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyLoginBodyForWeb((SaasBean)saasBean, (String)string, (String)string2);
        }
        String string3 = "";
        return string3;
    }

    public String getLogoutBody() {
        String string = "";
        return string;
    }

    public String getTokenBody(SaasBean saasBean, String string, String string2, String string3) throws IOException {
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyTokenBodyForWeb((SaasBean)saasBean, (String)string, (String)string2, (String)string3);
        }
        String string4 = this.getBean().getAuthorizationFrameClassName();
        String string5 = "";
        return string5;
    }

    public String getSignParamUsage(List<ParameterInfo> list, String string) {
        return Util.getSignParamUsage(list, (String)string, (boolean)this.getBean().isDropTargetWeb());
    }

    public static String getSignParamDeclaration(SaasBean saasBean, List<ParameterInfo> list, List<ParameterInfo> list2) {
        String string = "";
        for (ParameterInfo parameterInfo : list) {
            String[] stringArray = SaasClientPhpAuthenticationGenerator.getParamIds(parameterInfo, saasBean.getSaasName(), saasBean.isDropTargetWeb());
            if (stringArray != null) {
                string = string + "             $" + Util.getVariableName((String)stringArray[0]) + " = " + stringArray[1] + ";\n";
                continue;
            }
            if (Util.isContains((ParameterInfo)parameterInfo, list2)) continue;
            string = string + "             $" + Util.getVariableName((String)parameterInfo.getName()) + " = ";
            if (parameterInfo.getFixed() != null) {
                string = string + "\"" + parameterInfo.getFixed() + "\";\n";
                continue;
            }
            if (parameterInfo.getType() == Date.class) {
                string = string + "$conn->getDate();\n";
                continue;
            }
            if (parameterInfo.getType() == SaasBean.Time.class) {
                string = string + "RestConnection::currentTimeMillis();\n";
                continue;
            }
            if (parameterInfo.getType() == Constants.HttpMethodType.class) {
                string = string + "\"" + saasBean.getHttpMethod().value() + "\";\n";
                continue;
            }
            if (parameterInfo.isRequired()) {
                if (parameterInfo.getDefaultValue() != null) {
                    string = string + SaasClientPhpAuthenticationGenerator.getQuotedValue(parameterInfo.getDefaultValue().toString()) + ";\n";
                    continue;
                }
                string = string + "\"\";\n";
                continue;
            }
            if (parameterInfo.getDefaultValue() != null) {
                string = string + SaasClientPhpAuthenticationGenerator.getQuotedValue(parameterInfo.getDefaultValue().toString()) + ";\n";
                continue;
            }
            string = string + "null;\n";
        }
        string = string + "\n";
        return string;
    }

    public static String getQuotedValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.replace("+", "&plus;").split("&plus;");
        for (String string2 : stringArray) {
            if (SaasClientPhpAuthenticationGenerator.isWord(string2)) {
                stringBuffer.append("$" + string2.trim() + ".");
                continue;
            }
            stringBuffer.append(string2 + ".");
        }
        Object object = stringBuffer.toString();
        if (stringArray.length > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return Util.getQuotedValue((String)object);
    }

    public static boolean isWord(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        String string2 = string.trim();
        for (char c : string2.toCharArray()) {
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static String[] getParamIds(ParameterInfo parameterInfo, String string, boolean bl) {
        String[] stringArray;
        if (parameterInfo.getId() != null && (stringArray = parameterInfo.getId().split("=")).length == 2) {
            String string2 = stringArray[1];
            if (string2.startsWith("{")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("}")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string2 = Util.getVariableName((String)string2);
            string2 = Util.getAuthenticatorClassName((String)string) + "::" + "get" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            string2 = string2 + "()";
            return new String[]{stringArray[0], string2};
        }
        return null;
    }

    public static void createSessionKeyAuthorizationClassesForWeb(SaasBean saasBean, Project project, String string, String string2, FileObject fileObject, FileObject fileObject2, FileObject fileObject3, String[] stringArray, Object[] objectArray, boolean bl, Constants.DropFileType dropFileType) throws IOException {
        Constants.SaasAuthenticationType saasAuthenticationType = saasBean.getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY || saasAuthenticationType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            Object object;
            SaasBean.SaasAuthentication.UseTemplates useTemplates = null;
            if (saasBean.getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                object = (SaasBean.SessionKeyAuthentication)saasBean.getAuthentication();
                useTemplates = object.getUseTemplates();
            } else if (saasBean.getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                object = (SaasBean.HttpBasicAuthentication)saasBean.getAuthentication();
                useTemplates = object.getUseTemplates();
            }
            if (useTemplates != null) {
                object = dropFileType.prefix();
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : useTemplates.getTemplates()) {
                    DataObject dataObject;
                    if (!template.getDropTypeList().contains(object)) continue;
                    String string3 = template.getId();
                    String string4 = template.getType() == null ? "" : template.getType();
                    String string5 = template.getUrl();
                    if (string5 == null || string5.trim().equals("")) {
                        throw new IOException("Authentication template is empty.");
                    }
                    if (string5.contains("Desktop")) continue;
                    String string6 = null;
                    if (string5.contains("Login")) {
                        string6 = saasBean.getSaasName() + Util.upperFirstChar((String)"login");
                    } else if (string5.contains("Callback")) {
                        string6 = saasBean.getSaasName() + Util.upperFirstChar((String)"callback");
                    } else if (string5.contains("Authenticator")) continue;
                    FileObject fileObject4 = null;
                    if (string6 != null && (fileObject4 = fileObject.getFileObject(string6)) == null && (dataObject = Util.createDataObjectFromTemplate((String)string5, (FileObject)fileObject, (String)string6)) != null) {
                        fileObject4 = dataObject.getPrimaryFile();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("__GROUP__", fileObject.getName());
                        SaasClientPhpAuthenticationGenerator.replaceTokens(fileObject.getFileObject(string6, "php"), hashMap);
                    }
                    if (fileObject4 == null) continue;
                    if (string4.equals("login")) {
                        fileObject2 = fileObject4;
                        continue;
                    }
                    if (!string4.equals("callback")) continue;
                    fileObject3 = fileObject4;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceTokens(FileObject fileObject, Map<String, String> map) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string2 = entry.getKey();
                    String string3 = entry.getValue();
                    string = string.replaceAll(string2, string3);
                }
                stringBuffer.append(string + "\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            try {
                outputStreamWriter.write(stringBuffer.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }
}

