/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

abstract class WrappedLabel
extends JPanel {
    private static final long serialVersionUID = 1123746185724284730L;
    private String myText;
    private Mode myMode;
    private List<String> myList;
    private int myWidth = -1;

    WrappedLabel() {
    }

    public void paintComponent(Graphics graphics) {
        this.fillWrapList(graphics);
        int n = graphics.getFontMetrics().getHeight();
        int n2 = 1;
        for (String string : this.myList) {
            graphics.drawString(string, 0, (n2 - 1) * n + graphics.getFontMetrics().getAscent());
            ++n2;
        }
        int n3 = this.myList.size() * n;
        this.setPreferredSize(new Dimension(this.getPreferedWidth(), n3));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        this.revalidate();
    }

    public String getText() {
        return this.myText;
    }

    public void setText(String string) {
        this.myText = string == null || string.length() == 0 ? " " : string;
    }

    protected Mode getMode() {
        return this.myMode;
    }

    protected int getLabelHeight() {
        return -1;
    }

    protected int getPreferedWidth() {
        if (this.myWidth == -1) {
            return this.getLabelWidth();
        }
        return this.myWidth;
    }

    protected void setPreferedWidth(int n) {
        this.myWidth = n;
    }

    protected abstract int getLabelWidth();

    protected void setMode(Mode mode) {
        this.myMode = mode;
    }

    protected String getSuffix() {
        if (this.getMode() == Mode.WRAP_ON) {
            return NbBundle.getMessage(WrappedLabel.class, (String)"TXT_NoWrapSign");
        }
        if (this.getMode() == Mode.DEFAULT) {
            return "";
        }
        return null;
    }

    private Dimension getLabelSize() {
        int n = this.getLabelHeight();
        if (n == -1) {
            n = (int)super.getSize().getHeight();
        }
        return new Dimension(this.getPreferedWidth(), n);
    }

    private void fillWrapList(Graphics graphics) {
        int n;
        boolean bl;
        if (this.myList == null) {
            this.myList = new LinkedList<String>();
        }
        String string = this.getText();
        int n2 = this.getPreferedWidth();
        double d = graphics.getFontMetrics().getStringBounds("a", graphics).getWidth();
        int n3 = (int)((double)n2 / d);
        this.myList.clear();
        boolean bl2 = bl = this.getSuffix() != null;
        while ((n = this.getWrapIndex(string, graphics, n2, n3)) != string.length()) {
            if (n == 0) {
                return;
            }
            String string2 = string.substring(0, n);
            if (bl) {
                string2 = string2 + this.getSuffix();
            }
            this.myList.add(string2);
            if (bl) {
                string = "";
                break;
            }
            string = string.substring(n);
        }
        if (string.length() > 0) {
            this.myList.add(string);
        }
    }

    private int getWrapIndex(String string, Graphics graphics, double d, int n) {
        double d2;
        if (graphics.getFontMetrics().getStringBounds(string, graphics).getWidth() <= d) {
            return string.length();
        }
        if (string.length() == 0) {
            return string.length();
        }
        if (n >= string.length()) {
            n = string.length();
        }
        if ((d2 = graphics.getFontMetrics().getStringBounds(this.getSubstring(string, n), graphics).getWidth()) <= d) {
            for (int i = n; i <= string.length(); ++i) {
                double d3 = graphics.getFontMetrics().getStringBounds(this.getSubstring(string, i), graphics).getWidth();
                if (!(d3 > d)) continue;
                return i - 1;
            }
            return string.length();
        }
        for (int i = n; i >= 0; --i) {
            double d4 = graphics.getFontMetrics().getStringBounds(this.getSubstring(string, i), graphics).getWidth();
            if (!(d4 <= d)) continue;
            return i;
        }
        return string.length();
    }

    private String getSubstring(String string, int n) {
        if (this.getSuffix() == null) {
            return string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        return stringBuilder.delete(n, string.length()).append(this.getSuffix()).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        WRAP_ON(2),
        WRAP_OFF(1),
        DEFAULT(0);

        private final int myMode;

        private Mode(int n2) {
            this.myMode = n2;
        }

        public static Mode forInt(int n) {
            for (Mode mode : Mode.values()) {
                if (mode.myMode != n) continue;
                return mode;
            }
            return DEFAULT;
        }
    }
}

