/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.debug.util.JspNameUtil;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;

public class Utils {
    private static Logger err = Logger.getLogger("org.netbeans.modules.web.debug");
    private static final boolean LOG = err.isLoggable(Level.FINE);

    public static Logger getEM() {
        return err;
    }

    public static void log(String string) {
        if (LOG) {
            err.log(Level.FINE, string);
        }
    }

    public static FileObject getFileObjectFromUrl(String string) {
        FileObject fileObject = null;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fileObject;
    }

    public static boolean isJsp(FileObject fileObject) {
        return fileObject != null && "text/x-jsp".equals(fileObject.getMIMEType());
    }

    public static boolean isJsp(String string) {
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        return Utils.isJsp(fileObject);
    }

    public static boolean isTag(FileObject fileObject) {
        return fileObject != null && "text/x-tag".equals(fileObject.getMIMEType());
    }

    public static boolean isTag(String string) {
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        return Utils.isTag(fileObject);
    }

    public static String getTargetServerID(FileObject fileObject) {
        J2eeModuleProvider j2eeModuleProvider;
        Project project;
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            String string = j2eeModuleProvider.getServerID();
            return string;
        }
        return null;
    }

    public static String getJspName(String string) {
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        if (fileObject != null) {
            return fileObject.getNameExt();
        }
        return string == null ? null : string.toString();
    }

    public static String getJspPath(String string) {
        WebModule webModule;
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        String string2 = string;
        if (fileObject != null && (webModule = WebModule.getWebModule((FileObject)fileObject)) != null) {
            string2 = FileUtil.getRelativePath((FileObject)webModule.getDocumentBase(), (FileObject)fileObject);
        }
        return string2;
    }

    public static String getServletClass(String string) {
        String string2;
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        if (fileObject == null) {
            return null;
        }
        JSPServletFinder jSPServletFinder = JSPServletFinder.findJSPServletFinder((FileObject)fileObject);
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return null;
        }
        FileObject fileObject2 = webModule.getDocumentBase();
        if (fileObject2 != null) {
            string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            if (string2 == null) {
                return null;
            }
        } else {
            string2 = fileObject.getPath();
        }
        String string3 = webModule.getContextPath();
        String string4 = jSPServletFinder.getServletResourcePath(string2);
        if (string4 == null) {
            string4 = JspNameUtil.getServletResourcePath(string3, string2);
        }
        if (string4 != null) {
            string4 = string4.substring(0, string4.length() - 5);
            string4 = string4.replace('/', '.');
        }
        Utils.log("servlet class: " + string4);
        return string4;
    }

    public static String getClassFilter(String string) {
        String string2 = Utils.getServletClass(string);
        if (string2 != null && (string2 = string2.substring(0, string2.lastIndexOf(46)) + ".*").startsWith("org.apache.jsp")) {
            string2 = "org.apache.jsp.*";
        }
        return string2;
    }

    public static String getContextPath(String string) {
        FileObject fileObject = Utils.getFileObjectFromUrl(string);
        if (fileObject == null) {
            return null;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null) {
            return webModule.getContextPath();
        }
        return null;
    }

    public static String getJavaIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static boolean isScriptlet(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            while (n2 > 0) {
                int n4;
                Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
                if (element == null) continue;
                int n5 = element.getStartOffset();
                String string = styledDocument.getText(n5, n4 = element.getEndOffset() - n5);
                if (string != null && string.length() > 1) {
                    for (int i = n2 == NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n) ? n3 : n4 - 1; i > 0; --i) {
                        if (string.charAt(i) == '%' && string.charAt(i - 1) == '<') {
                            return true;
                        }
                        if (string.charAt(i) != '>' || string.charAt(i - 1) != '%') continue;
                        return false;
                    }
                }
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public static String getELIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            if (string.startsWith("$") && string.endsWith("}")) {
                return string;
            }
            return null;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && string.charAt(n5) != '$'; --n5) {
            }
            if (n5 > 0 && string.charAt(n5) == '$' && string.charAt(n5 - 1) == '\\') {
                return null;
            }
            for (n4 = n3; n4 < n7 && n4 > 0 && n4 <= string.length() && string.charAt(n4 - 1) != '}'; ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            String string2 = string.substring(n5, n4);
            if (string2.startsWith("$") && string2.endsWith("}")) {
                return string2;
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static String getJavaIdentifier() {
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return null;
        }
        return Utils.getJavaIdentifier((StyledDocument)jEditorPane.getDocument(), jEditorPane, jEditorPane.getCaret().getDot());
    }

    public static boolean isScriptlet() {
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return false;
        }
        return Utils.isScriptlet((StyledDocument)jEditorPane.getDocument(), jEditorPane, jEditorPane.getCaret().getDot());
    }
}

